/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldResources;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StatusInfo;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.TypedElementSelectionValidator;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.TypedViewerFilter;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SourceFolderButtonDialogField
extends StringButtonDialogField {
    private static Logger _log = JSFUICommonPlugin.getLogger(SourceFolderButtonDialogField.class);
    private IPackageFragmentRoot _fCurrRoot;
    private IProject _project;

    public SourceFolderButtonDialogField(IProject project) {
        super(null);
        this._project = project;
        this.setLabelText(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.container.label"));
        this.setButtonLabel(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.container.button"));
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SourceFolderButtonDialogField.this.containerChangeControlPressed(field);
            }
        });
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    protected void containerChangeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if ((root = this.chooseSourceContainer((IJavaElement)root)) != null) {
            this.setPackageFragmentRoot(root, true);
        }
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this._fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.setText(str);
        this.setEnabled(canBeModified);
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this._fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.getText();
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){};
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        _log.error(e);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.ChooseSourceContainerDialog.Title"));
        dialog.setMessage(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.ChooseSourceContainerDialog.Description"));
        dialog.addFilter((ViewerFilter)filter);
        if (this._project != null) {
            dialog.setInput((Object)JavaCore.create((IProject)this._project));
        } else {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        }
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    public IStatus getChangedStatus() {
        StatusInfo status = new StatusInfo();
        this._fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.EnterContainerName"));
            return status;
        }
        Path path = new Path(str);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ProjectClosed", proj.getFullPath().toString()));
                    return status;
                }
                if (this._project != null && proj != this._project) {
                    status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.NotSameProject", this._project.getName()));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                this._fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotAJavaProject", proj.getName()));
                            } else {
                                status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotInAJavaProject", proj.getName()));
                            }
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotAJavaProject", proj.getName()));
                    }
                    if (!jproject.isOnClasspath((IJavaElement)this._fCurrRoot)) {
                        status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotOnClassPath", str));
                    }
                    if (this._fCurrRoot.isArchive()) {
                        status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ContainerIsBinary", str));
                        return status;
                    }
                }
                return status;
            }
            status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.NotAFolder", str));
            return status;
        }
        status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ContainerDoesNotExist", str));
        return status;
    }
}

