/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.navigator;

import io.fabric8.camel.facade.CamelFacade;
import io.fabric8.camel.facade.mbean.CamelRouteMBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IInvocationStatistics;
import org.fusesource.fon.util.messages.INodeStatistics;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;
import org.fusesource.fon.util.messages.InvocationStatistics;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.AbstractNodeFacade;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import org.fusesource.ide.fabric.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.fabric.camel.navigator.RouteNode;
import org.fusesource.ide.fabric.camel.navigator.stats.model.HasTotalStatistics;
import org.fusesource.ide.fabric.camel.navigator.stats.model.IProcessorStatistics;
import org.fusesource.ide.fabric.camel.navigator.stats.model.IProcessorStatisticsContainer;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class RoutesNode
extends RefreshableCollectionNode
implements AbstractNodeFacade,
ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider,
HasTotalStatistics {
    private final CamelContextNode camelContextNode;
    private RouteContainer routeContainer;

    public RoutesNode(CamelContextNode camelContextNode) {
        super((Node)camelContextNode);
        this.camelContextNode = camelContextNode;
    }

    public String toString() {
        return "Routes";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public CamelFacade getFacade() {
        return this.camelContextNode.getFacade();
    }

    public CamelContextNode getCamelContextNode() {
        return this.camelContextNode;
    }

    protected void loadChildren() {
        HashMap<String, RouteNode> routeMap = new HashMap<String, RouteNode>();
        this.routeContainer = this.getCamelContextNode().getModelContainer();
        if (this.routeContainer != null) {
            List children = this.routeContainer.getChildren();
            for (AbstractNode node : children) {
                if (!(node instanceof RouteSupport)) continue;
                RouteSupport route = (RouteSupport)node;
                RouteNode routeNode = new RouteNode(this, route);
                String id = route.getId();
                if (id != null) {
                    routeMap.put(id, routeNode);
                }
                this.addChild((Node)routeNode);
            }
        }
        try {
            List routeMBeans = this.getFacade().getRoutes(this.getManagementName());
            for (CamelRouteMBean mbean : routeMBeans) {
                RouteNode node;
                String routeId = mbean.getRouteId();
                if (routeId == null || (node = (RouteNode)((Object)routeMap.get(routeId))) == null) continue;
                node.setRouteMBean(mbean);
            }
        }
        catch (Exception e) {
            Activator.getLogger().warning((Throwable)e);
        }
    }

    public String getCamelContextId() {
        return this.camelContextNode.getContextId();
    }

    public String getManagementName() {
        return this.camelContextNode.getManagementName();
    }

    public List<IExchange> browseExchanges() {
        return this.getCamelContextNode().browseExchanges();
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.getCamelContextNode().getNodeStatisticsContainer();
    }

    @Override
    public IInvocationStatistics getTotalStatistics() {
        NodeStatisticsContainer container = this.getNodeStatisticsContainer();
        if (container instanceof IProcessorStatisticsContainer) {
            IProcessorStatisticsContainer processorContainer = (IProcessorStatisticsContainer)container;
            Map<String, IProcessorStatistics> map = processorContainer.getNodeStatsMap();
            Collection<IProcessorStatistics> values = map.values();
            InvocationStatistics stats = new InvocationStatistics();
            for (IProcessorStatistics statistics : values) {
                stats.combineChild((INodeStatistics)statistics);
            }
            return stats;
        }
        return null;
    }

    public AbstractNode getAbstractNode() {
        this.checkLoaded();
        return this.routeContainer;
    }

    public void provideContextMenu(IMenuManager menu) {
        this.getCamelContextNode().provideContextMenu(menu);
    }

    public List<IPropertySource> getAllProcessorsPropertySourceList() {
        Node[] children;
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        Node[] nodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof ProcessorNodeSupport) {
                ProcessorNodeSupport processor = (ProcessorNodeSupport)node;
                processor.appendAllProcessorSourceList(answer);
            }
            ++n2;
        }
        return answer;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("camel_route_folder.png");
    }
}

