/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.navigator;

import io.fabric8.camel.facade.mbean.CamelRouteMBean;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.camel.Messages;
import org.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import org.fusesource.ide.fabric.camel.navigator.ProcessorNode;
import org.fusesource.ide.fabric.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.fabric.camel.navigator.RoutesNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class RouteNode
extends ProcessorNodeSupport
implements ImageProvider {
    private final RoutesNode routesNode;
    private final RouteSupport route;
    private CamelRouteMBean routeMBean;

    public RouteNode(RoutesNode routesNode, RouteSupport route) {
        super((Node)routesNode, route);
        this.routesNode = routesNode;
        this.route = route;
    }

    public RoutesNode getRoutesNode() {
        return this.routesNode;
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.getRoutesNode().getCamelContextNode();
    }

    public String toString() {
        return Strings.getOrElse((Object)this.getRouteId(), (String)"Route");
    }

    public AbstractNode getAbstractNode() {
        return this.route;
    }

    public Image getImage() {
        return this.route.getSmallImage();
    }

    protected void loadChildren() {
        List children = this.route.getRootNodes();
        for (AbstractNode node : children) {
            this.addChild((Node)new ProcessorNode(this, (Node)this, node));
        }
    }

    public CamelRouteMBean getRouteMBean() {
        return this.routeMBean;
    }

    public void setRouteMBean(CamelRouteMBean mbean) {
        this.routeMBean = mbean;
        this.setPropertyBean(this.routeMBean);
    }

    public void provideContextMenu(IMenuManager menu) {
        Function1<IMenuManager, Void> fn = new Function1<IMenuManager, Void>(){

            public Void apply(IMenuManager mm) {
                if (RouteNode.this.isMBeanStarted()) {
                    Action stopRouteAction = new Action(Messages.StopRouteAction, 32){

                        public void run() {
                            RouteNode.this.stopMBean();
                        }
                    };
                    stopRouteAction.setToolTipText(Messages.StopRouteActionToolTip);
                    stopRouteAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_task.gif"));
                    mm.add((IAction)stopRouteAction);
                } else {
                    Action startRouteAction = new Action(Messages.StartRouteAction, 32){

                        public void run() {
                            RouteNode.this.startMBean();
                        }
                    };
                    startRouteAction.setToolTipText(Messages.StartRouteActionToolTip);
                    startRouteAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_task.gif"));
                    mm.add((IAction)startRouteAction);
                }
                return null;
            }
        };
        this.getCamelContextNode().provideContextMenu(menu, fn);
    }

    protected void startMBean() {
        this.routeMBean.start();
    }

    protected void stopMBean() {
        this.routeMBean.stop();
    }

    public boolean isMBeanStarted() {
        String state = this.routeMBean.getState();
        return Objects.equal((Object)"Started", (Object)state);
    }

    @Override
    public String getNodeId() {
        return null;
    }
}

