/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IInvocationStatistics;
import org.fusesource.fon.util.messages.INodeStatistics;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;
import org.fusesource.fon.util.messages.InvocationStatistics;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;
import org.fusesource.ide.camel.model.AbstractNodeFacade;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import org.fusesource.ide.fabric.camel.navigator.ProcessorNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public abstract class ProcessorNodeSupport
extends RefreshableCollectionNode
implements AbstractNodeFacade,
ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider {
    private final RouteSupport route;

    public ProcessorNodeSupport(Node parent, RouteSupport route) {
        super(parent);
        this.route = route;
    }

    public RouteSupport getRoute() {
        return this.route;
    }

    public String getRouteId() {
        return this.route.getId();
    }

    public abstract CamelContextNode getCamelContextNode();

    public abstract String getNodeId();

    public List<IExchange> browseExchanges() {
        return this.getCamelContextNode().getTraceExchanges(this.getRouteId());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public List<IPropertySource> getAllProcessorsPropertySourceList() {
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        this.appendAllProcessorSourceList(answer);
        return answer;
    }

    protected void appendAllProcessorSourceList(List<IPropertySource> list) {
        Node[] children;
        Node[] nodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof ProcessorNode) {
                ProcessorNodeSupport processor = (ProcessorNodeSupport)node;
                IPropertySource source = processor.getPropertySource();
                if (source != null) {
                    list.add(source);
                }
                processor.appendAllProcessorSourceList(list);
            }
            ++n2;
        }
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.getCamelContextNode().getNodeStatisticsContainer(this.getRouteId());
    }

    public INodeStatistics getNodeStatistics() {
        String id = this.getNodeId();
        if (id != null) {
            return this.getNodeStatisticsContainer().getNodeStats(id);
        }
        return null;
    }

    public IInvocationStatistics getTotalStatistics() {
        InvocationStatistics stats = new InvocationStatistics();
        this.appendStatistics(stats);
        return stats;
    }

    protected void appendStatistics(InvocationStatistics stats) {
        Node[] children;
        INodeStatistics s = this.getNodeStatistics();
        if (s != null) {
            stats.combineChild(s);
        }
        Node[] nodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof ProcessorNodeSupport) {
                ProcessorNodeSupport child = (ProcessorNodeSupport)node;
                child.appendStatistics(stats);
            }
            ++n2;
        }
    }
}

