/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.navigator;

import io.fabric8.camel.facade.CamelFacade;
import io.fabric8.camel.facade.mbean.CamelContextMBean;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.camel.FabricCamelPlugin;
import org.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class CamelContextsNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final CamelFacade facade;

    public CamelContextsNode(Node parent, CamelFacade facade) {
        super(parent);
        this.facade = facade;
    }

    public String toString() {
        return "Camel";
    }

    public CamelFacade getFacade() {
        return this.facade;
    }

    protected void loadChildren() {
        try {
            List camelContexts = this.facade.getCamelContexts();
            if (camelContexts != null) {
                for (CamelContextMBean camelContextMBean : camelContexts) {
                    CamelContextNode child = new CamelContextNode(this, this.facade, camelContextMBean);
                    this.addChild((Node)child);
                }
            }
        }
        catch (Exception e) {
            FabricCamelPlugin.getLogger().warning("Failed to connect to JMX: " + e, (Throwable)e);
        }
    }

    public void addChildren(CamelFacade facade) throws Exception {
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("camel.png");
    }
}

