/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.navigator;

import io.fabric8.camel.facade.CamelFacade;
import io.fabric8.camel.facade.mbean.CamelContextMBean;
import io.fabric8.camel.facade.mbean.CamelFabricTracerMBean;
import io.fabric8.camel.facade.mbean.CamelProcessorMBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.mbean.ManagedBacklogTracerMBean;
import org.apache.camel.fabric.FabricTracerEventMessage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;
import org.fusesource.fon.util.messages.ITraceExchangeList;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.AbstractNodeFacade;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.XmlContainerMarshaller;
import org.fusesource.ide.commons.tree.NodeSupport;
import org.fusesource.ide.commons.tree.Refreshable;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Workbenches;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.Nodes;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.camel.Messages;
import org.fusesource.ide.fabric.camel.editor.CamelContextNodeEditorInput;
import org.fusesource.ide.fabric.camel.navigator.CachingCamelContextNodeStatisticsContainer;
import org.fusesource.ide.fabric.camel.navigator.CamelContextsNode;
import org.fusesource.ide.fabric.camel.navigator.CamelFacades;
import org.fusesource.ide.fabric.camel.navigator.EndpointsNode;
import org.fusesource.ide.fabric.camel.navigator.ProcessorBeanView;
import org.fusesource.ide.fabric.camel.navigator.RoutesNode;
import org.fusesource.ide.fabric.camel.navigator.TraceExchangeList;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class CamelContextNode
extends NodeSupport
implements Refreshable,
AbstractNodeFacade,
ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider {
    public static final String CAMEL_EDITOR_ID = "org.fusesource.ide.camel.editor";
    private final CamelContextsNode camelContextsNode;
    private final CamelFacade facade;
    private final CamelContextMBean camelContextMBean;
    private XmlContainerMarshaller marshaller = new XmlContainerMarshaller();
    private final RoutesNode routes;
    private Map<String, TraceExchangeList> traceMessageMap = new ConcurrentHashMap<String, TraceExchangeList>();
    private NodeStatisticsContainer runtimeNodeStatisticsContainer;

    public CamelContextNode(CamelContextsNode camelContextsNode, CamelFacade facade, CamelContextMBean camelContext) throws Exception {
        super((Node)camelContextsNode);
        this.camelContextsNode = camelContextsNode;
        this.facade = facade;
        this.camelContextMBean = camelContext;
        this.routes = new RoutesNode(this);
        this.addChild((Node)this.routes);
        this.addChild((Node)new EndpointsNode(this));
        this.setPropertyBean(camelContext);
    }

    public String toString() {
        return this.getContextId();
    }

    public void refresh() {
        Nodes.refreshParent((Node)this);
    }

    public CamelContextsNode getCamelContextsNode() {
        return this.camelContextsNode;
    }

    public String getContextId() {
        try {
            return this.camelContextMBean.getCamelId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getManagementName() {
        try {
            return this.camelContextMBean.getManagementName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public CamelFacade getFacade() {
        return this.facade;
    }

    public CamelContextMBean getCamelContextMBean() {
        return this.camelContextMBean;
    }

    public String getXmlString() {
        try {
            return this.camelContextMBean.dumpRoutesAsXml();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public RouteContainer getModelContainer() {
        String xml = this.getXmlText();
        return this.marshaller.loadRoutesFromText(xml);
    }

    public String getXmlText() {
        String routeElement;
        String xml = this.getXmlString();
        if (!xml.contains("<camelContext") && xml.contains(routeElement = "<routes")) {
            xml = xml.replace(routeElement, "<camelContext").replace("</routes>", "</camelContext>");
        }
        return xml;
    }

    public void updateXml(String xml) {
        this.camelContextMBean.addOrUpdateRoutesFromXml(xml);
        this.refresh();
    }

    public AbstractNode getAbstractNode() {
        return this.getRoutes().getAbstractNode();
    }

    public XmlContainerMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(XmlContainerMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public RoutesNode getRoutes() {
        return this.routes;
    }

    public boolean isTracing() {
        Object tracer = this.getTracer();
        if (tracer == null) {
            return false;
        }
        if (tracer instanceof ManagedBacklogTracerMBean) {
            return ((ManagedBacklogTracerMBean)tracer).isEnabled();
        }
        return ((CamelFabricTracerMBean)tracer).isEnabled();
    }

    public void send(String endpointUri, IMessage message) {
        Object body = message.getBody();
        Map headers = message.getHeaders();
        this.getCamelContextMBean().sendBodyAndHeaders(endpointUri, body, headers);
        this.reloadRoutes();
    }

    public void startTracing() {
        try {
            Object tracer = this.getTracer();
            if (tracer instanceof ManagedBacklogTracerMBean) {
                ((ManagedBacklogTracerMBean)tracer).setEnabled(true);
            } else {
                ((CamelFabricTracerMBean)tracer).setEnabled(true);
            }
            this.reloadRoutes();
            this.refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to start tracing", (String)("Failed to start tracing context " + (Object)((Object)this)), (Exception)e);
        }
    }

    protected void reloadRoutes() {
        this.routes.refresh();
    }

    public void stopTracing() {
        Object tracer = this.getTracer();
        if (tracer instanceof ManagedBacklogTracerMBean) {
            ((ManagedBacklogTracerMBean)tracer).setEnabled(false);
        } else {
            ((CamelFabricTracerMBean)tracer).setEnabled(false);
        }
        this.traceMessageMap.clear();
        this.reloadRoutes();
        this.refresh();
    }

    public void editRoutes() {
        IWorkbenchPage page = Workbenches.getActiveWorkbenchPage();
        if (page == null) {
            Activator.getLogger().warning("No active page!");
        } else {
            CamelContextNodeEditorInput input = new CamelContextNodeEditorInput(this);
            try {
                page.openEditor((IEditorInput)input, CAMEL_EDITOR_ID, true);
            }
            catch (PartInitException e) {
                Activator.getLogger().warning("Could not open editor: org.fusesource.ide.camel.editor. Reason: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        this.provideContextMenu(menu, null);
    }

    public void provideContextMenu(IMenuManager menu, Function1<IMenuManager, Void> fn) {
        Action editAction = new Action(Messages.EditRoutesAction, 32){

            public void run() {
                CamelContextNode.this.editRoutes();
            }

            public boolean isEnabled() {
                return CamelContextNode.this.routes.getChildCount() > 0;
            }
        };
        editAction.setToolTipText(Messages.EditRoutesActionToolTip);
        editAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("edit_camel_route.png"));
        menu.add((IAction)editAction);
        if (fn != null) {
            fn.apply((Object)menu);
        } else if (this.isMbeanSuspended()) {
            Action resumeContextAction = new Action(Messages.ResumeCamelContextAction, 32){

                public void run() {
                    CamelContextNode.this.resumeMBean();
                }
            };
            resumeContextAction.setToolTipText(Messages.ResumeCamelContextActionToolTip);
            resumeContextAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_camel.png"));
            menu.add((IAction)resumeContextAction);
        } else {
            Action suspendContextAction = new Action(Messages.SuspendCamelContextAction, 32){

                public void run() {
                    CamelContextNode.this.suspendMBean();
                }
            };
            suspendContextAction.setToolTipText(Messages.SuspendCamelContextActionToolTip);
            suspendContextAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("pause_camel.png"));
            menu.add((IAction)suspendContextAction);
        }
        if (this.canTrace()) {
            Action traceAction;
            menu.add((IContributionItem)new Separator());
            boolean tracing = this.isTracing();
            if (tracing) {
                traceAction = new Action(Messages.StopTraceAction, 32){

                    public void run() {
                        CamelContextNode.this.stopTracing();
                    }

                    public boolean isEnabled() {
                        return CamelContextNode.this.routes.getChildCount() > 0;
                    }
                };
                traceAction.setToolTipText(Messages.StopTraceActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_tracing.png"));
            } else {
                traceAction = new Action(Messages.TraceAction, 32){

                    public void run() {
                        CamelContextNode.this.startTracing();
                    }

                    public boolean isEnabled() {
                        return CamelContextNode.this.routes.getChildCount() > 0;
                    }
                };
                traceAction.setToolTipText(Messages.TraceActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_tracing.png"));
            }
            menu.add((IAction)traceAction);
        }
    }

    protected boolean canTrace() {
        return this.getTracer() != null;
    }

    protected void startMBean() {
        this.camelContextMBean.start();
        this.refresh();
    }

    protected void stopMBean() {
        this.camelContextMBean.stop();
        this.camelContextsNode.removeChild((Node)this);
    }

    protected void suspendMBean() {
        this.camelContextMBean.suspend();
        this.refresh();
    }

    protected void resumeMBean() {
        this.camelContextMBean.resume();
        this.refresh();
    }

    public boolean isMbeanSuspended() {
        String state = this.camelContextMBean.getState();
        return Objects.equal((Object)"Suspended", (Object)state);
    }

    public List<IExchange> browseExchanges() {
        String nodeId = null;
        return this.getTraceExchanges(nodeId);
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        if (this.runtimeNodeStatisticsContainer == null) {
            this.runtimeNodeStatisticsContainer = new CachingCamelContextNodeStatisticsContainer(this);
        }
        return this.runtimeNodeStatisticsContainer;
    }

    public NodeStatisticsContainer getNodeStatisticsContainer(String routeId) {
        return this.getNodeStatisticsContainer();
    }

    public ITraceExchangeList getTraceExchangeList(String id) {
        if (id != null) {
            return this.getTraceExchangeList(null);
        }
        TraceExchangeList traceList = null;
        String key = id;
        if (key == null) {
            key = this.getContextId();
        }
        if ((traceList = this.traceMessageMap.get(key)) == null) {
            traceList = new TraceExchangeList();
            this.traceMessageMap.put(key, traceList);
        }
        try {
            Object tracer = this.getTracer();
            if (tracer instanceof ManagedBacklogTracerMBean) {
                ManagedBacklogTracerMBean camelTracer = (ManagedBacklogTracerMBean)tracer;
                if (camelTracer != null) {
                    List traceMessages = null;
                    traceMessages = id == null ? camelTracer.dumpAllTracedMessages() : camelTracer.dumpTracedMessages(id);
                    traceList.addBackLogTraceMessages(traceMessages);
                }
            } else {
                CamelFabricTracerMBean fabricTracer = (CamelFabricTracerMBean)tracer;
                if (fabricTracer != null) {
                    String traceXml = fabricTracer.dumpAllTracedMessagesAsXml();
                    List<FabricTracerEventMessage> traceMessages = id == null ? this.getTraceMessagesFromXml(traceXml) : this.getTraceMessagesFromXml(traceXml, id);
                    traceList.addFabricTraceMessages(traceMessages);
                }
            }
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to get tracing messages", (String)("Failed to get tracing messages on CamelContext " + (Object)((Object)this)), (Exception)e);
        }
        return traceList;
    }

    private List<FabricTracerEventMessage> getTraceMessagesFromXml(String xmlDump) {
        ArrayList<FabricTracerEventMessage> events = new ArrayList<FabricTracerEventMessage>();
        System.err.println("TODO: CamelContextNode.getTraceMessagesFromXml()");
        System.out.println(xmlDump);
        return events;
    }

    private List<FabricTracerEventMessage> getTraceMessagesFromXml(String xmlDump, String id) {
        ArrayList<FabricTracerEventMessage> events = new ArrayList<FabricTracerEventMessage>();
        System.err.println("TODO: CamelContextNode.getTraceMessagesFromXml(id)");
        System.out.println(String.valueOf(id) + ": >>> \n" + xmlDump);
        return events;
    }

    public Image getImage() {
        if (this.isTracing()) {
            return FabricPlugin.getDefault().getImage("camel_tracing.png");
        }
        return FabricPlugin.getDefault().getImage("camel.png");
    }

    public List<IExchange> getTraceExchanges(String id) {
        return this.getTraceExchangeList(id).getExchangeList();
    }

    public Object getTracer() {
        try {
            ManagedBacklogTracerMBean mbean = this.getFacade().getCamelTracer(this.getManagementName());
            if (mbean != null) {
                return mbean;
            }
            return this.getFacade().getFabricTracer(this.getManagementName());
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public CamelProcessorMBean getProcessorMBean(String nodeId) {
        return CamelFacades.getProcessorMBean(this.getFacade(), this.getManagementName(), nodeId);
    }

    public Object createProcessorBeanView(String routeId, String nodeId) {
        return new ProcessorBeanView(this, routeId, nodeId);
    }
}

