/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.camel.editor;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.ICamelEditorInput;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.camel.Messages;
import org.fusesource.ide.fabric.camel.editor.CamelFileStoreEditorInput;
import org.fusesource.ide.fabric.camel.navigator.CamelContextNode;

public class CamelContextNodeEditorInput
implements ICamelEditorInput {
    public static final String ID = CamelContextNodeEditorInput.class.getName();
    private final CamelContextNode contextNode;
    private IFileEditorInput fileEditorInput;
    private File tempFile;
    private IFile lastSaveAsFile;

    public CamelContextNodeEditorInput(CamelContextNode contextNode) {
        this.contextNode = contextNode;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFile.class)) {
            this.getFileEditorInput();
            IPath p = Path.fromOSString((String)this.tempFile.getPath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(p);
            return file;
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return FabricPlugin.getDefault().getImageDescriptor("camel.png");
    }

    public String getName() {
        return "CamelContext: " + this.contextNode.getContextId();
    }

    public IPersistableElement getPersistable() {
        return new IPersistableElement(){

            public void saveState(IMemento memento) {
            }

            public String getFactoryId() {
                return ID;
            }
        };
    }

    public String getToolTipText() {
        return Messages.camelContextNodeEditRouteToolTip;
    }

    public RouteContainer loadModel() {
        return this.contextNode.getModelContainer();
    }

    public void save(String xml) {
        this.contextNode.updateXml(xml);
    }

    public IEditorInput getFileEditorInput() {
        if (this.lastSaveAsFile != null) {
            this.fileEditorInput = new FileEditorInput(this.lastSaveAsFile);
        }
        if (this.fileEditorInput == null) {
            try {
                File tempDir = File.createTempFile("FuseIDE-camel-context-" + this.contextNode.getContextId() + "-", "");
                tempDir.delete();
                tempDir.mkdirs();
                if (this.tempFile == null) {
                    this.tempFile = File.createTempFile("camelContext-", ".xml", tempDir);
                }
                IFileSystem fileSystem = EFS.getLocalFileSystem();
                IFileStore fileStore = fileSystem.fromLocalFile(this.tempFile);
                String xml = this.contextNode.getXmlString();
                IOUtils.writeText((File)this.tempFile, (String)xml);
                return new CamelFileStoreEditorInput(fileStore, this.contextNode);
            }
            catch (Exception e) {
                Activator.getLogger().warning("Failed to create temporary file: " + e, (Throwable)e);
            }
        }
        return this.fileEditorInput;
    }

    public IFile getLastSaveAsFile() {
        return this.lastSaveAsFile;
    }

    public void setLastSaveAsFile(IFile lastSaveAsFile) {
        this.lastSaveAsFile = lastSaveAsFile;
    }
}

