/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.EditUseCssStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ReloadCssStyleAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CssStyleSheetNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new EditUseCssStyleAction(object));
        menu.add((IAction)new ReloadCssStyleAction(object));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object model) {
        String fileName = ((CssStyleSheetHandle)model).getFileName();
        if (fileName != null) {
            return fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        String uri = ((CssStyleSheetHandle)model).getExternalCssURI();
        if (uri != null) {
            return uri.replace('\\', '/').substring(uri.lastIndexOf("/") + 1);
        }
        return Messages.getString((String)"CssStyleSheetNodeProvider.Label.FromServer");
    }

    public Object[] getChildren(Object model) {
        if (model instanceof CssStyleSheetHandle) {
            CssStyleSheetHandle cssStyleHandle = (CssStyleSheetHandle)model;
            ArrayList<String> availableStyles = null;
            if (cssStyleHandle.getContainerHandle() instanceof ReportItemThemeHandle) {
                availableStyles = new ArrayList<String>();
                availableStyles.addAll(Arrays.asList(this.getPredefinedStyleNames(((ReportItemThemeHandle)cssStyleHandle.getContainerHandle()).getType())));
            }
            ArrayList<SharedStyleHandle> childrenList = new ArrayList<SharedStyleHandle>();
            Iterator iter = cssStyleHandle.getStyleIterator();
            while (iter.hasNext()) {
                SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
                if (cssStyleHandle.getContainerHandle() instanceof ReportItemThemeHandle) {
                    if (!availableStyles.contains(styleHandle.getName())) continue;
                    childrenList.add(styleHandle);
                    continue;
                }
                childrenList.add(styleHandle);
            }
            Object[] childrenArray = childrenList.toArray(new SharedStyleHandle[childrenList.size()]);
            Arrays.sort(childrenArray, new AlphabeticallyComparator());
            return childrenArray;
        }
        return super.getChildren(model);
    }

    public Image getNodeIcon(Object model) {
        Image icon = null;
        if (model instanceof CssStyleSheetHandle) {
            icon = ReportPlatformUIImages.getImage((Object)model);
            return icon;
        }
        return super.getNodeIcon(model);
    }

    public String getNodeTooltip(Object model) {
        CssStyleSheetHandle cssStyleSheetHandle;
        ModuleHandle moudleHandle;
        URL url;
        if (model instanceof CssStyleSheetHandle && (url = (moudleHandle = (cssStyleSheetHandle = (CssStyleSheetHandle)model).getModule().getModuleHandle()).findResource(cssStyleSheetHandle.getFileName(), 3)) != null && url.getFile() != null) {
            return url.getFile();
        }
        return super.getNodeTooltip(model);
    }

    protected boolean performEdit(ElementDetailHandle handle) {
        EditUseCssStyleAction action = new EditUseCssStyleAction((Object)handle);
        if (!action.isEnabled()) {
            return false;
        }
        action.run();
        return true;
    }

    private String[] getPredefinedStyleNames(String type) {
        List preStyles = null;
        preStyles = type == null ? DEUtil.getMetaDataDictionary().getPredefinedStyles() : DEUtil.getMetaDataDictionary().getPredefinedStyles(type);
        if (preStyles == null) {
            return new String[0];
        }
        Object[] names = new String[preStyles.size()];
        int i = 0;
        while (i < preStyles.size()) {
            names[i] = ((IPredefinedStyle)preStyles.get(i)).getName();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }
}

