/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MarginsPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.MarginsPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class MarginsSection
extends Section {
    protected MarginsPropertyDescriptor spinner;
    private Label imageLabel;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillSpinner = false;

    public MarginsSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getImageLabelControl(this.parent);
        this.getMarginsControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    protected Label getImageLabelControl(Composite parent) {
        if (this.imageLabel == null) {
            this.imageLabel = FormWidgetFactory.getInstance().createLabel(parent, this.isFormStyle);
            if (this.getProvider() != null && this.getProvider() instanceof MarginsPropertyDescriptorProvider) {
                this.imageLabel.setImage(((MarginsPropertyDescriptorProvider)this.getProvider()).getImage());
            }
            this.imageLabel.setLayoutData((Object)new GridData());
            this.imageLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MarginsSection.this.imageLabel = null;
                }
            });
        } else {
            this.checkParent((Control)this.imageLabel, parent);
        }
        return this.imageLabel;
    }

    public void layout() {
        GridData gd = (GridData)this.getMarginsControl().getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillSpinner;
        }
    }

    protected MarginsPropertyDescriptor getMarginsControl(Composite parent) {
        if (this.spinner == null) {
            this.spinner = DescriptorToolkit.createSpinnerPropertyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.spinner.setDescriptorProvider(this.getProvider());
            }
            this.spinner.createControl(parent);
            this.spinner.getControl().setLayoutData((Object)new GridData());
            this.spinner.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MarginsSection.this.spinner = null;
                }
            });
        } else {
            this.checkParent(this.spinner.getControl(), parent);
        }
        return this.spinner;
    }

    public MarginsPropertyDescriptor getMarginsControl() {
        return this.spinner;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.spinner != null) {
            this.spinner.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.spinner.setInput(input);
    }

    public boolean isFillSpinner() {
        return this.fillSpinner;
    }

    public void setFillSpinner(boolean fillSpinner) {
        this.fillSpinner = fillSpinner;
    }

    public void setFocus() {
        if (this.spinner != null) {
            this.spinner.getControl().setFocus();
        }
    }

    public void load() {
        if (this.spinner != null && !this.spinner.getControl().isDisposed()) {
            this.spinner.load();
        }
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.spinner != null) {
            this.spinner.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.spinner != null) {
            this.spinner.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

