/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDatasetSortingFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDataSetColumnBindingsFormHandleProviderHelper;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class DataSetColumnBindingsFormHandleProvider
extends AbstractDatasetSortingFormHandleProvider {
    private static final String ALL = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.ALL");
    private static final String NONE = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.NONE");
    private String[] columnNames = new String[]{Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayNameID"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayName"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Expression")};
    private CellEditor[] editors;
    private static int[] columnWidth = new int[]{140, 140, 140, 80, 200};
    private ReportElementHandle bindingObject;
    private static final IChoice[] DATA_TYPE_CHOICES = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    protected TableViewer viewer;
    private int sortingColumnIndex;
    private int sortDirection = 128;

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    public boolean isEditable() {
        if (this.input == null || !(DEUtil.getInputFirstElement((Object)this.input) instanceof ReportItemHandle)) {
            return false;
        }
        if (((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)).getDataBindingType() == 2) {
            return false;
        }
        if (((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)).getDataBindingType() == 0) {
            return DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)), (boolean)true).getDataBindingType() != 2;
        }
        return true;
    }

    public ReportElementHandle getBindingObject() {
        return this.bindingObject;
    }

    public void setBindingObject(DesignElementHandle bindingObject) {
        if (bindingObject instanceof ReportElementHandle) {
            this.bindingObject = (ReportElementHandle)bindingObject;
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public String getDisplayName() {
        if (this.isEditable()) {
            return Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.DatasetTitle");
        }
        return Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.ReportItemTitle");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnNames.length];
            int i = 0;
            while (i < this.editors.length) {
                this.editors[i] = new TextCellEditor((Composite)table);
                ++i;
            }
        }
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        if ((pos = this.getOriginalIndex(pos)) > -1 && this.bindingObject instanceof ReportItemHandle) {
            ((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(pos).drop();
            return true;
        }
        return false;
    }

    public boolean doAddItem(int pos) throws Exception {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true, true);
        dialog.setInput((ReportItemHandle)this.bindingObject);
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    public boolean doEditItem(int pos) {
        ComputedColumnHandle bindingHandle = null;
        if ((pos = this.getOriginalIndex(pos)) > -1 && this.bindingObject instanceof ReportItemHandle) {
            bindingHandle = (ComputedColumnHandle)((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(pos);
        }
        if (bindingHandle == null) {
            return false;
        }
        boolean isResultSetColumn = false;
        String resultSetName = null;
        if (this.bindingObject instanceof DataItemHandle) {
            resultSetName = ((DataItemHandle)this.bindingObject).getResultSetColumn();
        }
        if (resultSetName != null && bindingHandle.getName().equals(resultSetName)) {
            isResultSetColumn = true;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
        dialog.setInput((ReportItemHandle)this.bindingObject, bindingHandle);
        if (dialog.open() == 0) {
            if (isResultSetColumn) {
                try {
                    ((DataItemHandle)this.bindingObject).setResultSetColumn(bindingHandle.getName());
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if (this.viewer != null) {
                this.viewer.refresh(true);
                return true;
            }
        }
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ComputedColumnHandle)element).getName();
            }
            case 1: {
                return ((ComputedColumnHandle)element).getDisplayNameID();
            }
            case 2: {
                return ((ComputedColumnHandle)element).getDisplayName();
            }
            case 3: {
                return this.getDataTypeDisplayName(((ComputedColumnHandle)element).getDataType());
            }
            case 4: {
                return DataUtil.getAggregationExpression((ComputedColumnHandle)((ComputedColumnHandle)element));
            }
            case 5: {
                try {
                    String function = ((ComputedColumnHandle)element).getAggregateFunction();
                    if (function != null && (function = DataAdapterUtil.adaptModelAggregationType((String)function)) != null && DataUtil.getAggregationManager().getAggregation(function) != null) {
                        return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
                    }
                }
                catch (BirtException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                return null;
            }
            case 6: {
                String ExpValue = ((ComputedColumnHandle)element).getFilterExpression();
                if (ExpValue != null && ExpValue.length() > 0) {
                    return ExpValue;
                }
                return null;
            }
            case 7: {
                String value = DEUtil.getAggregateOn((ComputedColumnHandle)((ComputedColumnHandle)element));
                String text = value == null ? (((ComputedColumnHandle)element).getAggregateFunction() != null ? ALL : NONE) : value;
                return text;
            }
        }
        return null;
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            IChoice choice = DATA_TYPE_CHOICES[i];
            if (choice.getName().equals(dataType)) {
                return choice.getDisplayName();
            }
            ++i;
        }
        return dataType;
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[] && ((Object[])inputElement).length > 0) {
            return this.getElements(((Object[])inputElement)[0]);
        }
        if (inputElement instanceof List) {
            return this.getElements(((List)inputElement).get(0));
        }
        if (inputElement instanceof ReportItemHandle) {
            ReportItemHandle reportHandle = (ReportItemHandle)inputElement;
            this.bindingObject = reportHandle;
            ArrayList children = new ArrayList();
            Iterator iter = reportHandle.getColumnBindings().iterator();
            while (iter.hasNext()) {
                children.add(iter.next());
            }
            Object[] arrays = children.toArray();
            Arrays.sort(arrays, new BindingComparator());
            return arrays;
        }
        return new Object[0];
    }

    public int getOriginalIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = ((ReportItemHandle)this.bindingObject).getColumnBindings().iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return children.indexOf(Arrays.asList(arrays).get(pos));
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean needRefreshed(NotificationEvent event) {
        PropertyEvent ev;
        String propertyName;
        return event.getEventType() == 5 && ("boundDataColumns".equals(propertyName = (ev = (PropertyEvent)event).getPropertyName()) || "dataSet".equals(propertyName));
    }

    private void generateOutputParmsBindings(DataSetHandle datasetHandle) {
        ArrayList<DataSetParameterHandle> outputParams = new ArrayList<DataSetParameterHandle>();
        Iterator iter = datasetHandle.parametersIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof DataSetParameterHandle) || !((DataSetParameterHandle)obj).isOutput()) continue;
            outputParams.add((DataSetParameterHandle)obj);
        }
        int ret = -1;
        if (outputParams.size() > 0) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.generateOutputParam"), null, Messages.getString((String)"dataBinding.msg.generateOutputParam"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No")}, 0);
            ret = prefDialog.open();
        }
        if (ret == 0) {
            int i = 0;
            while (i < outputParams.size()) {
                DataSetParameterHandle param = (DataSetParameterHandle)outputParams.get(i);
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)param.getName());
                bindingColumn.setDataType(param.getDataType());
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                ExpressionUtility.setBindingColumnExpression((Object)param, (ComputedColumn)bindingColumn, (boolean)true);
                if (this.bindingObject instanceof ReportItemHandle) {
                    try {
                        ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else if (ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
                    if (groupType.equals("group")) {
                        bindingColumn.setAggregrateOn(((GroupHandle)groupList.get(0)).getName());
                    } else if (groupType.equals("listing")) {
                        bindingColumn.setAggregrateOn(null);
                    }
                }
                ++i;
            }
        }
    }

    public void generateAllBindingColumns() {
        if (this.bindingObject != null) {
            DataSetHandle datasetHandle = null;
            if (this.bindingObject instanceof ReportItemHandle) {
                datasetHandle = ((ReportItemHandle)this.bindingObject).getDataSet();
            } else if (this.bindingObject instanceof GroupHandle) {
                datasetHandle = ((ReportItemHandle)((GroupHandle)this.bindingObject).getContainer()).getDataSet();
            }
            if (datasetHandle != null) {
                CommandStack stack = this.getActionStack();
                stack.startTrans(Messages.getString((String)Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Trans.RefreshBindingColumns")));
                try {
                    Iterator iter = this.getLinkedDataSetColumnIterator(datasetHandle);
                    if (iter == null) {
                        CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle((DataSetHandle)datasetHandle);
                        iter = cmdh.getResultSet().iterator();
                    }
                    while (iter.hasNext()) {
                        ResultSetColumnHandle element = (ResultSetColumnHandle)iter.next();
                        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)element.getColumnName());
                        bindingColumn.setDataType(element.getDataType());
                        String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                        List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                        ExpressionUtility.setBindingColumnExpression((Object)element, (ComputedColumn)bindingColumn);
                        bindingColumn.setDisplayName(UIUtil.getColumnDisplayName((ResultSetColumnHandle)element));
                        String displayKey = UIUtil.getColumnDisplayNameKey((ResultSetColumnHandle)element);
                        if (displayKey != null) {
                            bindingColumn.setDisplayNameID(displayKey);
                        }
                        if (this.bindingObject instanceof ReportItemHandle) {
                            ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                            continue;
                        }
                        if (!ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) continue;
                        if (groupType.equals("group")) {
                            bindingColumn.setAggregrateOn(((GroupHandle)groupList.get(0)).getName());
                            continue;
                        }
                        if (!groupType.equals("listing")) continue;
                        bindingColumn.setAggregrateOn(null);
                    }
                    this.generateOutputParmsBindings(datasetHandle);
                    stack.commit();
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                    stack.rollback();
                }
            }
        }
    }

    public void generateBindingColumns(Object[] columns) {
        if (columns != null && columns.length > 0) {
            CommandStack stack = this.getActionStack();
            stack.startTrans(Messages.getString((String)Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Trans.GenerateBindingColumns")));
            try {
                int i = 0;
                while (i < columns.length) {
                    ResultSetColumnHandle element = (ResultSetColumnHandle)columns[i];
                    ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)element.getColumnName());
                    bindingColumn.setDataType(element.getDataType());
                    String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                    List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                    ExpressionUtility.setBindingColumnExpression((Object)element, (ComputedColumn)bindingColumn);
                    bindingColumn.setDisplayName(UIUtil.getColumnDisplayName((ResultSetColumnHandle)element));
                    String displayKey = UIUtil.getColumnDisplayNameKey((ResultSetColumnHandle)element);
                    if (displayKey != null) {
                        bindingColumn.setDisplayNameID(displayKey);
                    }
                    if (this.bindingObject instanceof ReportItemHandle) {
                        ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                    } else if (ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
                        if (groupType.equals("group")) {
                            bindingColumn.setAggregrateOn(((GroupHandle)groupList.get(0)).getName());
                        } else if (groupType.equals("listing")) {
                            bindingColumn.setAggregrateOn(null);
                        }
                    }
                    ++i;
                }
                stack.commit();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
                stack.rollback();
            }
        }
    }

    private Iterator getLinkedDataSetColumnIterator(DataSetHandle datasetHandle) {
        IDataSetColumnBindingsFormHandleProviderHelper helper = (IDataSetColumnBindingsFormHandleProviderHelper)ElementAdapterManager.getAdapter((Object)this, IDataSetColumnBindingsFormHandleProviderHelper.class);
        if (helper != null) {
            return helper.getResultSetIterator(datasetHandle);
        }
        return null;
    }

    public void clearAllBindingColumns() {
        if (this.bindingObject instanceof ReportItemHandle) {
            try {
                while (((ReportItemHandle)this.bindingObject).getColumnBindings().getItems() != null && !((ReportItemHandle)this.bindingObject).getColumnBindings().getItems().isEmpty()) {
                    ((ReportItemHandle)this.bindingObject).getColumnBindings().clearValue();
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void removedUnusedColumnBindings(List inputElement) {
        Object element;
        if (inputElement.size() > 0 && (element = inputElement.get(0)) instanceof ReportElementHandle) {
            try {
                if (element instanceof GroupHandle) {
                    DesignElementHandle parentHandle = ((GroupHandle)element).getContainer();
                    if (parentHandle instanceof ReportItemHandle) {
                        ((ReportItemHandle)parentHandle).removedUnusedColumnBindings();
                    }
                } else if (element instanceof ReportItemHandle) {
                    ((ReportItemHandle)element).removedUnusedColumnBindings();
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void setTableViewer(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void setShowAggregation(boolean showAggregation) {
        if (showAggregation) {
            this.columnNames = new String[]{Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayNameID"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayName"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Expression"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Function"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Filter"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.AggregateOn")};
            columnWidth = new int[]{110, 110, 110, 80, 110, 110, 110, 90};
        }
    }

    public void setSortingColumnIndex(int index) {
        this.sortingColumnIndex = index;
    }

    public void setSortDirection(int dir) {
        this.sortDirection = dir;
    }

    public int getShowIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = ((ReportItemHandle)this.bindingObject).getColumnBindings().iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        if (pos < 0 || pos >= children.size()) {
            return -1;
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return Arrays.asList(arrays).indexOf(children.get(pos));
    }

    public boolean isClearEnable() {
        return true;
    }

    private class BindingComparator
    implements Comparator {
        private BindingComparator() {
        }

        public int compare(Object o1, Object o2) {
            ComputedColumnHandle binding1 = (ComputedColumnHandle)o1;
            ComputedColumnHandle binding2 = (ComputedColumnHandle)o2;
            String columnText1 = DataSetColumnBindingsFormHandleProvider.this.getColumnText(binding1, DataSetColumnBindingsFormHandleProvider.this.sortingColumnIndex);
            String columnText2 = DataSetColumnBindingsFormHandleProvider.this.getColumnText(binding2, DataSetColumnBindingsFormHandleProvider.this.sortingColumnIndex);
            int result = (columnText1 == null ? "" : columnText1).compareTo(columnText2 == null ? "" : columnText2);
            if (DataSetColumnBindingsFormHandleProvider.this.sortDirection == 128) {
                return result;
            }
            return 0 - result;
        }
    }
}

