/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.StyleComboProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class BorderStyleDescriptorProvider
extends StyleComboProvider {
    private String[] nameChoices;
    private String[] displayChoices;
    private static final String LABEL_STYLE = Messages.getString((String)"BordersPage.Label.Style");

    public String getDisplayName() {
        return LABEL_STYLE;
    }

    public Object load() {
        String value = this.getLocalStringValue("borderLeftStyle");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderRightStyle");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderTopStyle");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderBottomStyle");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        return this.indexText;
    }

    private String convertNameToDisplayName(String name) {
        int index;
        if (this.nameChoices == null) {
            this.getItems();
        }
        if ((index = Arrays.asList(this.nameChoices).indexOf(name)) >= 0 && index < this.displayChoices.length) {
            return this.displayChoices[index];
        }
        return "";
    }

    private String convertDisplayNameToName(Object displayName) {
        if (displayName == null) {
            return null;
        }
        int index = Arrays.asList(this.getItems()).indexOf(displayName);
        if (index >= 0 && index < this.nameChoices.length) {
            return this.nameChoices[index];
        }
        return null;
    }

    private String[] getStyles(IChoiceSet choiceSet, Object[] items) {
        this.nameChoices = new String[items.length];
        this.displayChoices = new String[items.length];
        int i = 0;
        while (i < items.length) {
            this.nameChoices[i] = choiceSet.findChoice((String)items[i]).getName();
            this.displayChoices[i] = choiceSet.findChoice((String)items[i]).getDisplayName();
            ++i;
        }
        return this.nameChoices;
    }

    public Object[] getItems() {
        if (this.nameChoices == null) {
            return this.getStyles(DEUtil.getMetaDataDictionary().getChoiceSet("lineStyle"), super.getItems());
        }
        return this.nameChoices;
    }

    public Object[] getDisplayItems() {
        if (this.displayChoices == null) {
            this.getStyles(DEUtil.getMetaDataDictionary().getChoiceSet("lineStyle"), super.getItems());
        }
        return this.displayChoices;
    }

    public void save(Object value) throws SemanticException {
        this.indexText = value == null ? "" : value;
        String saveValue = this.convertDisplayNameToName(value);
        if (((Boolean)this.styleMap.get("borderTopStyle")).booleanValue()) {
            this.save("borderTopStyle", saveValue);
        } else {
            this.save("borderTopStyle", null);
        }
        if (((Boolean)this.styleMap.get("borderBottomStyle")).booleanValue()) {
            this.save("borderBottomStyle", saveValue);
        } else {
            this.save("borderBottomStyle", null);
        }
        if (((Boolean)this.styleMap.get("borderLeftStyle")).booleanValue()) {
            this.save("borderLeftStyle", saveValue);
        } else {
            this.save("borderLeftStyle", null);
        }
        if (((Boolean)this.styleMap.get("borderRightStyle")).booleanValue()) {
            this.save("borderRightStyle", saveValue);
        } else {
            this.save("borderRightStyle", null);
        }
    }

    public void handleModifyEvent() {
        try {
            if (this.indexText != null) {
                this.save(this.indexText);
            }
        }
        catch (Exception exception) {}
    }
}

