/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IShutdownControllerDelegate;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.LocalLegacyShutdownController;

public class ManagementShutdownController
extends LocalLegacyShutdownController {
    private IJBoss7ManagerService service;

    protected IJBoss7ManagerService getService() throws JBoss7ManangerException {
        if (this.service == null) {
            this.service = JBoss7ManagerUtil.getService((IServer)this.getServer());
        }
        return this.service;
    }

    @Override
    protected boolean getRequiresForce() {
        Object o = this.getControllableBehavior().getSharedData("DeployableServerBehavior.RequiresForceStop");
        return o == null ? false : (Boolean)o;
    }

    @Override
    protected boolean shouldUseForce() {
        return this.getRequiresForce();
    }

    @Override
    protected void setNextStopRequiresForce(boolean val) {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)val);
    }

    @Override
    protected void forceStop() {
        try {
            ILaunchServerController c = (ILaunchServerController)this.getControllableBehavior().getController("launch");
            if (c instanceof IShutdownControllerDelegate) {
                IServerShutdownController sc = ((IShutdownControllerDelegate)c).getShutdownController();
                sc.stop(true);
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1030003, Messages.FORCE_TERMINATE_FAILED, (Throwable)ce);
            ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
        }
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)new Boolean(false));
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
    }

    @Override
    protected IStatus gracefullStop() {
        IServer server = this.getServer();
        try {
            AS7ManagementDetails det = new AS7ManagementDetails(this.getServer());
            this.getService().stop((IAS7ManagementDetails)det);
            PollThreadUtils.pollServer(this.getServer(), false);
            this.setNextStopRequiresForce(false);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.setNextStopRequiresForce(true);
            return new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.JBoss7ServerBehavior_could_not_stop, (Object)server.getName()), (Throwable)e);
        }
    }
}

