/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.LocalStopLaunchConfigurator;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.LaunchConfigUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.ThreadUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;

public class LocalLegacyShutdownController
extends AbstractSubsystemController
implements IServerShutdownController {
    private static final String STOP_LAUNCH_TYPE = "org.jboss.ide.eclipse.as.core.server.stopLaunchConfiguration";

    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    public void stop(boolean force) {
        this.stop(force, true);
    }

    protected void stop(boolean force, boolean removeScanners) {
        if (removeScanners) {
            this.removeScanners();
        }
        boolean ignoreLaunch = false;
        try {
            ILaunchConfiguration config = this.getServer().getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
            ignoreLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((ILaunchConfiguration)config);
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce.getStatus());
        }
        if (ignoreLaunch) {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
            return;
        }
        this.stopImpl(force);
    }

    protected void removeScanners() {
        JBossExtendedProperties properties;
        boolean removeScanners = this.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true);
        if (removeScanners && (properties = (JBossExtendedProperties)this.getServer().loadAdapter(JBossExtendedProperties.class, null)) != null) {
            properties.getDeploymentScannerModifier().removeAddedDeploymentScanners(this.getServer());
        }
    }

    protected IProcess getProcess() {
        IProcess existing = (IProcess)this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
        return existing;
    }

    protected boolean isProcessRunning() {
        boolean isProcessRunning = this.getProcess() != null && !this.getProcess().isTerminated();
        return isProcessRunning;
    }

    protected void clearProcess() {
        this.getControllableBehavior().putSharedData("AbstractStartJavaServerLaunchDelegate.Process", null);
    }

    protected PollThread getPollThread() {
        return (PollThread)this.getControllableBehavior().getSharedData("DeployableServerBehavior.PollThread");
    }

    protected void clearPollThread() {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.PollThread", null);
    }

    protected boolean getRequiresForce() {
        Object o = this.getControllableBehavior().getSharedData("DeployableServerBehavior.RequiresForceStop");
        return o == null ? false : (Boolean)o;
    }

    protected void setNextStopRequiresForce(boolean val) {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)val);
    }

    protected boolean shouldUseForce() {
        int state = this.getServer().getServerState();
        boolean useForce = !this.isProcessRunning() || state == 4 || this.getRequiresForce();
        return useForce;
    }

    public void stopImpl(boolean force) {
        int state = this.getServer().getServerState();
        if (force || this.shouldUseForce()) {
            this.forceStop();
        } else if (state == 1 || state == 3) {
            this.cancelPolling(null);
            this.forceStop();
        } else {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopping();
            IStatus result = this.gracefullStop();
            if (!result.isOK()) {
                this.setNextStopRequiresForce(true);
                ((ControllableServerBehavior)this.getControllableBehavior()).setServerStarted();
            }
        }
    }

    protected IStatus gracefullStop() {
        new Thread(){

            @Override
            public void run() {
                try {
                    ILaunchConfigurationWorkingCopy wc = LaunchConfigUtils.createLaunchConfigurationWorkingCopy("Stop JBoss Server", LocalLegacyShutdownController.STOP_LAUNCH_TYPE);
                    new LocalStopLaunchConfigurator(LocalLegacyShutdownController.this.getServer()).configure(wc);
                    ILaunch launch = wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
                    IProcess stopProcess = launch.getProcesses()[0];
                    ThreadUtils.sleepWhileRunning((IProcess)stopProcess);
                    if (stopProcess.getExitValue() != 0) {
                        ((ControllableServerBehavior)LocalLegacyShutdownController.this.getControllableBehavior()).setServerStarted();
                        LocalLegacyShutdownController.this.cancelPolling(Messages.STOP_FAILED_MESSAGE);
                        LocalLegacyShutdownController.this.setNextStopRequiresForce(true);
                    }
                }
                catch (CoreException ce) {
                    JBossServerCorePlugin.getDefault().getLog().log(ce.getStatus());
                }
            }
        }.start();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceStop() {
        LocalLegacyShutdownController localLegacyShutdownController = this;
        synchronized (localLegacyShutdownController) {
            if (this.isProcessRunning()) {
                try {
                    this.getProcess().terminate();
                    this.addForceStopEvent();
                }
                catch (DebugException e) {
                    this.addForceStopFailedEvent(e);
                }
            }
            this.clearProcess();
            this.setNextStopRequiresForce(false);
        }
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
    }

    protected void cancelPolling(String message) {
        PollThreadUtils.cancelPolling(message, this.getPollThread());
        this.clearPollThread();
    }

    protected void addForceStopFailedEvent(DebugException e) {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1030003, Messages.FORCE_TERMINATE_FAILED, (Throwable)e);
        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
    }

    protected void addForceStopEvent() {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 16973826, Messages.FORCE_TERMINATED, null);
        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
    }
}

