/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.Map;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class TaskAttributeMetaData {
    private final TaskAttribute taskAttribute;

    TaskAttributeMetaData(TaskAttribute taskAttribute) {
        this.taskAttribute = taskAttribute;
    }

    public TaskAttributeMetaData defaults() {
        this.setLabel(null);
        this.setKind(null);
        this.setReadOnly(true);
        this.setType("shortText");
        this.setRequired(false);
        return this;
    }

    public TaskAttributeMetaData clear() {
        this.taskAttribute.clearMetaDataMap();
        return this;
    }

    @Deprecated
    public String getDefaultOption() {
        return this.taskAttribute.getMetaDatum("task.meta.defaultOption");
    }

    public String getKind() {
        return this.taskAttribute.getMetaDatum("task.meta.attributeKind");
    }

    public String getLabel() {
        return this.taskAttribute.getMetaDatum("task.meta.label");
    }

    public String getType() {
        return this.taskAttribute.getMetaDatum("task.meta.type");
    }

    public String getValue(String key) {
        return this.taskAttribute.getMetaDatum(key);
    }

    public Map<String, String> getValues() {
        return this.taskAttribute.getMetaDataMap();
    }

    public boolean isDisabled() {
        return Boolean.parseBoolean(this.taskAttribute.getMetaDatum("task.meta.disabled"));
    }

    public boolean isReadOnly() {
        return Boolean.parseBoolean(this.taskAttribute.getMetaDatum("task.meta.readOnly"));
    }

    public boolean isRequired() {
        return Boolean.parseBoolean(this.taskAttribute.getMetaDatum("task.meta.required"));
    }

    public String getMediaType() {
        return this.taskAttribute.getMetaDatum("task.meta.mediaType");
    }

    public TaskAttributeMetaData putValue(String key, String value) {
        this.taskAttribute.putMetaDatum(key, value);
        return this;
    }

    @Deprecated
    public TaskAttributeMetaData setDefaultOption(String defaultOption) {
        if (defaultOption != null) {
            this.taskAttribute.putMetaDatum("task.meta.defaultOption", defaultOption);
        } else {
            this.taskAttribute.removeMetaDatum("task.meta.defaultOption");
        }
        return this;
    }

    public TaskAttributeMetaData setKind(String value) {
        if (value != null) {
            this.taskAttribute.putMetaDatum("task.meta.attributeKind", value);
        } else {
            this.taskAttribute.removeMetaDatum("task.meta.attributeKind");
        }
        return this;
    }

    public TaskAttributeMetaData setLabel(String value) {
        if (value != null) {
            this.taskAttribute.putMetaDatum("task.meta.label", value);
        } else {
            this.taskAttribute.removeMetaDatum("task.meta.label");
        }
        return this;
    }

    public TaskAttributeMetaData setReadOnly(boolean value) {
        this.taskAttribute.putMetaDatum("task.meta.readOnly", Boolean.toString(value));
        return this;
    }

    public TaskAttributeMetaData setType(String value) {
        if (value != null) {
            this.taskAttribute.putMetaDatum("task.meta.type", value);
        } else {
            this.taskAttribute.removeMetaDatum("task.meta.type");
        }
        return this;
    }

    public TaskAttributeMetaData setDisabled(boolean value) {
        this.taskAttribute.putMetaDatum("task.meta.disabled", Boolean.toString(value));
        return this;
    }

    public TaskAttributeMetaData setRequired(boolean value) {
        this.taskAttribute.putMetaDatum("task.meta.required", Boolean.toString(value));
        return this;
    }

    public TaskAttributeMetaData setMediaType(String value) {
        if (value != null) {
            this.taskAttribute.putMetaDatum("task.meta.mediaType", value);
        } else {
            this.taskAttribute.removeMetaDatum("task.meta.mediaType");
        }
        return this;
    }
}

