/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.docsys.DocumentationContent;
import org.eclipse.sapphire.modeling.docsys.HtmlFormatter;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.ui.IExportModelDocumentationOp;
import org.eclipse.sapphire.util.StringUtil;
import org.osgi.framework.Bundle;

public final class ExportModelDocumentationOpMethods {
    private static String STYLE;

    public static String execute(IExportModelDocumentationOp op, ElementType type, IProgressMonitor monitor) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        if (((Boolean)op.getCreateFinishedDocument().content()).booleanValue()) {
            out.println("<html>");
            out.println();
            out.println("<head>");
            out.println("  <title>" + (String)op.getDocumentTitle().content() + "</title>");
            if (((Boolean)op.getEmbedDefaultStyle().content()).booleanValue()) {
                out.println(ExportModelDocumentationOpMethods.style());
            }
            out.println("</head>");
            out.println();
            out.println("<body>");
        }
        ExportModelDocumentationOpMethods.execute(type, out);
        if (((Boolean)op.getCreateFinishedDocument().content()).booleanValue()) {
            out.println("<br/><br/>");
            out.println("</body>");
            out.println();
            out.println("</head>");
        }
        out.flush();
        return stringWriter.getBuffer().toString();
    }

    private static void execute(ElementType type, PrintWriter out) {
        String xmlPath;
        TreeMap<String, PropertyDef> properties = new TreeMap<String, PropertyDef>();
        for (PropertyDef propertyDef : type.properties()) {
            XmlListBinding xmlListBindingAnnotation;
            XmlElementBinding xmlElementBindingAnnotation;
            XmlValueBinding xmlValueBindingAnnotation;
            xmlPath = null;
            XmlBinding xmlBindingAnnotation = (XmlBinding)propertyDef.getAnnotation(XmlBinding.class);
            if (xmlBindingAnnotation != null) {
                xmlPath = xmlBindingAnnotation.path();
            }
            if (xmlPath == null && (xmlValueBindingAnnotation = (XmlValueBinding)propertyDef.getAnnotation(XmlValueBinding.class)) != null) {
                xmlPath = xmlValueBindingAnnotation.path();
            }
            if (xmlPath == null && (xmlElementBindingAnnotation = (XmlElementBinding)propertyDef.getAnnotation(XmlElementBinding.class)) != null) {
                int mappingsCount = xmlElementBindingAnnotation.mappings().length;
                if (mappingsCount == 0) {
                    xmlPath = xmlElementBindingAnnotation.path();
                } else {
                    if (mappingsCount != 1) continue;
                    xmlPath = xmlElementBindingAnnotation.mappings()[0].element();
                    if (xmlElementBindingAnnotation.path().length() > 0) {
                        xmlPath = String.valueOf(xmlElementBindingAnnotation.path()) + "/" + xmlPath;
                    }
                }
            }
            if (xmlPath == null && (xmlListBindingAnnotation = (XmlListBinding)propertyDef.getAnnotation(XmlListBinding.class)) != null) {
                if (xmlListBindingAnnotation.mappings().length != 1) continue;
                xmlPath = xmlListBindingAnnotation.mappings()[0].element();
                if (xmlListBindingAnnotation.path().length() > 0) {
                    xmlPath = String.valueOf(xmlListBindingAnnotation.path()) + "/" + xmlPath;
                }
            }
            if (xmlPath == null) continue;
            properties.put(xmlPath, propertyDef);
        }
        out.println("<table>");
        out.println("  <tr>");
        out.println("    <th>Element</th>");
        out.println("    <th>Cardinality</th>");
        out.println("    <th>Description</th>");
        out.println("  </tr>");
        for (Map.Entry entry : properties.entrySet()) {
            String cardinality;
            xmlPath = (String)entry.getKey();
            PropertyDef property = (PropertyDef)entry.getValue();
            if (property instanceof ValueProperty) {
                cardinality = property.hasAnnotation(Required.class) ? "1" : "0 or 1";
            } else if (property instanceof ElementProperty) {
                cardinality = "0 or 1";
            } else if (property instanceof ListProperty) {
                cardinality = "0 or more";
            } else {
                throw new IllegalStateException();
            }
            out.println("  <tr>");
            out.println(ExportModelDocumentationOpMethods.td(xmlPath));
            out.println(ExportModelDocumentationOpMethods.td(cardinality));
            out.println("    <td>");
            if (property.hasAnnotation(Documentation.class)) {
                ExportModelDocumentationOpMethods.documentation(out, (Documentation)property.getAnnotation(Documentation.class));
            } else {
                out.println("&nbsp;");
            }
            if (property instanceof ElementProperty || property instanceof ListProperty) {
                PropertyDef childTypeProperty;
                boolean skip = false;
                ElementType childType = (ElementType)((PossibleTypesService)property.service(PossibleTypesService.class)).types().first();
                SortedSet childTypeProperties = childType.properties();
                if (childTypeProperties.size() == 1 && (childTypeProperty = (PropertyDef)childTypeProperties.first()) instanceof ValueProperty) {
                    XmlBinding b;
                    if (childTypeProperty.hasAnnotation(XmlBinding.class)) {
                        b = (XmlBinding)childTypeProperty.getAnnotation(XmlBinding.class);
                        if (b != null && b.path().length() == 0) {
                            skip = true;
                        }
                    } else if (childTypeProperty.hasAnnotation(XmlValueBinding.class) && (b = (XmlValueBinding)childTypeProperty.getAnnotation(XmlValueBinding.class)) != null && b.path().length() == 0) {
                        skip = true;
                    }
                }
                if (!skip) {
                    out.println("<br/><br/>");
                    ExportModelDocumentationOpMethods.execute(childType, out);
                    out.println("<br/>");
                }
            }
            out.println("    </td>");
            out.println("  </tr>");
        }
        out.println("</table>");
        out.println();
    }

    private static void documentation(PrintWriter out, Documentation doc) {
        String text = doc.content();
        DocumentationContent content = DocumentationContent.parse((String)text);
        String html = HtmlFormatter.format((DocumentationContent)content);
        out.println(html);
    }

    private static String style() {
        if (STYLE == null) {
            StringBuilder buf;
            block10: {
                buf = new StringBuilder();
                buf.append("<style type=\"text/css\">\n");
                try {
                    URL url;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.doc");
                    if (bundle == null || (url = bundle.getEntry("html/style.css")) == null) break block10;
                    InputStream in = url.openStream();
                    try {
                        InputStreamReader reader = new InputStreamReader(in, StringUtil.UTF8);
                        char[] chars = new char[1024];
                        int count = reader.read(chars);
                        while (count != -1) {
                            buf.append(chars, 0, count);
                            count = reader.read(chars);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
            buf.append("\n</style>");
            STYLE = buf.toString();
        }
        return STYLE;
    }

    private static String normalize(String text, String textForNull) {
        return text == null || text.trim().length() == 0 ? textForNull : text;
    }

    private static String td(String value) {
        StringBuilder buf = new StringBuilder();
        buf.append("    <td>");
        buf.append(ExportModelDocumentationOpMethods.normalize(value, "&nbsp;"));
        buf.append("</td>");
        return buf.toString();
    }
}

