/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.ListPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation2;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireMenuActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SapphireTextCellEditor;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.ElementsTransfer;
import org.eclipse.sapphire.ui.forms.swt.internal.HyperlinkTable;
import org.eclipse.sapphire.ui.forms.swt.internal.PopUpListFieldCellEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.util.MiscUtil;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class TablePropertyEditorPresentation
extends ListPropertyEditorPresentation {
    @Text(value="<empty>")
    private static LocalizableText emptyRowIndicator;
    private boolean exposeAddAction = true;
    private boolean exposeDeleteAction = true;
    private Map<Element, TableRow> rows;
    private Table table;
    private CustomTableViewer tableViewer;
    private SelectionProvider selectionProvider;
    private List<ColumnHandler> columnHandlers;
    private Runnable refreshOperation;
    private static final ImageDescriptor IMG_CHECKBOX_ON;
    private static final ImageDescriptor IMG_CHECKBOX_OFF;

    static {
        LocalizableText.init(TablePropertyEditorPresentation.class);
        IMG_CHECKBOX_ON = SwtUtil.createImageDescriptor(BooleanPropertyColumnHandler.class, "CheckBoxOn.gif");
        IMG_CHECKBOX_OFF = SwtUtil.createImageDescriptor(BooleanPropertyColumnHandler.class, "CheckBoxOff.gif");
    }

    public TablePropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, final boolean embedded) {
        boolean toolBarNeeded;
        Composite tableComposite;
        final PropertyEditorPart part = this.part();
        final Property property = part.property();
        boolean isReadOnly = part.isReadOnly();
        boolean showHeader = part.getRenderingHint("show.header", true);
        final SapphireActionGroup actions = this.getActions();
        final SapphireActionPresentationManager actionPresentationManager = this.getActionPresentationManager();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        SapphireMenuActionPresentation menuActionsPresentation = new SapphireMenuActionPresentation(actionPresentationManager);
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        this.addOnDisposeOperation(new Runnable(){

            @Override
            public void run() {
                actionPresentationManager.dispose();
            }
        });
        Composite mainComposite = this.createMainComposite(parent, new PropertyEditorPresentation.CreateMainCompositeDelegate(this, part){

            @Override
            public boolean getShowLabel() {
                return embedded ? false : super.getShowLabel();
            }

            @Override
            public int getLeftMargin() {
                return embedded ? 0 : super.getLeftMargin();
            }

            @Override
            public boolean getSpanBothColumns() {
                return embedded ? true : super.getSpanBothColumns();
            }
        });
        if (this.decorator == null) {
            tableComposite = new Composite(mainComposite, 0);
            tableComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
            tableComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            this.decorator = this.createDecorator(tableComposite);
            this.decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
            this.decorator.addEditorControl((Control)tableComposite);
        } else {
            tableComposite = mainComposite;
        }
        this.decorator.addEditorControl((Control)mainComposite);
        final Composite tableParentComposite = new Composite(tableComposite, 0);
        tableParentComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableParentComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new CustomTableViewer(tableParentComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.decorator.addEditorControl((Control)this.table);
        ArrayList relatedControls = new ArrayList();
        this.table.setData("related-controls", relatedControls);
        this.table.addListener(41, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                event.height = Math.max(event.height, 18);
            }
        });
        this.columnHandlers = new ArrayList<ColumnHandler>();
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                int columnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                ColumnHandler columnHandler = TablePropertyEditorPresentation.this.getColumnHandler(columnIndex);
                return columnHandler.isEditorActivationEvent(event);
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)20);
        this.table.setHeaderVisible(showHeader);
        this.selectionProvider = new SelectionProvider(this.tableViewer);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                TablePropertyEditorPresentation.this.handleTableFocusGainedEvent();
            }
        });
        this.refreshOperation = new Runnable(){
            boolean running = false;

            @Override
            public void run() {
                if (TablePropertyEditorPresentation.this.table.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    TablePropertyEditorPresentation.this.tableViewer.refresh();
                    if (TablePropertyEditorPresentation.this.table.isDisposed()) {
                        return;
                    }
                    TablePropertyEditorPresentation.this.table.notifyListeners(13, null);
                    tableParentComposite.layout();
                }
                finally {
                    this.running = false;
                }
            }
        };
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                TablePropertyEditorPresentation.this.refreshOperation.run();
            }
        };
        property.attach((Listener)listener);
        this.addOnDisposeOperation(new Runnable((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            @Override
            public void run() {
                property.detach(this.val$listener);
            }
        });
        boolean showImages = true;
        String columnWidthsHint = part.getRenderingHint("column.widths", "");
        StringTokenizer columnWidthsHintTokenizer = new StringTokenizer(columnWidthsHint, ",");
        for (ModelPath childPropertyPath : part.getChildProperties()) {
            String columnWidthHint;
            String[] columnWidthHintSplit;
            PropertyDef childProperty = property.definition().getType().property(childPropertyPath);
            PropertyEditorDef childPropertyEditorDef = part.definition().getChildPropertyEditor(childPropertyPath);
            final TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
            if (childPropertyEditorDef == null) {
                String label = childProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false);
                tableViewerColumn.getColumn().setText(label);
            } else {
                final MutableReference labelFunctionResultRef = new MutableReference();
                Runnable updateLabelOp = new Runnable(){

                    @Override
                    public void run() {
                        String label = (String)((FunctionResult)labelFunctionResultRef.get()).value();
                        label = LabelTransformer.transform((String)label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
                        tableViewerColumn.getColumn().setText(label);
                    }
                };
                final FunctionResult labelFunctionResult = part.initExpression((Function)childPropertyEditorDef.getLabel().content(), String.class, (Function)Literal.create((Object)childProperty.getLabel(false, CapitalizationType.NO_CAPS, true)), updateLabelOp);
                labelFunctionResultRef.set((Object)labelFunctionResult);
                updateLabelOp.run();
                this.addOnDisposeOperation(new Runnable(){

                    @Override
                    public void run() {
                        labelFunctionResult.dispose();
                    }
                });
            }
            ColumnWeightData columnWeightData = null;
            if (columnWidthsHintTokenizer.hasMoreTokens() && ((columnWidthHintSplit = (columnWidthHint = columnWidthsHintTokenizer.nextToken()).split(":")).length == 1 || columnWidthHintSplit.length == 2)) {
                try {
                    int minColumnWidth = Integer.parseInt(columnWidthHintSplit[0].trim());
                    int columnWeight = columnWidthHintSplit.length == 2 ? Integer.parseInt(columnWidthHintSplit[1].trim()) : 0;
                    columnWeightData = new ColumnWeightData(columnWeight, minColumnWidth, true);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (columnWeightData == null) {
                columnWeightData = new ColumnWeightData(1, 100, true);
            }
            tableColumnLayout.setColumnData((Widget)tableViewerColumn.getColumn(), columnWeightData);
            final ColumnHandler columnHandler = this.createColumnHandler(this.columnHandlers, childPropertyPath, showImages, childPropertyEditorDef);
            showImages = false;
            tableViewerColumn.setLabelProvider(columnHandler.getLabelProvider());
            tableViewerColumn.setEditingSupport((EditingSupport)columnHandler.getEditingSupport());
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TableColumn currentSortColumn = TablePropertyEditorPresentation.this.table.getSortColumn();
                    if (currentSortColumn != tableColumn) {
                        TablePropertyEditorPresentation.this.table.setSortColumn(tableColumn);
                        TablePropertyEditorPresentation.this.table.setSortDirection(1024);
                        TablePropertyEditorPresentation.this.tableViewer.setComparator(new TableSorter(columnHandler, 1024));
                    } else {
                        int currentSortDirection = TablePropertyEditorPresentation.this.table.getSortDirection();
                        if (currentSortDirection == 1024) {
                            TablePropertyEditorPresentation.this.table.setSortDirection(128);
                            TablePropertyEditorPresentation.this.tableViewer.setComparator(new TableSorter(columnHandler, 128));
                        } else {
                            TablePropertyEditorPresentation.this.table.setSortColumn(null);
                            TablePropertyEditorPresentation.this.tableViewer.setComparator(null);
                        }
                    }
                    for (SapphireAction action : actions.getActions()) {
                        for (SapphireActionHandler handler : action.getActiveHandlers()) {
                            if (!(handler instanceof PropertyEditorActionHandler)) continue;
                            ((PropertyEditorActionHandler)handler).refreshEnablementState();
                        }
                    }
                }
            });
        }
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ElementList<?> list = TablePropertyEditorPresentation.this.property();
                LinkedHashMap<Element, TableRow> rows = new LinkedHashMap<Element, TableRow>();
                for (Element element : list) {
                    TableRow row = null;
                    if (TablePropertyEditorPresentation.this.rows != null) {
                        row = (TableRow)TablePropertyEditorPresentation.this.rows.remove(element);
                    }
                    if (row == null) {
                        Value value;
                        ValueImageService valueImageService;
                        ImageProvider imageProvider = null;
                        final ImageService imageService = (ImageService)element.service(ImageService.class);
                        if (imageService != null) {
                            imageProvider = new ImageProvider(TablePropertyEditorPresentation.this){
                                private Listener imageServiceListener;

                                @Override
                                public ImageData image() {
                                    if (this.imageServiceListener == null) {
                                        this.imageServiceListener = new Listener(){

                                            public void handle(Event event) {
                                                TablePropertyEditorPresentation.this.update(this.row());
                                            }
                                        };
                                        imageService.attach(this.imageServiceListener);
                                    }
                                    return imageService.image();
                                }

                                @Override
                                public void dispose() {
                                    if (this.imageServiceListener != null) {
                                        imageService.detach(this.imageServiceListener);
                                    }
                                }
                            };
                        } else if (TablePropertyEditorPresentation.this.getColumnCount() == 1 && (valueImageService = (ValueImageService)(value = (Value)element.property(TablePropertyEditorPresentation.this.getColumnHandler(0).property())).service(ValueImageService.class)) != null) {
                            imageProvider = new ImageProvider(TablePropertyEditorPresentation.this){

                                @Override
                                public ImageData image() {
                                    return valueImageService.provide(value.text());
                                }
                            };
                        }
                        row = new TableRow(element, imageProvider);
                    }
                    rows.put(element, row);
                }
                if (TablePropertyEditorPresentation.this.rows != null) {
                    for (TableRow row : TablePropertyEditorPresentation.this.rows.values()) {
                        row.dispose();
                    }
                }
                TablePropertyEditorPresentation.this.rows = rows;
                return rows.values().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
                for (TableRow row : TablePropertyEditorPresentation.this.rows.values()) {
                    row.dispose();
                }
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setInput(contentProvider);
        this.table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                TablePropertyEditorPresentation.this.handleTableTraverseEvent(event);
            }
        });
        final ListSelectionService selectionService = part.service(ListSelectionService.class);
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.select(TablePropertyEditorPresentation.this.getSelectedElements());
            }
        });
        this.setSelectedElements(selectionService.selection());
        FilteredListener<ListSelectionService.ListSelectionChangedEvent> selectionServiceListener = new FilteredListener<ListSelectionService.ListSelectionChangedEvent>(){

            protected void handleTypedEvent(ListSelectionService.ListSelectionChangedEvent event) {
                TablePropertyEditorPresentation.this.setSelectedElements(event.after());
            }
        };
        selectionService.attach((Listener)selectionServiceListener);
        if (!isReadOnly) {
            if (this.exposeAddAction) {
                final SapphireAction addAction = actions.getAction("Sapphire.Add");
                final ArrayList addActionHandlers = new ArrayList();
                final Listener addActionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionHandler.PostExecuteEvent) {
                            if (TablePropertyEditorPresentation.this.table.isDisposed()) {
                                return;
                            }
                            Element newListElement = (Element)((SapphireActionHandler.PostExecuteEvent)event).getResult();
                            if (newListElement != null) {
                                TablePropertyEditorPresentation.this.refreshOperation.run();
                                TableRow row = (TableRow)TablePropertyEditorPresentation.this.rows.get(newListElement);
                                TablePropertyEditorPresentation.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)row), true);
                                if (TablePropertyEditorPresentation.this.table.isDisposed()) {
                                    return;
                                }
                                TablePropertyEditorPresentation.this.tableViewer.editElement(row, 0);
                                TablePropertyEditorPresentation.this.table.notifyListeners(13, null);
                            }
                        }
                    }
                };
                final PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
                final Runnable refreshAddActionHandlersOp = new Runnable(){

                    @Override
                    public void run() {
                        addAction.removeHandlers(addActionHandlers);
                        for (SapphireActionHandler addActionHandler : addActionHandlers) {
                            addActionHandler.dispose();
                        }
                        for (ElementType memberType : possibleTypesService.types()) {
                            AddActionHandler addActionHandler = new AddActionHandler(memberType);
                            ((SapphireActionHandler)addActionHandler).init(addAction, null);
                            addActionHandler.attach(addActionHandlerListener);
                            addActionHandlers.add(addActionHandler);
                            addAction.addHandler(addActionHandler);
                        }
                    }
                };
                refreshAddActionHandlersOp.run();
                final Listener possibleTypesServiceListener = new Listener(){

                    public void handle(Event event) {
                        refreshAddActionHandlersOp.run();
                    }
                };
                possibleTypesService.attach(possibleTypesServiceListener);
                this.addOnDisposeOperation(new Runnable(){

                    @Override
                    public void run() {
                        addAction.removeHandlers(addActionHandlers);
                        for (SapphireActionHandler addActionHandler : addActionHandlers) {
                            addActionHandler.dispose();
                        }
                        possibleTypesService.detach(possibleTypesServiceListener);
                    }
                });
            }
            if (this.exposeDeleteAction) {
                final SapphireAction deleteAction = actions.getAction("Sapphire.Delete");
                final DeleteActionHandler deleteActionHandler = new DeleteActionHandler();
                ((SapphireActionHandler)deleteActionHandler).init(deleteAction, null);
                deleteAction.addHandler(deleteActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    @Override
                    public void run() {
                        deleteAction.removeHandler(deleteActionHandler);
                    }
                });
            }
            if (!property.definition().hasAnnotation(FixedOrderList.class)) {
                final SapphireAction moveUpAction = actions.getAction("Sapphire.Move.Up");
                final MoveUpActionHandler moveUpActionHandler = new MoveUpActionHandler();
                ((SapphireActionHandler)moveUpActionHandler).init(moveUpAction, null);
                moveUpAction.addHandler(moveUpActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    @Override
                    public void run() {
                        moveUpAction.removeHandler(moveUpActionHandler);
                    }
                });
                final SapphireAction moveDownAction = actions.getAction("Sapphire.Move.Down");
                final MoveDownActionHandler moveDownActionHandler = new MoveDownActionHandler();
                ((SapphireActionHandler)moveDownActionHandler).init(moveDownAction, null);
                moveDownAction.addHandler(moveDownActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    @Override
                    public void run() {
                        moveDownAction.removeHandler(moveDownActionHandler);
                    }
                });
                Listener moveActionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionHandler.PostExecuteEvent) {
                            TablePropertyEditorPresentation.this.refreshOperation.run();
                            Element element = TablePropertyEditorPresentation.this.getSelectedElement();
                            TableItem[] items = TablePropertyEditorPresentation.this.table.getItems();
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].getData() == element) {
                                    TablePropertyEditorPresentation.this.table.setSelection(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                };
                moveUpAction.attach(moveActionHandlerListener);
                moveDownAction.attach(moveActionHandlerListener);
                ElementsTransfer transfer = new ElementsTransfer(this.element().type().getModelElementClass().getClassLoader());
                Transfer[] transfers = new Transfer[]{transfer};
                DragSource dragSource = new DragSource((Control)this.table, 3);
                dragSource.setTransfer(transfers);
                final ArrayList dragElements = new ArrayList();
                dragSource.addDragListener(new DragSourceListener(){

                    public void dragStart(DragSourceEvent event) {
                        if (TablePropertyEditorPresentation.this.tableViewer.getComparator() == null) {
                            dragElements.addAll(TablePropertyEditorPresentation.this.getSelectedElements());
                            event.doit = true;
                        } else {
                            event.doit = false;
                        }
                    }

                    public void dragSetData(DragSourceEvent event) {
                        event.data = dragElements;
                    }

                    public void dragFinished(DragSourceEvent event) {
                        block6: {
                            if (event.detail == 2) {
                                boolean droppedIntoAnotherEditor = false;
                                for (Element dragElement : dragElements) {
                                    if (dragElement.disposed()) continue;
                                    droppedIntoAnotherEditor = true;
                                    break;
                                }
                                if (droppedIntoAnotherEditor) {
                                    try {
                                        Element selectionPostDelete = (Element)MiscUtil.findSelectionPostDelete(TablePropertyEditorPresentation.this.property(), dragElements);
                                        for (Element dragElement : dragElements) {
                                            ElementList dragElementContainer = (ElementList)dragElement.parent();
                                            dragElementContainer.remove((Object)dragElement);
                                        }
                                        TablePropertyEditorPresentation.this.setSelectedElement(selectionPostDelete);
                                    }
                                    catch (Exception e) {
                                        EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                        if (editFailedException != null) break block6;
                                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                                    }
                                }
                            }
                        }
                        dragElements.clear();
                    }
                });
                DropTarget target = new DropTarget((Control)this.table, 3);
                target.setTransfer(transfers);
                target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragOver(DropTargetEvent event) {
                        if (event.item != null) {
                            TableItem dragOverItem = (TableItem)event.item;
                            Point pt = dragOverItem.getDisplay().map(null, (Control)TablePropertyEditorPresentation.this.table, event.x, event.y);
                            Rectangle bounds = dragOverItem.getBounds();
                            event.feedback = pt.y < bounds.y + bounds.height / 2 ? 2 : 4;
                        }
                        event.feedback |= 8;
                    }

                    public void drop(DropTargetEvent event) {
                        int position;
                        if (event.data == null) {
                            event.detail = 0;
                            return;
                        }
                        List droppedElements = (List)event.data;
                        SortedSet possibleTypesService = ((PossibleTypesService)property.service(PossibleTypesService.class)).types();
                        for (Element droppedElement : droppedElements) {
                            if (possibleTypesService.contains(droppedElement.type())) continue;
                            event.detail = 0;
                            return;
                        }
                        ElementList<?> list = TablePropertyEditorPresentation.this.property();
                        if (event.item == null) {
                            position = list.size();
                        } else {
                            TableItem dropTargetItem = (TableItem)event.item;
                            TableRow dropTargetRow = (TableRow)dropTargetItem.getData();
                            Element dropTargetElement = dropTargetRow.element();
                            Point pt = TablePropertyEditorPresentation.this.table.getDisplay().map(null, (Control)TablePropertyEditorPresentation.this.table, event.x, event.y);
                            Rectangle bounds = dropTargetItem.getBounds();
                            position = list.indexOf((Object)dropTargetElement);
                            if (pt.y >= bounds.y + bounds.height / 2) {
                                ++position;
                            }
                        }
                        try {
                            if (event.detail == 2) {
                                for (Element dragElement : dragElements) {
                                    ElementList dragElementContainer = (ElementList)dragElement.parent();
                                    if (dragElementContainer == list && dragElementContainer.indexOf((Object)dragElement) < position) {
                                        --position;
                                    }
                                    dragElementContainer.remove((Object)dragElement);
                                }
                            }
                            ArrayList<Element> newSelection = new ArrayList<Element>();
                            for (Element droppedElement : droppedElements) {
                                Element insertedElement = list.insert(droppedElement.type(), position);
                                insertedElement.copy(droppedElement);
                                newSelection.add(insertedElement);
                                ++position;
                            }
                            if (TablePropertyEditorPresentation.this.table.isDisposed()) {
                                return;
                            }
                            TablePropertyEditorPresentation.this.tableViewer.refresh();
                            TablePropertyEditorPresentation.this.setSelectedElements(newSelection);
                        }
                        catch (Exception e) {
                            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                            if (editFailedException == null) {
                                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                            }
                            event.detail = 0;
                        }
                    }
                });
            }
        }
        mainComposite.setLayout((Layout)GridLayoutUtil.glayout((toolBarNeeded = toolBarActionsPresentation.hasActions()) ? 2 : 1, 0, 0, 0, 0));
        if (toolBarNeeded) {
            ToolBar toolbar = new ToolBar(mainComposite, 0x800200);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            this.decorator.addEditorControl((Control)toolbar);
        }
        if (menuActionsPresentation.hasActions()) {
            Menu menu = new Menu((Control)this.table);
            this.table.setMenu(menu);
            menuActionsPresentation.setMenu(menu);
            menuActionsPresentation.render();
        }
        HyperlinkTable hyperlinkTable = new HyperlinkTable(this.table, actions);
        hyperlinkTable.setController(new HyperlinkTable.Controller(){

            @Override
            public boolean isHyperlinkEnabled(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    return jumpHandler.isEnabled();
                }
                return false;
            }

            @Override
            public void handleHyperlinkEvent(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    jumpHandler.execute(TablePropertyEditorPresentation.this);
                }
            }

            private SapphireActionHandler getJumpHandler(TableItem item, int column) {
                Element element = ((TableRow)item.getData()).element();
                ModelPath property = part.getChildProperties().get(column);
                PropertyEditorPart propertyEditor = part.getChildPropertyEditor(element, property);
                SapphireActionGroup actions = propertyEditor.getActions();
                return actions.getAction("Sapphire.Jump").getFirstActiveHandler();
            }
        });
        SwtUtil.suppressDashedTableEntryBorder(this.table);
        this.addControl((Control)this.table);
        this.addOnDisposeOperation(new Runnable((Listener)selectionServiceListener){
            private final /* synthetic */ Listener val$selectionServiceListener;
            {
                this.val$selectionServiceListener = listener;
            }

            @Override
            public void run() {
                selectionService.detach(this.val$selectionServiceListener);
            }
        });
        return this.table;
    }

    @Override
    protected boolean canScaleVertically() {
        return true;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    public final boolean isAddActionDesired() {
        return this.exposeAddAction;
    }

    public final void setAddActionDesired(boolean exposeAddAction) {
        this.exposeAddAction = exposeAddAction;
    }

    public final boolean isDeleteActionDesired() {
        return this.exposeDeleteAction;
    }

    public final void setDeleteActionDesired(boolean exposeDeleteAction) {
        this.exposeDeleteAction = exposeDeleteAction;
    }

    public final Element getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.selectionProvider.getSelection();
        return (Element)sel.getFirstElement();
    }

    public final List<Element> getSelectedElements() {
        IStructuredSelection sel = (IStructuredSelection)this.selectionProvider.getSelection();
        ListFactory elements = ListFactory.start();
        Iterator itr = sel.iterator();
        while (itr.hasNext()) {
            elements.add((Object)((Element)itr.next()));
        }
        return elements.result();
    }

    public final void setSelectedElement(Element element) {
        this.setSelectedElements(element == null ? Collections.emptyList() : Collections.singletonList(element));
    }

    public final void setSelectedElements(List<Element> elements) {
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.getSelectedElements(), elements)) {
            ListFactory rows = ListFactory.start();
            for (Element element : elements) {
                TableRow row = this.rows.get(element);
                if (row == null) continue;
                rows.add((Object)row);
            }
            this.tableViewer.setSelection((ISelection)new StructuredSelection(rows.result()));
        }
    }

    private final List<TableRow> getSelectedRows() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Iterator itr = this.selectionProvider.getSelectedRows().iterator();
        while (itr.hasNext()) {
            rows.add((TableRow)itr.next());
        }
        return rows;
    }

    public final void setFocusOnTable() {
        this.table.setFocus();
    }

    @Override
    public PropertyEditorPresentation2 createChildPropertyEditorPresentation(PropertyEditorPart part) {
        final Table table = this.table;
        Property property = part.property();
        final Element element = this.findTableRowElement(property.element());
        ColumnHandler handler = null;
        for (ColumnHandler h : this.columnHandlers) {
            if (element.property(h.property()) != property) continue;
            handler = h;
            break;
        }
        if (handler == null) {
            throw new IllegalStateException();
        }
        final int column = this.columnHandlers.indexOf(handler);
        return new PropertyEditorPresentation2(part, this, (Composite)table){

            @Override
            public Rectangle bounds() {
                Rectangle bounds = null;
                int i = 0;
                int n = table.getItemCount();
                while (i < n && bounds == null) {
                    TableItem item = table.getItem(i);
                    if (((TableRow)item.getData()).element() == element) {
                        bounds = item.getBounds(column);
                    }
                    ++i;
                }
                if (bounds == null) {
                    throw new IllegalStateException();
                }
                Point position = table.toDisplay(bounds.x, bounds.y);
                bounds = new Rectangle(position.x, position.y, bounds.width, bounds.height);
                return bounds;
            }

            @Override
            public void render() {
            }
        };
    }

    @Override
    protected void handleChildPropertyEvent(final PropertyContentEvent event) {
        super.handleChildPropertyEvent(event);
        if (!this.table.isDisposed()) {
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TablePropertyEditorPresentation.this.update(event.property().element());
                }
            });
        }
    }

    protected void handleTableFocusGainedEvent() {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.tableViewer.getSelection().isEmpty() && this.table.getItemCount() > 0) {
            TableItem firstTableItem = this.table.getItem(0);
            if (firstTableItem.isDisposed()) {
                return;
            }
            Object firstItem = firstTableItem.getData();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstItem));
        }
    }

    private void handleTableTraverseEvent(TraverseEvent event) {
        if (event.detail == 4) {
            event.doit = false;
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection.size() == 1) {
                TableRow row = (TableRow)selection.getFirstElement();
                int firstEditableColumn = -1;
                int i = 0;
                int n = this.getColumnCount();
                while (i < n) {
                    ColumnHandler handler = this.getColumnHandler(i);
                    if (handler.getEditingSupport().canEdit(row)) {
                        firstEditableColumn = i;
                        break;
                    }
                    ++i;
                }
                if (firstEditableColumn != -1) {
                    this.tableViewer.editElement(row, firstEditableColumn);
                }
            }
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    private ColumnHandler createColumnHandler(List<ColumnHandler> allColumnHandlers, ModelPath childPropertyPath, boolean showImages, PropertyEditorDef childPropertyEditorDef) {
        ColumnHandler columnHandler;
        PropertyDef childProperty = this.property().definition().getType().property(childPropertyPath);
        if (childProperty.isOfType(Boolean.class)) {
            columnHandler = new BooleanPropertyColumnHandler(this.tableViewer, this.selectionProvider, this.part(), allColumnHandlers, childPropertyPath, showImages);
        } else {
            String style;
            PopUpListFieldStyle popUpListFieldPresentationStyle = null;
            if (childProperty.isOfType(Enum.class)) {
                popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
            } else if (childPropertyEditorDef != null && (style = childPropertyEditorDef.getStyle().text()) != null && style.startsWith("Sapphire.PropertyEditor.PopUpListField")) {
                if (style.equals("Sapphire.PropertyEditor.PopUpListField")) {
                    PossibleValues possibleValuesAnnotation = (PossibleValues)childProperty.getAnnotation(PossibleValues.class);
                    popUpListFieldPresentationStyle = possibleValuesAnnotation != null ? (possibleValuesAnnotation.invalidValueSeverity() == Status.Severity.ERROR ? PopUpListFieldStyle.STRICT : PopUpListFieldStyle.EDITABLE) : PopUpListFieldStyle.EDITABLE;
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Editable")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.EDITABLE;
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Strict")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
                }
            }
            columnHandler = popUpListFieldPresentationStyle != null ? new PopUpListFieldColumnPresentation(this.tableViewer, this.selectionProvider, this.part(), allColumnHandlers, childPropertyPath, showImages, popUpListFieldPresentationStyle) : new ColumnHandler(this.tableViewer, this.selectionProvider, this.part(), allColumnHandlers, childPropertyPath, showImages);
        }
        allColumnHandlers.add(columnHandler);
        return columnHandler;
    }

    private int getColumnCount() {
        return this.table.getColumnCount();
    }

    private ColumnHandler getColumnHandler(int column) {
        return this.columnHandlers.get(column);
    }

    private void update(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (!this.disposed()) {
            Element root = this.part().getLocalModelElement();
            Element el = element;
            TableRow row = null;
            while (row == null && el != null && el != root) {
                Property parent;
                row = this.rows.get(el);
                if (row != null || (parent = el.parent()) == null) continue;
                el = parent.element();
            }
            if (row != null) {
                this.update(row);
            }
        }
    }

    private void update(TableRow row) {
        if (row == null) {
            throw new IllegalArgumentException();
        }
        this.tableViewer.update(row, null);
    }

    private Element findTableRowElement(Element element) {
        ElementList<?> list = this.list();
        Element result = element;
        Property parent = element.parent();
        while (parent != list) {
            result = parent.element();
            parent = result.parent();
        }
        return result;
    }

    private static abstract class AbstractColumnEditingSupport
    extends EditingSupport {
        protected final ColumnHandler columnHandler;

        public AbstractColumnEditingSupport(ColumnHandler columnHandler) {
            super((ColumnViewer)columnHandler.getTableViewer());
            this.columnHandler = columnHandler;
        }

        public boolean canEdit(Object obj) {
            Element element = ((TableRow)obj).element();
            boolean canEdit = this.columnHandler.property(element).enabled() ? !this.columnHandler.editor(element).isReadOnly() : false;
            return canEdit;
        }

        public abstract CellEditor getCellEditor(Object var1);

        public abstract Object getValue(Object var1);

        public abstract void setValue(Object var1, Object var2);
    }

    private final class AddActionHandler
    extends TablePropertyEditorActionHandler {
        private final ElementType type;

        public AddActionHandler(ElementType type) {
            this.type = type;
            this.setId("Sapphire.Add." + this.type.getSimpleName());
        }

        @Override
        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            ImageData typeSpecificAddImage = this.type.image();
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        }

        @Override
        protected Object executeTablePropertyEditorAction(Presentation context) {
            TablePropertyEditorPresentation.this.tableViewer.applyEditorValue();
            return TablePropertyEditorPresentation.this.list().insert(this.type);
        }
    }

    private final class BooleanPropertyColumnHandler
    extends ColumnHandler {
        private static final int CHECKBOX_IMAGE_WIDTH = 16;
        private static final int CHECKBOX_IMAGE_HEIGHT = 16;

        public BooleanPropertyColumnHandler(TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ModelPath property, boolean showElementImage) {
            super(tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new OwnerDrawLabelProvider(){

                protected void erase(org.eclipse.swt.widgets.Event event, Object element) {
                }

                protected void measure(org.eclipse.swt.widgets.Event event, Object element) {
                }

                protected void paint(org.eclipse.swt.widgets.Event event, Object object) {
                    TableItem item = (TableItem)event.item;
                    Element element = ((TableRow)item.getData()).element();
                    if (BooleanPropertyColumnHandler.this.property(element).enabled()) {
                        boolean value = BooleanPropertyColumnHandler.this.getPropertyValueAsBoolean(element);
                        Image image = BooleanPropertyColumnHandler.this.getImageCache().image(value ? IMG_CHECKBOX_ON : IMG_CHECKBOX_OFF);
                        Rectangle cellBounds = item.getBounds(event.index);
                        Rectangle imageBounds = image.getBounds();
                        int x = event.x + (cellBounds.width - imageBounds.width) / 2;
                        int y = event.y + (cellBounds.height - imageBounds.height) / 2;
                        event.gc.drawImage(image, x, y);
                    }
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private CheckboxCellEditor cellEditor;

                @Override
                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new CheckboxCellEditor((Composite)BooleanPropertyColumnHandler.this.getTable());
                    }
                    return this.cellEditor;
                }

                @Override
                public Object getValue(Object obj) {
                    Boolean val = (Boolean)BooleanPropertyColumnHandler.this.property(((TableRow)obj).element()).content();
                    return val != null ? val : Boolean.FALSE;
                }

                @Override
                public void setValue(Object obj, Object value) {
                    String str = String.valueOf((Boolean)value);
                    BooleanPropertyColumnHandler.this.property(((TableRow)obj).element()).write((Object)str, true);
                }
            };
        }

        @Override
        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (event.eventType == 2) {
                Rectangle cellBounds = ((ViewerCell)event.getSource()).getBounds();
                Rectangle checkBoxBounds = new Rectangle(cellBounds.x + (cellBounds.width - 16) / 2, cellBounds.y + (cellBounds.height - 16) / 2, 16, 16);
                MouseEvent evt = (MouseEvent)event.sourceEvent;
                return checkBoxBounds.contains(evt.x, evt.y);
            }
            return false;
        }

        private boolean getPropertyValueAsBoolean(Element element) {
            Boolean val = (Boolean)this.property(element).content();
            return val != null && val != false;
        }
    }

    private class ColumnHandler {
        protected final Table table;
        protected final TableViewer tableViewer;
        protected final SelectionProvider selectionProvider;
        protected final PropertyEditorPart listPropertyEditor;
        protected final List<ColumnHandler> allColumnHandlers;
        protected final ModelPath property;
        protected final boolean showElementImage;
        protected final Collator collator;
        private CellLabelProvider labelProvider;
        private AbstractColumnEditingSupport editingSupport;

        public ColumnHandler(TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ModelPath property, boolean showElementImage) {
            this.table = tableViewer.getTable();
            this.tableViewer = tableViewer;
            this.selectionProvider = selectionProvider;
            this.listPropertyEditor = listPropertyEditor;
            this.allColumnHandlers = allColumnHandlers;
            this.property = property;
            this.showElementImage = showElementImage;
            this.collator = Collator.getInstance();
        }

        public final Table getTable() {
            return this.table;
        }

        public final TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public final SelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public final PropertyEditorPart getListPropertyEditor() {
            return this.listPropertyEditor;
        }

        public final SwtResourceCache getImageCache() {
            return this.listPropertyEditor.getSwtResourceCache();
        }

        public final boolean isElementImageDesired() {
            return this.showElementImage;
        }

        public final ModelPath property() {
            return this.property;
        }

        public final Value<?> property(Element element) {
            return (Value)element.property(this.property);
        }

        public final PropertyEditorPart editor(Element element) {
            return this.getListPropertyEditor().getChildPropertyEditor(element, this.property());
        }

        public final CellLabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            return this.labelProvider;
        }

        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this);
        }

        public final AbstractColumnEditingSupport getEditingSupport() {
            if (this.editingSupport == null && !TablePropertyEditorPresentation.this.property().definition().getType().property(this.property()).isReadOnly()) {
                this.editingSupport = this.createEditingSupport();
            }
            return this.editingSupport;
        }

        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private SapphireTextCellEditor cellEditor;

                @Override
                public CellEditor getCellEditor(Object obj) {
                    if (this.cellEditor != null) {
                        this.cellEditor.dispose();
                    }
                    PropertyEditorPart propertyEditor = ColumnHandler.this.editor(((TableRow)obj).element());
                    SapphireActionGroup actions = propertyEditor.getActions();
                    int style = ColumnHandler.this.getTable().getLinesVisible() ? 0 : 2048;
                    this.cellEditor = new SapphireTextCellEditor(TablePropertyEditorPresentation.this.createChildPropertyEditorPresentation(propertyEditor), (StructuredViewer)ColumnHandler.this.getTableViewer(), ColumnHandler.this.getSelectionProvider(), propertyEditor.getLocalModelElement(), (ValueProperty)propertyEditor.property().definition(), actions, style);
                    if (ColumnHandler.this.isElementImageDesired()) {
                        this.cellEditor.setHorizonalIndent(3);
                    }
                    return this.cellEditor;
                }

                @Override
                public Object getValue(Object obj) {
                    return ColumnHandler.this.property(((TableRow)obj).element());
                }

                @Override
                public void setValue(Object obj, Object value) {
                    ColumnHandler.this.property(((TableRow)obj).element()).write(value, true);
                }
            };
        }

        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 3 || event.eventType == 4 || event.eventType == 5;
        }

        public final int comparePropertyValues(Element aElement, Element bElement) {
            Value<?> aValue = this.property(aElement);
            Value<?> bValue = this.property(bElement);
            boolean aEmpty = aValue.empty();
            boolean bEmpty = bValue.empty();
            if (aEmpty && bEmpty) {
                return 0;
            }
            if (aEmpty) {
                return 1;
            }
            if (bEmpty) {
                return -1;
            }
            if (!aValue.malformed() && !bValue.malformed()) {
                Object aContent = aValue.content();
                Object bContent = bValue.content();
                if (aContent instanceof Boolean && bContent instanceof Boolean) {
                    return ((Boolean)bContent).compareTo((Boolean)aContent);
                }
                if (aContent instanceof Comparable && bContent instanceof Comparable) {
                    Comparable aComparable = (Comparable)aContent;
                    Comparable bComparable = (Comparable)bContent;
                    return aComparable.compareTo(bComparable);
                }
            }
            return this.collator.compare(aValue.text(), bValue.text());
        }

        public boolean isEmptyTextLabelDesired(Element element) {
            if (this.allColumnHandlers.get(0) == this) {
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (!(handler instanceof BooleanPropertyColumnHandler)) continue;
                    return false;
                }
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (handler.property(element).text() == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class CustomTableViewer
    extends TableViewer {
        public CustomTableViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void applyEditorValue() {
            super.applyEditorValue();
        }
    }

    private final class DefaultColumnLabelProvider
    extends ColumnLabelProvider {
        private final ColumnHandler columnHandler;

        public DefaultColumnLabelProvider(ColumnHandler columnHandler) {
            this.columnHandler = columnHandler;
        }

        public String getText(Object obj) {
            Element element = ((TableRow)obj).element();
            Value<?> value = this.columnHandler.property(element);
            String text = value.text();
            String label = null;
            try {
                label = ((ValueLabelService)value.service(ValueLabelService.class)).provide(text);
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            if (label == null) {
                label = text;
            } else if (!label.equals(text)) {
                LocalizationService localizationService = (LocalizationService)TablePropertyEditorPresentation.this.part().definition().adapt(LocalizationService.class);
                label = localizationService.transform(label, CapitalizationType.FIRST_WORD_ONLY, false);
            }
            if (label == null) {
                label = this.columnHandler.isEmptyTextLabelDesired(element) ? emptyRowIndicator.text() : "";
            }
            return label;
        }

        public Image getImage(Object obj) {
            if (this.columnHandler.isElementImageDesired()) {
                return ((TableRow)obj).image();
            }
            return null;
        }

        public Color getForeground(Object obj) {
            Value<?> value = this.columnHandler.property(((TableRow)obj).element());
            if (value.text(false) == null) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }

    private final class DeleteActionHandler
    extends SelectionBasedActionHandler {
        private DeleteActionHandler() {
        }

        @Override
        protected final Object executeTablePropertyEditorAction(Presentation context) {
            List rowsToDelete = TablePropertyEditorPresentation.this.getSelectedRows();
            TableRow selectionPostDelete = (TableRow)MiscUtil.findSelectionPostDelete(TablePropertyEditorPresentation.this.rows.values(), rowsToDelete);
            ElementList<?> list = TablePropertyEditorPresentation.this.list();
            for (TableRow row : rowsToDelete) {
                list.remove((Object)row.element());
            }
            TablePropertyEditorPresentation.this.refreshOperation.run();
            if (selectionPostDelete != null) {
                TablePropertyEditorPresentation.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selectionPostDelete));
            }
            return null;
        }

        @Override
        protected boolean computeEnablementState() {
            if (super.computeEnablementState()) {
                return !TablePropertyEditorPresentation.this.getSelectedElements().isEmpty();
            }
            return false;
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            if (part.property().definition() instanceof ListProperty) {
                return new TablePropertyEditorPresentation(part, parent, composite);
            }
            return null;
        }
    }

    private abstract class ImageProvider {
        private TableRow row;

        private ImageProvider() {
        }

        public final void init(TableRow row) {
            this.row = row;
        }

        protected final TableRow row() {
            return this.row;
        }

        public abstract ImageData image();

        public void dispose() {
        }
    }

    private final class MoveDownActionHandler
    extends SelectionBasedActionHandler {
        private MoveDownActionHandler() {
        }

        @Override
        protected boolean computeEnablementState() {
            if (super.computeEnablementState() && TablePropertyEditorPresentation.this.getSelectedElements().size() == 1 && TablePropertyEditorPresentation.this.tableViewer.getComparator() == null) {
                Element modelElement = TablePropertyEditorPresentation.this.getSelectedElement();
                ElementList<?> list = TablePropertyEditorPresentation.this.list();
                return list.indexOf((Object)modelElement) < list.size() - 1;
            }
            return false;
        }

        @Override
        protected final Object executeTablePropertyEditorAction(Presentation context) {
            Element element = TablePropertyEditorPresentation.this.getSelectedElement();
            TablePropertyEditorPresentation.this.list().moveDown(element);
            TablePropertyEditorPresentation.this.tableViewer.reveal(element);
            return null;
        }
    }

    private final class MoveUpActionHandler
    extends SelectionBasedActionHandler {
        private MoveUpActionHandler() {
        }

        @Override
        protected boolean computeEnablementState() {
            if (super.computeEnablementState() && TablePropertyEditorPresentation.this.getSelectedElements().size() == 1 && TablePropertyEditorPresentation.this.tableViewer.getComparator() == null) {
                Element modelElement = TablePropertyEditorPresentation.this.getSelectedElement();
                return TablePropertyEditorPresentation.this.list().indexOf((Object)modelElement) > 0;
            }
            return false;
        }

        @Override
        protected final Object executeTablePropertyEditorAction(Presentation context) {
            Element element = TablePropertyEditorPresentation.this.getSelectedElement();
            TablePropertyEditorPresentation.this.list().moveUp(element);
            TablePropertyEditorPresentation.this.tableViewer.reveal(element);
            return null;
        }
    }

    private final class PopUpListFieldColumnPresentation
    extends ColumnHandler {
        private final PopUpListFieldStyle popUpListFieldStyle;

        public PopUpListFieldColumnPresentation(TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ModelPath property, boolean showElementImage, PopUpListFieldStyle popUpListFieldStyle) {
            super(tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
            this.popUpListFieldStyle = popUpListFieldStyle;
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private PopUpListFieldCellEditorPresentation cellEditor;

                @Override
                public CellEditor getCellEditor(Object obj) {
                    if (this.cellEditor != null) {
                        this.cellEditor.dispose();
                    }
                    PropertyEditorPart propertyEditor = PopUpListFieldColumnPresentation.this.editor(((TableRow)obj).element());
                    this.cellEditor = new PopUpListFieldCellEditorPresentation((StructuredViewer)PopUpListFieldColumnPresentation.this.getTableViewer(), PopUpListFieldColumnPresentation.this.getSelectionProvider(), propertyEditor.property(), PopUpListFieldColumnPresentation.this.popUpListFieldStyle, PopUpListFieldColumnPresentation.this.getTable().getLinesVisible() ? 0 : 2048);
                    return this.cellEditor;
                }

                @Override
                public Object getValue(Object obj) {
                    return PopUpListFieldColumnPresentation.this.property(((TableRow)obj).element());
                }

                @Override
                public void setValue(Object obj, Object value) {
                    PopUpListFieldColumnPresentation.this.property(((TableRow)obj).element()).write(value, true);
                }
            };
        }
    }

    private abstract class SelectionBasedActionHandler
    extends TablePropertyEditorActionHandler {
        private SelectionBasedActionHandler() {
        }

        @Override
        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            final ListSelectionService selectionService = action.getPart().service(ListSelectionService.class);
            final Listener selectionListener = new Listener(){

                public void handle(Event event) {
                    SelectionBasedActionHandler.this.refreshEnablementState();
                }
            };
            selectionService.attach(selectionListener);
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        selectionService.detach(selectionListener);
                    }
                }
            });
        }
    }

    public static final class SelectionProvider
    implements ISelectionProvider {
        private final TableViewer tableViewer;
        private final Set<ISelectionChangedListener> listeners;
        private ISelection fakeSelection;

        public SelectionProvider(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
            this.listeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
            this.fakeSelection = null;
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionProvider.this.notifySelectionChangedListeners();
                }
            });
        }

        public IStructuredSelection getSelectedRows() {
            return (IStructuredSelection)(this.fakeSelection != null ? this.fakeSelection : this.tableViewer.getSelection());
        }

        public ISelection getSelection() {
            ListFactory elements = ListFactory.start();
            for (TableRow row : this.getSelectedRows()) {
                elements.add((Object)row.element());
            }
            return new StructuredSelection(elements.result());
        }

        public void setSelection(ISelection selection) {
            throw new UnsupportedOperationException();
        }

        public void setFakeSelection(ISelection selection) {
            this.fakeSelection = selection;
            this.notifySelectionChangedListeners();
        }

        public final void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        private final void notifySelectionChangedListeners() {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(event);
            }
        }
    }

    private abstract class TablePropertyEditorActionHandler
    extends PropertyEditorActionHandler {
        private TablePropertyEditorActionHandler() {
        }

        @Override
        protected final Object run(Presentation context) {
            TablePropertyEditorPresentation.this.tableViewer.applyEditorValue();
            return this.executeTablePropertyEditorAction(context);
        }

        protected abstract Object executeTablePropertyEditorAction(Presentation var1);
    }

    private final class TableRow {
        private final Element element;
        private final ImageProvider imageProvider;
        private Listener validationListener;
        private Status.Severity validationSeverity;

        public TableRow(Element element, ImageProvider imageProvider) {
            this.element = element;
            this.imageProvider = imageProvider;
            if (this.imageProvider != null) {
                this.imageProvider.init(this);
            }
        }

        public Element element() {
            return this.element;
        }

        public Image image() {
            ImageData image = this.imageProvider == null ? null : this.imageProvider.image();
            if (image == null) {
                return null;
            }
            if (this.validationListener == null) {
                this.validationListener = new FilteredListener<PropertyValidationEvent>(){

                    protected void handleTypedEvent(PropertyValidationEvent event) {
                        TableRow.this.refreshValidation();
                    }
                };
                this.element.attach(this.validationListener, "*");
                this.validationSeverity = this.element.validation().severity();
            }
            return TablePropertyEditorPresentation.this.part().getSwtResourceCache().image(image, this.validationSeverity);
        }

        private void refreshValidation() {
            Status.Severity freshValidationSeverity = this.element.validation().severity();
            if (this.validationSeverity != freshValidationSeverity) {
                this.validationSeverity = freshValidationSeverity;
                TablePropertyEditorPresentation.this.update(this);
            }
        }

        public void dispose() {
            if (this.imageProvider != null) {
                this.imageProvider.dispose();
            }
            if (this.validationListener != null) {
                this.element.detach(this.validationListener, "*");
            }
        }
    }

    private static final class TableSorter
    extends ViewerComparator {
        private final ColumnHandler columnHandler;
        private final int direction;

        public TableSorter(ColumnHandler columnHandler, int direction) {
            this.columnHandler = columnHandler;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object x, Object y) {
            int result = this.columnHandler.comparePropertyValues(((TableRow)x).element(), ((TableRow)y).element());
            if (this.direction == 128) {
                result *= -1;
            }
            return result;
        }
    }
}

