/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.AuxTextProvider;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.AbstractBinding;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation2;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public abstract class PropertyEditorPresentation
extends PropertyEditorPresentation2 {
    private static final String RELATED_CONTENT_WIDTH = "sapphire.related.content.width";
    @Text(value="actions for {0}")
    private static LocalizableText actionsContextLabel;
    @Text(value="(deprecated)")
    private static LocalizableText deprecatedLabelText;
    protected PropertyEditorAssistDecorator decorator;
    private Label auxTextControl;
    private AuxTextProvider auxTextProvider;
    private final Set<Control> controls;
    private Composite mainPropertyEditorComposite;
    protected AbstractBinding binding;
    private final SapphireActionGroup actions;
    private final SapphireActionPresentationManager actionPresentationManager;
    private final SapphireKeyboardActionPresentation actionPresentationKeyboard;
    private final List<Runnable> onDisposeOperations = new ArrayList<Runnable>();
    private List<FormComponentPresentation> relatedContentPresentations;

    static {
        LocalizableText.init(PropertyEditorPresentation.class);
    }

    public PropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
        this.controls = new HashSet<Control>();
        this.actions = part.getActions();
        this.actionPresentationManager = new SapphireActionPresentationManager(this, this.actions);
        this.actionPresentationManager.setLabel(actionsContextLabel.format(new Object[]{this.property().definition().getLabel(true, CapitalizationType.NO_CAPS, false)}));
        this.actionPresentationKeyboard = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
    }

    @Override
    public PropertyEditorPart part() {
        return (PropertyEditorPart)super.part();
    }

    public Property property() {
        return this.part().property();
    }

    public final Element element() {
        return this.property().element();
    }

    public final SapphireActionGroup getActions() {
        return this.actions;
    }

    public final SapphireActionPresentationManager getActionPresentationManager() {
        return this.actionPresentationManager;
    }

    @Override
    public final Rectangle bounds() {
        Rectangle bounds = this.mainPropertyEditorComposite.getBounds();
        Point position = this.mainPropertyEditorComposite.getParent().toDisplay(bounds.x, bounds.y);
        return new Rectangle(position.x, position.y, bounds.width, bounds.height);
    }

    protected boolean canScaleVertically() {
        return false;
    }

    public PropertyEditorPresentation2 createChildPropertyEditorPresentation(PropertyEditorPart part) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void render() {
        PropertyEditorPart part = this.part();
        Composite composite = this.composite();
        this.createContents(composite);
        String auxText = part.getRenderingHint("aux.text", null);
        Class auxTextProviderClass = part.getRenderingHint("aux.text.provider", null);
        if (auxTextProviderClass != null) {
            try {
                this.auxTextProvider = (AuxTextProvider)auxTextProviderClass.newInstance();
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        if (auxText != null || this.auxTextProvider != null) {
            boolean spanBothColumns = part.getSpanBothColumns();
            if (!spanBothColumns) {
                Label placeholder = new Label(composite, 0);
                placeholder.setLayoutData((Object)GridLayoutUtil.gd());
                placeholder.setText("");
            }
            int hindent = part.getMarginLeft() + 9;
            this.auxTextControl = new Label(composite, 64);
            this.auxTextControl.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), spanBothColumns ? 2 : 1), hindent), 10));
            this.auxTextControl.setForeground(composite.getDisplay().getSystemColor(16));
            SwtUtil.reflowOnResize((Control)this.auxTextControl);
            this.addControl((Control)this.auxTextControl);
            if (auxText != null) {
                this.auxTextControl.setText(auxText);
            }
        }
        FilteredListener<PropertyEvent> propertyChangeListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    @Override
                    public void run() {
                        PropertyEditorPresentation.this.handlePropertyChangedEvent();
                    }
                });
            }
        };
        this.property().attach((Listener)propertyChangeListener);
        this.handlePropertyChangedEvent();
        this.attachPartListener((Listener)new FilteredListener<SapphirePart.FocusReceivedEvent>(){

            protected void handleTypedEvent(SapphirePart.FocusReceivedEvent event) {
                PropertyEditorPresentation.this.handleFocusReceivedEvent();
            }
        });
        this.actionPresentationKeyboard.render();
        this.addOnDisposeOperation(new Runnable((Listener)propertyChangeListener){
            private final /* synthetic */ Listener val$propertyChangeListener;
            {
                this.val$propertyChangeListener = listener;
            }

            @Override
            public void run() {
                PropertyEditorPresentation.this.property().detach(this.val$propertyChangeListener);
            }
        });
    }

    protected abstract void createContents(Composite var1);

    protected final Composite createMainComposite(Composite parent) {
        return this.createMainComposite(parent, new CreateMainCompositeDelegate(this.part()));
    }

    protected final Composite createMainComposite(Composite parent, final CreateMainCompositeDelegate delegate) {
        boolean scaleVertically;
        PropertyEditorPart part = this.part();
        boolean showLabel = delegate.getShowLabel();
        int leftMargin = delegate.getLeftMargin();
        boolean spanBothColumns = delegate.getSpanBothColumns();
        boolean singleLinePresentation = this.isSingleLine();
        List<FormComponentPart> relatedContentParts = part.getRelatedContent();
        int count = relatedContentParts.size();
        if (showLabel) {
            final Label label = new Label(parent, 0);
            this.register((Control)label);
            final Runnable updateLabelOp = new Runnable(){

                @Override
                public void run() {
                    label.setText(String.valueOf(delegate.getLabel(CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
                }
            };
            this.attachPartListener((Listener)new FilteredListener<SapphirePart.LabelChangedEvent>(){

                protected void handleTypedEvent(SapphirePart.LabelChangedEvent event) {
                    updateLabelOp.run();
                    PropertyEditorPresentation.this.layout();
                }
            });
            updateLabelOp.run();
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), singleLinePresentation ? 0x1000000 : 128), spanBothColumns ? 2 : 1), leftMargin + 9));
            this.addControl((Control)label);
        } else if (!spanBothColumns) {
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)GridLayoutUtil.gd());
            spacer.setText("");
            this.register((Control)spacer);
        }
        GridData gd = delegate.canScaleVertically() ? GridLayoutUtil.gdhhint((scaleVertically = part.getScaleVertically()) ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), part.getHeight(150)) : GridLayoutUtil.gdhfill();
        if (spanBothColumns) {
            gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(gd, 2), leftMargin);
        }
        gd = GridLayoutUtil.gdwhint(gd, part.getWidth(200));
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gd);
        this.register((Control)composite);
        if (count == 0) {
            this.mainPropertyEditorComposite = composite;
        } else {
            composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 0));
            Composite mainPropertyEditorOuterComposite = new Composite(composite, 0);
            mainPropertyEditorOuterComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 4, 0, 0));
            final Composite mainPropertyEditorComposite = new Composite(mainPropertyEditorOuterComposite, 0);
            final Sash sash = new Sash(composite, 512);
            sash.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdvfill(), 1));
            final Composite relatedContentComposite = new Composite(composite, 0);
            relatedContentComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
            relatedContentComposite.setData(RELATED_CONTENT_WIDTH, (Object)((double)part.getRelatedContentWidth() / 100.0));
            composite.addListener(11, new org.eclipse.swt.widgets.Listener(){

                public void handleEvent(Event event) {
                    PropertyEditorPresentation.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
                }
            });
            sash.addListener(13, new org.eclipse.swt.widgets.Listener(){

                public void handleEvent(Event event) {
                    int width = composite.getClientArea().width - sash.getBounds().width;
                    double ratio = (double)(width - event.x) / (double)width;
                    if (ratio < 0.2) {
                        ratio = 0.2;
                    }
                    if (ratio > 0.8) {
                        ratio = 0.8;
                    }
                    relatedContentComposite.setData(PropertyEditorPresentation.RELATED_CONTENT_WIDTH, (Object)ratio);
                    PropertyEditorPresentation.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
                }
            });
            ListFactory relatedContentPresentations = ListFactory.start();
            for (FormComponentPart relatedContentPart : relatedContentParts) {
                FormComponentPresentation relatedContentPresentation = relatedContentPart.createPresentation(this, relatedContentComposite);
                relatedContentPresentations.add((Object)relatedContentPresentation);
                relatedContentPresentation.render();
            }
            this.relatedContentPresentations = relatedContentPresentations.result();
            boolean vcenter = singleLinePresentation && relatedContentParts.size() == 1 && ((FormComponentPresentation)relatedContentPresentations.get(0)).isSingleLine();
            mainPropertyEditorOuterComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdhfill() : GridLayoutUtil.gdfill()));
            mainPropertyEditorComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
            relatedContentComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
            this.mainPropertyEditorComposite = mainPropertyEditorComposite;
        }
        return this.mainPropertyEditorComposite;
    }

    @Override
    public boolean isSingleLine() {
        PropertyDef pdef = this.property().definition();
        return pdef instanceof ValueProperty && !pdef.hasAnnotation(LongString.class);
    }

    private static final void refreshSashFormLayout(Composite rootComposite, Composite mainPropertyEditorComposite, Composite relatedContentComposite, Sash sash) {
        int mainPropertyEditorCompositeWidth;
        int rootCompositeWidth = rootComposite.getClientArea().width - sash.getBounds().width;
        double relatedContentCompositeWidthRatio = (Double)relatedContentComposite.getData(RELATED_CONTENT_WIDTH);
        int relatedContentCompositeWidth = (int)((double)rootCompositeWidth * relatedContentCompositeWidthRatio);
        ((GridData)mainPropertyEditorComposite.getLayoutData()).widthHint = mainPropertyEditorCompositeWidth = rootCompositeWidth - relatedContentCompositeWidth;
        ((GridData)relatedContentComposite.getLayoutData()).widthHint = relatedContentCompositeWidth;
        rootComposite.layout(true, true);
    }

    protected final PropertyEditorAssistDecorator createDecorator(Composite parent) {
        this.decorator = new PropertyEditorAssistDecorator(this.part(), parent);
        return this.decorator;
    }

    protected final Control createDeprecationMarker(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(deprecatedLabelText.text());
        this.addControl((Control)label);
        label.setForeground(parent.getDisplay().getSystemColor(16));
        return label;
    }

    protected final void addControl(final Control control) {
        Property property = this.property();
        this.controls.add(control);
        control.setEnabled(property.enabled());
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PropertyEditorPresentation.this.controls.remove(control);
                boolean timeToDispose = true;
                for (Control control2 : PropertyEditorPresentation.this.controls) {
                    if (control2.isDisposed()) continue;
                    timeToDispose = false;
                }
                if (timeToDispose) {
                    PropertyEditorPresentation.this.dispose();
                }
            }
        });
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addControl(child);
                ++n2;
            }
        }
        this.actionPresentationKeyboard.attach(control);
        PropertyEditorPresentation.attachHelp(control, property);
    }

    protected void handlePropertyChangedEvent() {
        boolean enabled = this.property().enabled();
        for (Control control : this.controls) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
        if (this.auxTextProvider != null) {
            String auxText = this.auxTextProvider.getAuxText(this.property().element(), this.property().definition());
            this.auxTextControl.setText("(" + auxText + ")");
        }
    }

    protected void handleFocusReceivedEvent() {
    }

    protected final void addOnDisposeOperation(Runnable op) {
        this.onDisposeOperations.add(op);
    }

    @Override
    public void dispose() {
        for (Runnable runnable : this.onDisposeOperations) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        this.onDisposeOperations.clear();
        if (this.relatedContentPresentations != null) {
            for (Presentation presentation : this.relatedContentPresentations) {
                presentation.dispose();
            }
            this.relatedContentPresentations = null;
        }
        super.dispose();
    }

    protected class CreateMainCompositeDelegate {
        private final PropertyEditorPart part;

        public CreateMainCompositeDelegate(PropertyEditorPart part) {
            this.part = part;
        }

        public boolean getShowLabel() {
            return this.part.label() != null;
        }

        public String getLabel(CapitalizationType capitalizationType, boolean includeMnemonic) {
            return this.part.label(capitalizationType, includeMnemonic);
        }

        public int getLeftMargin() {
            return this.part.getMarginLeft();
        }

        public boolean getSpanBothColumns() {
            return this.part.getSpanBothColumns();
        }

        public boolean canScaleVertically() {
            return PropertyEditorPresentation.this.canScaleVertically();
        }
    }
}

