/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.poller.PollThread;
import org.fusesource.ide.server.karaf.core.server.ControllableKarafServerBehavior;
import org.fusesource.ide.server.karaf.core.server.subsystems.IServerPortController;
import org.fusesource.ide.server.karaf.core.server.subsystems.Karaf2xPortController;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;

public class Karaf2xShutdownController
extends AbstractSubsystemController
implements IServerShutdownController {
    public IStatus canStop() {
        if (this.getServer().getServerState() == 2) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void stop(boolean force) {
        boolean ignoreLaunch = false;
        try {
            ILaunchConfiguration config = this.getServer().getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
            ignoreLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((ILaunchConfiguration)config);
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log(ce.getStatus());
        }
        if (ignoreLaunch) {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
            return;
        }
        this.stopImpl(force);
    }

    protected void stopImpl(boolean force) {
        int state = this.getServer().getServerState();
        if (force || this.shouldUseForce()) {
            this.forceStop();
        } else if (state == 1 || state == 3) {
            this.cancelPolling();
            this.forceStop();
        } else {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopping();
            IStatus result = this.gracefullStop();
            if (!result.isOK()) {
                this.setNextStopRequiresForce(true);
                ((ControllableServerBehavior)this.getControllableBehavior()).setServerStarted();
            }
        }
    }

    protected IStatus gracefullStop() {
        try {
            IServerPortController ctrl = (IServerPortController)((ControllableKarafServerBehavior)this.getControllableBehavior()).getController("port");
            int port = ctrl.findPort(104, -1);
            if (port != -1) {
                return this.shutdownKarafInstance(port);
            }
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus shutdownKarafInstance(int managementPort) {
        block17: {
            Socket s = null;
            try {
                Karaf2xPortController ctrl = (Karaf2xPortController)((ControllableKarafServerBehavior)this.getControllableBehavior()).getController("port");
                String shutdownCommand = ctrl.getShutdownCommand();
                s = new Socket(this.getServer().getHost(), managementPort);
                s.getOutputStream().write(shutdownCommand.getBytes());
            }
            catch (CoreException e) {
                Activator.getLogger().error((Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
                return iStatus;
            }
            catch (IOException ex) {
                IStatus iStatus;
                block16: {
                    try {
                        Activator.getLogger().error((Throwable)ex);
                        iStatus = Status.CANCEL_STATUS;
                        if (s == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
                return iStatus;
            }
            if (s == null) break block17;
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }

    protected boolean shouldUseForce() {
        int state = this.getServer().getServerState();
        boolean useForce = !this.isProcessRunning() || state == 4 || this.getRequiresForce();
        return useForce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceStop() {
        Karaf2xShutdownController karaf2xShutdownController = this;
        synchronized (karaf2xShutdownController) {
            if (this.isProcessRunning()) {
                try {
                    this.getProcess().terminate();
                }
                catch (DebugException debugException) {}
            }
            this.clearProcess();
            this.setNextStopRequiresForce(false);
        }
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
    }

    protected IProcess getProcess() {
        IProcess existing = (IProcess)this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
        return existing;
    }

    protected boolean getRequiresForce() {
        Object o = this.getControllableBehavior().getSharedData("DeployableServerBehavior.RequiresForceStop");
        return o == null ? false : (Boolean)o;
    }

    protected boolean isProcessRunning() {
        boolean isProcessRunning = this.getProcess() != null && !this.getProcess().isTerminated();
        return isProcessRunning;
    }

    protected void clearProcess() {
        this.getControllableBehavior().putSharedData("AbstractStartJavaServerLaunchDelegate.Process", null);
    }

    protected void setNextStopRequiresForce(boolean val) {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)val);
    }

    protected void cancelPolling() {
        Object o = this.getControllableBehavior().getSharedData("karafPoller");
        if (o instanceof PollThread) {
            PollThread pollThread = (PollThread)o;
            pollThread.cancel();
        }
    }
}

