/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.IPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafJMXPublisher;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;

public class Karaf2xPublishController
extends AbstractSubsystemController
implements IPublishController {
    public static final List<String> GOALS = Arrays.asList("clean", "package");
    protected IPublishBehaviour publisher = new KarafJMXPublisher();

    public IStatus canPublish() {
        return Status.OK_STATUS;
    }

    public boolean canPublishModule(IModule[] module) {
        IModule[] iModuleArray = module;
        int n = module.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (!m.getModuleType().getId().equals("fuse.camel") && !m.getModuleType().getVersion().equals("1.0")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.validate();
        int status = 0;
        int publishType = KarafUtils.getPublishType(this.getServer(), module, kind, deltaKind);
        switch (publishType) {
            case 2: {
                if (!module[0].exists()) break;
                KarafUtils.runBuild(GOALS, module[0], monitor);
                status = this.publisher.publish(this.getServer(), module);
                ((Server)this.getServer()).setModuleState(module, status);
                ((Server)this.getServer()).setModulePublishState(module, 1);
                ((Server)this.getServer()).setServerPublishState(1);
                status = 1;
                break;
            }
            case 1: {
                if (!module[0].exists()) break;
                KarafUtils.runBuild(GOALS, module[0], monitor);
                status = this.publisher.publish(this.getServer(), module);
                ((Server)this.getServer()).setModuleState(module, status);
                ((Server)this.getServer()).setModulePublishState(module, 1);
                ((Server)this.getServer()).setServerPublishState(1);
                status = 1;
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                boolean done = this.publisher.uninstall(this.getServer(), module);
                if (!done) break;
                ((Server)this.getServer()).setModuleState(module, 0);
                ((Server)this.getServer()).setModulePublishState(module, 0);
                ((Server)this.getServer()).setServerPublishState(1);
                status = 1;
                break;
            }
            default: {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.fusesource.ide.server.karaf.core", "Unknown publish type " + publishType));
            }
        }
        return status;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.validate();
    }
}

