/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.BaseConfigPropertyProvider;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.core.server.subsystems.IServerPortController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;

public class Karaf2xPortController
extends AbstractSubsystemController
implements IServerPortController {
    private static final String KARAF_DATA_PLACEHOLDER = "${karaf.data}";
    private static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    private static final String SHUTDOWN_COMMAND_PROPERTY = "karaf.shutdown.command";
    public static final String SHUTDOWN_PORT_PROPERTY = "karaf.shutdown.port";
    public static final String SHUTDOWN_PORT_FILE_PROPERTY = "karaf.shutdown.port.file";

    @Override
    public int findPort(int id, int defaultValue) {
        int port = defaultValue;
        switch (id) {
            case 100: {
                port = this.findJNDIPort(defaultValue);
                break;
            }
            case 102: {
                port = this.findPortOffset(defaultValue);
                break;
            }
            case 101: {
                port = this.findWebPort(defaultValue);
                break;
            }
            case 103: {
                port = this.findJMXRMIPort(defaultValue);
                break;
            }
            case 105: {
                port = this.findSSHPort(defaultValue);
                break;
            }
            case 104: {
                port = this.findManagementPort(defaultValue);
            }
        }
        return port;
    }

    protected int findJNDIPort(int defaultValue) {
        return defaultValue;
    }

    protected int findPortOffset(int defaultValue) {
        return defaultValue;
    }

    protected int findWebPort(int defaultValue) {
        return defaultValue;
    }

    protected int findJMXRMIPort(int defaultValue) {
        return defaultValue;
    }

    protected int findSSHPort(int defaultValue) {
        IKarafServerDelegate ksd;
        IServer s = this.getServer();
        if (s != null && (ksd = (IKarafServerDelegate)s.loadAdapter(IKarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            return ksd.getPortNumber();
        }
        return defaultValue;
    }

    protected int findManagementPort(int defaultValue) {
        BaseConfigPropertyProvider provider = new BaseConfigPropertyProvider(this.getServerConfigPropertyFile());
        String sPort = provider.getConfigurationProperty(SHUTDOWN_PORT_PROPERTY);
        String sPortFile = provider.getConfigurationProperty(SHUTDOWN_PORT_FILE_PROPERTY);
        if (sPort == null) {
            sPortFile = this.substitutePlaceHolders(sPortFile);
            sPort = this.readKarafShutdownPortFromFile(sPortFile);
        }
        try {
            return Integer.parseInt(sPort);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String substitutePlaceHolders(String value) {
        int idx = value.indexOf(KARAF_DATA_PLACEHOLDER);
        if (idx != -1) {
            return String.valueOf(this.getServer().getRuntime().getLocation().append("data").toOSString()) + value.substring(idx + KARAF_DATA_PLACEHOLDER.length());
        }
        return value;
    }

    protected String getShutdownCommand() {
        BaseConfigPropertyProvider provider = new BaseConfigPropertyProvider(this.getServerConfigPropertyFile());
        String cmd = provider.getConfigurationProperty(this.getShutdownCommandPropertyKey());
        if (cmd == null) {
            cmd = this.getDefaultKarafShutdownCommand();
        }
        return cmd;
    }

    protected File getServerConfigPropertyFile() {
        return this.getServer().getRuntime().getLocation().append("etc").append("config.properties").toFile();
    }

    protected String getKarafDataPlaceholder() {
        return KARAF_DATA_PLACEHOLDER;
    }

    protected String getDefaultKarafShutdownCommand() {
        return DEFAULT_SHUTDOWN_COMMAND;
    }

    protected String getShutdownCommandPropertyKey() {
        return SHUTDOWN_COMMAND_PROPERTY;
    }

    protected String getShutdownPortPropertyKey() {
        return SHUTDOWN_PORT_PROPERTY;
    }

    protected String getShutdownPortFile() {
        return SHUTDOWN_PORT_FILE_PROPERTY;
    }

    /*
     * Loose catch block
     */
    private String readKarafShutdownPortFromFile(String portFile) {
        String string;
        BufferedReader br;
        block11: {
            br = null;
            br = new BufferedReader(new FileReader(new File(portFile)));
            string = br.readLine();
            if (br == null) break block11;
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (IOException ex) {
            block12: {
                try {
                    Activator.getLogger().error((Throwable)ex);
                    if (br == null) break block12;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

