/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.IPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.IJMXPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafBundleMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafBundlesMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.OSGIMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;

public class KarafJMXPublisher
implements IPublishBehaviour {
    private static final ArrayList<IJMXPublishBehaviour> KNOWN_JMX_BEHAVIOURS = new ArrayList();
    protected JMXServiceURL url;
    protected JMXConnector jmxc;
    protected MBeanServerConnection mbsc;
    protected IServer server;
    protected IJMXPublishBehaviour jmxPublisher;

    static {
        KNOWN_JMX_BEHAVIOURS.add(new KarafBundleMBeanPublishBehaviour());
        KNOWN_JMX_BEHAVIOURS.add(new KarafBundlesMBeanPublishBehaviour());
        KNOWN_JMX_BEHAVIOURS.add(new OSGIMBeanPublishBehaviour());
    }

    protected boolean connect(IServer server) {
        this.server = server;
        KarafServerDelegate del = (KarafServerDelegate)server.loadAdapter(KarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String[]> envMap = new HashMap<String, String[]>();
        envMap.put("jmx.remote.credentials", new String[]{del.getUserName(), del.getPassword()});
        try {
            String conUrl = KarafUtils.getJMXConnectionURL(server);
            this.url = new JMXServiceURL(conUrl);
            this.jmxc = JMXConnectorFactory.connect(this.url, envMap);
            this.mbsc = this.jmxc.getMBeanServerConnection();
            for (IJMXPublishBehaviour pb : KNOWN_JMX_BEHAVIOURS) {
                if (!pb.canHandle(this.mbsc)) continue;
                this.jmxPublisher = pb;
                break;
            }
            return this.jmxPublisher != null;
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    protected boolean disconnect(IServer server) {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
            }
            return true;
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.jmxc = null;
            this.mbsc = null;
            this.url = null;
        }
        return false;
    }

    @Override
    public int publish(IServer server, IModule[] module) {
        if (this.jmxc == null) {
            this.connect(server);
        }
        try {
            String version = KarafUtils.getBundleVersion(module[0], null);
            long bundleId = this.jmxPublisher.getBundleId(this.mbsc, KarafUtils.getBundleSymbolicName(module[0]), version);
            if (bundleId != -1L) {
                this.reinstallBundle(server, module[0], bundleId);
            } else {
                bundleId = this.installBundle(server, module[0]);
            }
            if (bundleId != -1L) {
                int n = this.jmxPublisher.getBundleStatus(this.mbsc, bundleId);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect(server);
        }
        return 0;
    }

    @Override
    public boolean uninstall(IServer server, IModule[] module) {
        if (this.jmxc == null) {
            this.connect(server);
        }
        boolean unpublished = false;
        try {
            try {
                String version = KarafUtils.getBundleVersion(module[0], null);
                long bundleId = this.jmxPublisher.getBundleId(this.mbsc, KarafUtils.getBundleSymbolicName(module[0]), version);
                if (bundleId != -1L) {
                    unpublished = this.jmxPublisher.uninstallBundle(this.mbsc, bundleId);
                }
            }
            catch (CoreException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.disconnect(server);
            }
        }
        finally {
            this.disconnect(server);
        }
        return unpublished;
    }

    private boolean reinstallBundle(IServer server, IModule module, long bundleId) throws CoreException {
        String fileUrl = KarafUtils.getBundleFilePath(module);
        if (fileUrl != null) {
            return this.jmxPublisher.updateBundle(this.mbsc, bundleId, fileUrl);
        }
        return false;
    }

    private long installBundle(IServer server, IModule module) throws CoreException {
        String fileUrl = KarafUtils.getBundleFilePath(module);
        if (fileUrl != null) {
            long bundleId = this.jmxPublisher.installBundle(this.mbsc, fileUrl);
            return bundleId;
        }
        return -1L;
    }
}

