/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.poller;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IPollResultListener;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;

public class PollThread
extends Thread {
    public static final int POLLING_ROOT_CODE = 0x1010000;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int POLLING_FAIL_CODE = 0x1010000;
    public static final int STATE_MASK = 56;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_STARTING = 8;
    public static final int STATE_STARTED = 16;
    public static final int STATE_STOPPING = 24;
    public static final int STATE_STOPPED = 32;
    public static final String SERVER_STARTING = "org.jboss.ide.eclipse.as.core.runtime.server.PollThread.server.starting";
    public static final String SERVER_STOPPING = "org.jboss.ide.eclipse.as.core.runtime.server.PollThread.server.stopping";
    private boolean expectedState;
    private boolean abort;
    private boolean stateStartedOrStopped;
    private IServerStatePoller poller;
    private String abortMessage;
    private String pollerId;
    private IPollResultListener listener;
    private IServer server;

    public PollThread(boolean expectedState, IServerStatePoller poller, IPollResultListener listener, IServer server) {
        super(PollThread.getThreadName(server));
        this.expectedState = expectedState;
        this.poller = poller;
        this.server = server;
        this.listener = listener;
        this.abort = false;
    }

    private static String getThreadName(IServer server) {
        return NLS.bind((String)Messages.ServerPollerThreadName, (Object)server.getName());
    }

    public void cancel() {
        this.cancel(null);
    }

    public void cancel(String message) {
        this.abort = true;
        this.abortMessage = message;
        this.poller.cancel(0);
    }

    public int getTimeout() {
        if (this.expectedState) {
            return (this.getServer().getStartTimeout() - 2) * 1000;
        }
        return (this.getServer().getStopTimeout() - 2) * 1000;
    }

    @Override
    public void run() {
        if (this.poller == null) {
            this.alertEventLogStarting();
            this.alertPollerNotFound();
            this.alertListener(!this.expectedState);
            return;
        }
        int maxWait = this.getTimeout();
        this.alertEventLogStarting();
        long startTime = System.currentTimeMillis();
        boolean done = false;
        try {
            this.poller.beginPolling(this.getServer(), this.expectedState);
            while (!(this.stateStartedOrStopped || this.abort || done || this.timeoutReached(startTime, maxWait))) {
                block15: {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        done = this.poller.isComplete();
                    }
                    catch (IServerStatePoller.PollingException e) {
                        this.poller.cancel(0);
                        this.poller.cleanup();
                        this.alertEventLogPollerException(e);
                        this.alertListener(!this.expectedState);
                        return;
                    }
                    catch (IServerStatePoller.RequiresInfoException rie) {
                        if (rie.getChecked()) break block15;
                        rie.setChecked();
                        PollThread.fireRequestCredentials(this.expectedState, this.poller);
                    }
                }
                this.stateStartedOrStopped = this.checkServerState();
            }
        }
        catch (Exception e) {
            this.abort = true;
            Status s = new Status(4, "org.fusesource.ide.server.karaf.core", Messages.ServerStatePollerUnexpectedError, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
        if (this.stateStartedOrStopped) {
            this.handleUncertainTermination();
        } else if (this.abort) {
            this.poller.cleanup();
            this.alertEventLogAbort();
        } else if (done) {
            this.handlePollerHasAnswer();
        } else {
            this.handleTimeoutTermination();
        }
    }

    private void handlePollerHasAnswer() {
        boolean finalAlert = true;
        try {
            boolean currentState = this.poller.getState();
            this.poller.cleanup();
            this.alertListener(currentState);
            if (finalAlert) {
                this.alertEventLog(currentState);
            }
        }
        catch (IServerStatePoller.PollingException pe) {
            this.poller.cancel(0);
            this.poller.cleanup();
            this.alertEventLogPollerException(pe);
            this.alertListener(!this.expectedState);
            return;
        }
        catch (IServerStatePoller.RequiresInfoException requiresInfoException) {}
    }

    private void handleTimeoutTermination() {
        this.poller.cancel(1);
        int behavior = this.poller.getTimeoutBehavior();
        this.poller.cleanup();
        this.alertEventLogTimeout();
        if (behavior != 1) {
            boolean currentState = this.expectedState == (behavior == 0);
            this.alertListener(currentState);
        }
    }

    private void handleUncertainTermination() {
        int state = this.server.getServerState();
        boolean success = false;
        success = this.expectedState ? state == 2 : state == 4;
        this.poller.cancel(success ? 2 : 3);
        this.poller.cleanup();
    }

    private boolean timeoutReached(long startTime, int maxWait) {
        return System.currentTimeMillis() >= startTime + (long)maxWait;
    }

    protected boolean checkServerState() {
        int state = this.server.getServerState();
        if (state == 2) {
            return true;
        }
        return state == 4;
    }

    protected void alertEventLog(boolean currentState) {
        if (currentState != this.expectedState) {
            this.alertEventLogFailure();
        } else {
            this.alertEventLogSuccess(currentState);
        }
    }

    protected void alertListener(boolean currentState) {
        if (currentState != this.expectedState) {
            this.listener.stateNotAsserted(this.expectedState, currentState);
        } else {
            this.listener.stateAsserted(this.expectedState, currentState);
        }
    }

    protected IServer getServer() {
        return this.server;
    }

    protected void alertEventLogStarting() {
        String message = this.expectedState ? Messages.PollingStarting : Messages.PollingShuttingDown;
        int state = this.expectedState ? 8 : 24;
        Status status = new Status(1, "org.fusesource.ide.server.karaf.core", 0x1010000 | state, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertEventLogPollerException(IServerStatePoller.PollingException e) {
        Status status = new Status(4, "org.fusesource.ide.server.karaf.core", 0x1010000, Messages.PollerFailure, (Throwable)e);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertEventLogAbort() {
        Status status = new Status(2, "org.fusesource.ide.server.karaf.core", 0x1010000 | this.getStateMask(this.expectedState, false), NLS.bind((String)Messages.PollerAborted, (Object)this.abortMessage), null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertEventLogTimeout() {
        Status status = new Status(4, "org.fusesource.ide.server.karaf.core", 0x1010000 | this.getStateMask(this.expectedState, false), "", null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertEventLogFailure() {
        String startupFailed = Messages.PollingStartupFailed;
        String shutdownFailed = Messages.PollingShutdownFailed;
        Status status = new Status(4, "org.fusesource.ide.server.karaf.core", 0x1010000 | this.getStateMask(this.expectedState, false), this.expectedState ? startupFailed : shutdownFailed, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertEventLogSuccess(boolean currentState) {
        String startupSuccess = Messages.PollingStartupSuccess;
        String shutdownSuccess = Messages.PollingShutdownSuccess;
        int state = this.getStateMask(this.expectedState, true);
        Status status = new Status(1, "org.fusesource.ide.server.karaf.core", 0x1010000 | state | 1, this.expectedState ? startupSuccess : shutdownSuccess, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void alertPollerNotFound() {
        String startupPollerNotFound = NLS.bind((String)Messages.StartupPollerNotFound, (Object)this.pollerId);
        String shutdownPollerNotFound = NLS.bind((String)Messages.ShutdownPollerNotFound, (Object)this.pollerId);
        Status status = new Status(4, "org.fusesource.ide.server.karaf.core", 0x1010000 | this.getStateMask(this.expectedState, false), this.expectedState ? startupPollerNotFound : shutdownPollerNotFound, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected int getStateMask(boolean expected, boolean success) {
        if (expected && success) {
            return 16;
        }
        if (!expected && !success) {
            return 16;
        }
        return 32;
    }

    public static void fireRequestCredentials(boolean expectedState, IServerStatePoller poller) {
    }
}

