/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.jmx;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.jmx.internal.KarafJVMFacadeUtility;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.local.JVMConnectionUtility;

public class KarafJMXModel {
    public static KarafJMXModel instance;
    private HashMap<IServer, IConnectionWrapper> dummies = new HashMap();

    public static synchronized KarafJMXModel getDefault() {
        if (instance == null) {
            instance = new KarafJMXModel();
        }
        return instance;
    }

    protected KarafJMXModel() {
    }

    public IConnectionWrapper findConnectionWrapper(IServer server) {
        IConnectionWrapper found = this.findJVMConnectionWrapper(server);
        if (found == null) {
            IConnectionWrapper dummy = this.dummies.get(server);
            if (dummy == null) {
                dummy = new DummyConnectionWrapper();
                this.dummies.put(server, dummy);
            }
            return dummy;
        }
        return found;
    }

    protected IConnectionWrapper findJVMConnectionWrapper(IServer server) {
        IActiveJvm jvm = KarafJVMFacadeUtility.findJvmForServer(server);
        if (jvm != null) {
            return JVMConnectionUtility.findConnectionForJvm((IActiveJvm)jvm);
        }
        return null;
    }

    private static class DummyConnectionWrapper
    implements IConnectionWrapper {
        private DummyConnectionWrapper() {
        }

        public IConnectionProvider getProvider() {
            return null;
        }

        public boolean isConnected() {
            return false;
        }

        public boolean canControl() {
            return false;
        }

        public void connect() throws IOException {
        }

        public void disconnect() throws IOException {
        }

        public void loadRoot(IProgressMonitor monitor) throws CoreException {
        }

        public Root getRoot() {
            return null;
        }

        public void run(IJMXRunnable runnable) throws JMXException {
        }

        public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        }
    }
}

