/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.bean;

import java.io.File;
import java.io.FilenameFilter;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeKaraf2x
extends ServerBeanType {
    protected static final String KARAF2x_RELEASE_VERSION = "Bundle-Version";
    public static final String V2_2 = "2.2";
    public static final String V2_3 = "2.3";
    public static final String V2_x = "2.";

    protected ServerBeanTypeKaraf2x() {
        super("KARAF2x", "Apache Karaf 2.x", "lib" + File.separator + "karaf.jar", (ICondition)new Karaf2xServerTypeCondition());
    }

    public static class Karaf2xServerTypeCondition
    extends AbstractCondition {
        public boolean isServerRoot(File location) {
            return Karaf2xServerTypeCondition.checkKarafVersion(location, ServerBeanTypeKaraf2x.KARAF2x_RELEASE_VERSION, ServerBeanTypeKaraf2x.V2_x) && !Karaf2xServerTypeCondition.isIntegratedKaraf(location);
        }

        protected static boolean isIntegratedKaraf(File location) {
            File libFolder = new File(location + File.separator + "lib");
            File[] files = libFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith("-version.jar");
                }
            });
            return files.length > 0;
        }

        protected static boolean checkKarafVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeKaraf2x().getSystemJarPath();
            String value = ServerBeanTypeKaraf2x.getJarProperty((File)new File(location + File.separator + mainFolder), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeKaraf2x.V2_2)) {
                return "org.fusesource.ide.karaf.server.22";
            }
            if (version.equals(ServerBeanTypeKaraf2x.V2_3)) {
                return "org.fusesource.ide.karaf.server.23";
            }
            if (version.startsWith(ServerBeanTypeKaraf2x.V2_x)) {
                return "org.fusesource.ide.karaf.server.23";
            }
            return null;
        }
    }
}

