/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.OpenFileCallback;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.RestartCallback;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.ViewSourceCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessLauncher;
import org.jboss.tools.vpe.browsersim.eclipse.preferences.PreferencesUtil;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public class BrowserSimLauncher {
    public static final String BROWSERSIM_CLASS_NAME = "org.jboss.tools.vpe.browsersim.BrowserSimRunner";
    public static final List<ExternalProcessCallback> BROWSERSIM_CALLBACKS = Arrays.asList(new ViewSourceCallback(), new OpenFileCallback(), new RestartCallback());
    public static final List<String> RESOURCES_BUNDLES = Collections.emptyList();
    public static final String NOT_STANDALONE = "-not-standalone";

    public static void launchBrowserSim(String initialUrl) {
        IVMInstall jvm;
        Activator.getDefault().countLaunchEvent();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(NOT_STANDALONE);
        if (initialUrl != null) {
            parameters.add(initialUrl);
        }
        if ((jvm = BrowserSimLauncher.getSelectedVM()) == null) {
            ExternalProcessLauncher.showErrorDialog(Messages.BrowserSim);
        } else {
            String jvmPath = jvm.getInstallLocation().getAbsolutePath();
            String jrePath = String.valueOf(jvm.getInstallLocation().getAbsolutePath()) + File.separator + "jre";
            List<String> bundles = BrowserSimLauncher.getBundles();
            if (!ExternalProcessLauncher.isGTK2() || !BrowserSimUtil.isJavaFxAvailable((String)jvmPath) && !BrowserSimUtil.isJavaFxAvailable((String)jrePath)) {
                bundles.add("org.jboss.tools.vpe.browsersim.javafx.mock");
            }
            ExternalProcessLauncher.launchAsExternalProcess(bundles, RESOURCES_BUNDLES, BROWSERSIM_CALLBACKS, BROWSERSIM_CLASS_NAME, parameters, Messages.BrowserSim, jvm);
        }
    }

    public static List<String> getBundles() {
        ArrayList<String> bundles = new ArrayList<String>();
        bundles.add("org.jboss.tools.vpe.browsersim");
        bundles.add("org.jboss.tools.vpe.browsersim.browser");
        bundles.add("org.jboss.tools.vpe.browsersim.debugger");
        bundles.add("org.eclipse.jetty.server");
        bundles.add("org.eclipse.jetty.servlet");
        bundles.add("org.eclipse.jetty.websocket");
        bundles.add("javax.servlet");
        bundles.add("org.eclipse.jetty.util");
        bundles.add("org.eclipse.jetty.http");
        bundles.add("org.eclipse.jetty.io");
        bundles.add("org.eclipse.jetty.security");
        bundles.add("org.eclipse.jetty.continuation");
        bundles.add("org.eclipse.swt");
        bundles.add("org.eclipse.swt." + PlatformUtil.CURRENT_PLATFORM);
        return bundles;
    }

    public static IVMInstall getSelectedVM() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        IVMInstall jvm = null;
        if ("false".equals(store.getString("org.jboss.tools.vpe.browsersim.jvm.automatically"))) {
            String jvmId = store.getString("org.jboss.tools.vpe.browsersim.jvm");
            jvm = PreferencesUtil.getJVM(jvmId);
        } else {
            List<IVMInstall> jvms = PreferencesUtil.getSuitableJvms(1);
            if (!jvms.isEmpty()) {
                jvm = jvms.get(0);
            }
        }
        return jvm;
    }
}

