/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse.callbacks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.StringInput;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.StringStorage;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.TransparentReader;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;

public class ViewSourceCallback
implements ExternalProcessCallback {
    private static final String VIEW_SOURCE_COMMAND = "org.jboss.tools.vpe.browsersim.command.viewSource:";

    @Override
    public String getCallbackId() {
        return VIEW_SOURCE_COMMAND;
    }

    @Override
    public void call(String lastString, TransparentReader reader) throws IOException {
        final String address = lastString.substring(VIEW_SOURCE_COMMAND.length());
        File tempFile = new File(PreferencesUtil.getConfigFolderPath(), "temp.html");
        FileInputStream input = new FileInputStream(tempFile);
        InputStreamReader reader1 = new InputStreamReader(input);
        BufferedReader bufferedReader = new BufferedReader(reader1);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            try {
                String read;
                while ((read = bufferedReader.readLine()) != null) {
                    stringBuilder.append(read);
                    stringBuilder.append('\n');
                }
            }
            finally {
                bufferedReader.close();
                tempFile.delete();
            }
        }
        catch (IOException e) {
            BrowserSimLogger.logError((String)e.getMessage(), (Throwable)e);
        }
        final String source = stringBuilder.toString();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViewSourceCallback.this.openInMemoryHtmlEditor(source, address, address);
            }
        });
    }

    private void openInMemoryHtmlEditor(String content, String name, String toolTip) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
        if (page != null) {
            try {
                IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("view-source.html");
                String editorId = editorDescriptor != null && editorDescriptor.isInternal() ? editorDescriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
                StringStorage storage = new StringStorage("", "view-source.html");
                StringInput input = new StringInput(storage, name, toolTip);
                IEditorPart editor = page.openEditor((IEditorInput)input, editorId);
                ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (textEditor == null && editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                }
                IDocument doc = null;
                if (textEditor != null && (doc = textEditor.getDocumentProvider().getDocument((Object)input)) == null) {
                    doc = (IDocument)textEditor.getAdapter(IDocument.class);
                }
                if (doc != null) {
                    doc.set(content);
                    editor.doSave(null);
                }
            }
            catch (PartInitException e) {
                Activator.logError(e.getMessage(), e);
            }
        } else {
            Activator.logError(Messages.Callback_CANNOT_OBTAIN_PAGE, null);
        }
    }
}

