/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.preferences.PreferencesUtil;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferencesStorage;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe.browsersim.eclipse";
    private static final String BROWSERSIM_ACTION = "browsersim";
    private static final String JAVA_FX_LABEL = "javafx";
    private static final String WEBKIT_LABEL = "webkit";
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String USER_PREFERENCES_FOLDER = "org.jboss.tools.vpe.browsersim";
    private Map<StyledText, IConsolePageParticipant> viewers = new HashMap<StyledText, IConsolePageParticipant>();
    private static Activator plugin;
    private UsageEventType launchEventType;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.launchEventType = new UsageEventType((Plugin)this, BROWSERSIM_ACTION, Messages.UsageEventTypeLaunchLabelDescription, UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
        UsageReporter.getInstance().registerEvent(this.launchEventType);
    }

    public void countLaunchEvent() {
        try {
            String label = Activator.getEngineName((SpecificPreferencesStorage)BrowserSimSpecificPreferencesStorage.INSTANCE);
            UsageReporter.getInstance().countEvent(this.launchEventType.event(label));
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    public static String getEngineName(SpecificPreferencesStorage storage) throws URISyntaxException, IOException {
        String configFolder = String.valueOf(PreferencesUtil.getAbsolutePathToConfigurationFolder()) + SEPARATOR + USER_PREFERENCES_FOLDER;
        SpecificPreferences sp = (SpecificPreferences)storage.load(configFolder);
        if (sp == null) {
            sp = storage.loadDefault();
        }
        return sp.isJavaFx() ? JAVA_FX_LABEL : WEBKIT_LABEL;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable throwable) {
        Activator.logError(message, throwable, PLUGIN_ID);
    }

    public static void logError(String message, Throwable throwable, String pluginId) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, pluginId, message, throwable));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(Activator.getDefault().getBundle().getEntry("/"), path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addViewer(StyledText viewer, IConsolePageParticipant participant) {
        this.viewers.put(viewer, participant);
    }

    public void removeViewerWithPageParticipant(IConsolePageParticipant participant) {
        HashSet<StyledText> toRemove = new HashSet<StyledText>();
        for (StyledText viewer : this.viewers.keySet()) {
            if (this.viewers.get(viewer) != participant) continue;
            toRemove.add(viewer);
        }
        for (StyledText viewer : toRemove) {
            this.viewers.remove(viewer);
        }
    }
}

