/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.catalog.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class GenerationMain {
    private static ArrayList<String> errors = new ArrayList();
    private static ArrayList<XSDObject> xsdObjs = new ArrayList();
    private static ArrayList<DTDObject> dtObjs = new ArrayList();

    public static void main(String[] args) {
        GenerationMain.runDTDs();
        GenerationMain.runXSDs();
        GenerationMain.runXSDErrors();
    }

    private static void runXSDErrors() {
        HashMap<String, XSDObject> duplicateUriMap = new HashMap<String, XSDObject>();
        for (XSDObject o : xsdObjs) {
            String f2Name;
            String f1Name;
            if (duplicateUriMap.containsKey(o.getName()) && !(f1Name = ((XSDObject)duplicateUriMap.get((Object)o.getName())).file.getName()).equals(f2Name = o.file.getName())) {
                System.err.println(String.valueOf(f1Name) + " is a duplicate with " + f2Name + " and has name " + o.getName());
            }
            duplicateUriMap.put(o.getName(), o);
        }
        Iterator<String> errIt = errors.iterator();
        while (errIt.hasNext()) {
            System.err.println(errIt.next());
        }
    }

    private static void runXSDs() {
        File root = new File(new File("").getAbsolutePath());
        File schemas = new File(root, "schema");
        File xsd = new File(schemas, "xsd");
        File[] all = xsd.listFiles();
        int i = 0;
        while (i < all.length) {
            if (!all[i].getName().equalsIgnoreCase(".gitignore")) {
                XSDObject o = new XSDObject(all[i]);
                if (o.valid) {
                    xsdObjs.add(o);
                } else {
                    errors.add(all[i] + " is invalid: " + (o.validException == null ? "null" : o.validException.getMessage()));
                }
            }
            ++i;
        }
        Collections.sort(xsdObjs, new Comparator<XSDObject>(){

            @Override
            public int compare(XSDObject o1, XSDObject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (XSDObject o : xsdObjs) {
            if (!o.valid) continue;
            System.out.println(o.toString());
        }
    }

    private static void runDTDs() {
        File root = new File(new File("").getAbsolutePath());
        File schemas = new File(root, "schema");
        File dtd = new File(schemas, "dtd");
        File[] dtdFiles = dtd.listFiles();
        int i = 0;
        while (i < dtdFiles.length) {
            try {
                GenerationMain.handleDTD(dtdFiles[i]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            ++i;
        }
        for (DTDObject o : dtObjs) {
            if (!o.isValid) continue;
            System.out.println(o.toString());
        }
    }

    private static void handleDTD(File f) throws IOException {
        DTDObject o = new DTDObject(f);
        if (o.isValid()) {
            dtObjs.add(o);
        }
    }

    private static String getFileContents(File file) throws IOException {
        byte[] contents = GenerationMain.getBytesFromFile(file);
        return new String(contents);
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static class DTDObject {
        public String contents;
        public String toString;
        public boolean isValid = true;
        public String error = null;
        public File f;

        public DTDObject(File f) {
            try {
                this.f = f;
                this.contents = GenerationMain.getFileContents(f);
                this.checkValid();
            }
            catch (IOException iOException) {
                this.isValid = false;
            }
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getError() {
            return this.error;
        }

        private void checkValid() {
            int start = this.contents.indexOf("PUBLIC");
            if (start == -1) {
                String err;
                this.error = err = "Improper format: " + this.f.getAbsolutePath();
                this.isValid = false;
                return;
            }
            int end = this.contents.indexOf(">", start + 1);
            this.contents.substring(start, end);
            int publicOpenQuote = this.contents.indexOf("\"", start);
            int publicCloseQuote = this.contents.indexOf("\"", publicOpenQuote + 1);
            String publicString = this.contents.substring(publicOpenQuote + 1, publicCloseQuote);
            int webURLOpenQuote = this.contents.indexOf("\"", publicCloseQuote + 1);
            int webURLCloseQuote = this.contents.indexOf("\"", webURLOpenQuote + 1);
            String webURL = this.contents.substring(webURLOpenQuote + 1, webURLCloseQuote);
            String uri = "dtd/" + this.f.getName();
            StringBuffer sb = new StringBuffer();
            sb.append("\t\t\t<public publicId=\"");
            sb.append(publicString);
            sb.append("\"\n\t\t\t\turi=\"");
            sb.append(uri);
            sb.append("\"/>\n");
            sb.append("\t\t\t<system systemId=\"");
            sb.append(webURL);
            sb.append("\"\n\t\t\t\turi=\"");
            sb.append(uri);
            sb.append("\"/>\n");
            this.toString = sb.toString();
        }

        public String toString() {
            return this.toString;
        }
    }

    private static class XSDObject {
        String contents = null;
        File file = null;
        boolean valid = true;
        Exception validException = null;
        String uri = null;

        public XSDObject(File f) {
            try {
                this.file = f;
                this.contents = GenerationMain.getFileContents(f);
                this.toString();
            }
            catch (IOException ioe) {
                this.valid = false;
                this.validException = ioe;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\t\t<public publicId=\"");
            sb.append(this.getName());
            sb.append("\" uri=\"");
            sb.append(this.getUri());
            sb.append("\"/>");
            return sb.toString();
        }

        String getUri() {
            String uri = "xsd/" + this.file.getName();
            return uri;
        }

        String getName() {
            if (this.uri != null) {
                return this.uri;
            }
            int start = this.contents.indexOf("targetNamespace=\"");
            if (start == -1) {
                start = this.contents.indexOf("xmlns=\"");
            }
            if (start == -1) {
                this.valid = false;
                return "";
            }
            int subStart = this.contents.indexOf("\"", start);
            int subEnd = this.contents.indexOf("\"", subStart + 1);
            this.uri = this.contents.substring(subStart + 1, subEnd);
            if ("http://www.jboss.com/xml/ns/javaee".equals(this.uri)) {
                this.uri = "http://www.jboss.org/j2ee/schema/" + this.file.getName();
            }
            return this.uri;
        }
    }
}

