/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class ShapeLayoutManager {
    private static final int HORZ_PADDING = 50;
    private static final int VERT_PADDING = 50;
    private DiagramEditor editor;
    private static final ILayoutService layoutService = Graphiti.getLayoutService();

    public ShapeLayoutManager(DiagramEditor editor) {
        this.editor = editor;
    }

    public void layout(BaseElement container) {
        this.layout(this.getContainerShape(container));
        this.editor.selectPictogramElements(new PictogramElement[0]);
    }

    public void layout(ContainerShape container) {
        this.layout(container, 0);
    }

    private void layout(ContainerShape container, int level) {
        GraphicsUtil.dump(level, "layout", container);
        if (container == null) {
            return;
        }
        ArrayList<ContainerShape> childShapes = new ArrayList<ContainerShape>();
        int i = 0;
        while (i < container.getChildren().size()) {
            PictogramElement pe = (PictogramElement)container.getChildren().get(i);
            if (this.isChildShape(pe)) {
                ContainerShape childContainer = (ContainerShape)pe;
                boolean hasChildren = false;
                for (Shape shape : childContainer.getChildren()) {
                    if (!this.isChildShape((PictogramElement)shape)) continue;
                    hasChildren = true;
                    break;
                }
                if (hasChildren) {
                    this.layout(childContainer, level + 1);
                }
                if (container instanceof Diagram) {
                    childShapes.add(0, childContainer);
                } else {
                    childShapes.add(childContainer);
                }
            }
            ++i;
        }
        ArrayList<ContainerShape> startShapes = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> unconnectedShapes = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> middleShapes = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> endShapes = new ArrayList<ContainerShape>();
        for (ContainerShape child : childShapes) {
            ContainerShape shape;
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)child);
            if (be instanceof Participant && ModelUtil.isParticipantBand((Participant)be)) continue;
            List<SequenceFlow> incomingFlows = this.getIncomingSequenceFlows(child);
            List<SequenceFlow> outgoingFlows = this.getOutgoingSequenceFlows(child);
            int incomingCount = 0;
            int outgoingCount = 0;
            for (SequenceFlow sf : incomingFlows) {
                shape = this.getContainerShape((BaseElement)sf.getSourceRef());
                if (!childShapes.contains(shape) || shape == child) continue;
                ++incomingCount;
            }
            for (SequenceFlow sf : outgoingFlows) {
                shape = this.getContainerShape((BaseElement)sf.getTargetRef());
                if (!childShapes.contains(shape) || shape == child) continue;
                ++outgoingCount;
            }
            if (incomingCount == 0) {
                if (outgoingCount == 0) {
                    unconnectedShapes.add(child);
                    continue;
                }
                startShapes.add(child);
                continue;
            }
            if (outgoingCount == 0) {
                endShapes.add(child);
                continue;
            }
            middleShapes.add(child);
        }
        ArrayList<List<ContainerShape[]>> threads = new ArrayList<List<ContainerShape[]>>();
        if (startShapes.size() > 0) {
            for (ContainerShape child : startShapes) {
                List<ContainerShape[]> thread = new ArrayList();
                thread.add(new ContainerShape[]{child});
                this.buildThread(child, childShapes, thread);
                threads.add(thread);
            }
        }
        int x = 50;
        int y = 50;
        for (List<ContainerShape[]> thread : threads) {
            int n;
            x = 50;
            int threadHeight = 0;
            for (ContainerShape[] group : thread) {
                int groupHeight = (group.length - 1) * 50;
                ContainerShape[] containerShapeArray = group;
                n = group.length;
                int n2 = 0;
                while (n2 < n) {
                    ContainerShape shape = containerShapeArray[n2];
                    IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
                    if ((groupHeight += size.getHeight()) > threadHeight) {
                        threadHeight = groupHeight;
                    }
                    ++n2;
                }
                threadHeight += (group.length - 1) * 50;
            }
            for (ContainerShape[] group : thread) {
                int groupWidth = 0;
                int groupHeight = (group.length - 1) * 50;
                ContainerShape[] containerShapeArray = group;
                int n3 = group.length;
                n = 0;
                while (n < n3) {
                    ContainerShape shape = containerShapeArray[n];
                    IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
                    groupHeight += size.getHeight();
                    ++n;
                }
                int sy = y + (threadHeight / 2 - groupHeight / 2);
                ContainerShape[] containerShapeArray2 = group;
                int n4 = group.length;
                n3 = 0;
                while (n3 < n4) {
                    ContainerShape shape = containerShapeArray2[n3];
                    IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
                    if (size.getWidth() > groupWidth) {
                        groupWidth = size.getWidth();
                    }
                    this.moveShape(container, shape, x, sy);
                    sy += size.getHeight() + 50;
                    ++n3;
                }
                x += groupWidth + 50;
            }
            y += threadHeight + 50;
        }
        this.stackShapes(container, unconnectedShapes);
        if (startShapes.size() == 0 && endShapes.size() == 0 && middleShapes.size() > 0) {
            this.stackShapes(container, middleShapes);
        }
        if (!(container instanceof Diagram)) {
            this.resizeContainerShape(container);
        }
    }

    private void stackShapes(ContainerShape container, List<ContainerShape> unconnectedShapes) {
        int maxWidth = 0;
        int maxHeight = 0;
        int x = 50;
        int y = 50;
        if (unconnectedShapes.size() > 0) {
            Point p;
            IDimension size;
            BaseElement be;
            List<ContainerShape> children = this.getContainerShapeChildren(container);
            for (ContainerShape shape : unconnectedShapes) {
                be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)shape);
                if (this.getContainerShapeChildren(shape).size() != 0 || be instanceof Lane) continue;
                size = GraphicsUtil.calculateSize((AnchorContainer)shape);
                p = this.moveShape(container, shape, x, y, children);
                x = p.getX();
                y = p.getY();
                y += size.getHeight() + 50;
                if (size.getWidth() <= maxWidth) continue;
                maxWidth = size.getWidth();
            }
            if (y > maxHeight) {
                maxHeight = y;
            }
            x += maxWidth + 50;
            y = 50;
            for (ContainerShape shape : unconnectedShapes) {
                be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)shape);
                if (this.getContainerShapeChildren(shape).size() == 0 && !(be instanceof Lane)) continue;
                size = GraphicsUtil.calculateSize((AnchorContainer)shape);
                p = this.moveShape(container, shape, x, y, children);
                x = p.getX();
                y = p.getY();
                if (be instanceof Lane) {
                    this.resizeContainerShape(shape);
                }
                y += size.getHeight() + 50;
                if (size.getWidth() <= maxWidth) continue;
                maxWidth = size.getWidth();
            }
        }
    }

    private boolean moveShape(ContainerShape container, ContainerShape shape, int x, int y) {
        MoveShapeContext context = new MoveShapeContext((Shape)shape);
        context.setLocation(x, y);
        context.setSourceContainer(container);
        context.setTargetContainer(container);
        IMoveShapeFeature moveFeature = this.editor.getDiagramTypeProvider().getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)context);
        if (moveFeature.canMoveShape((IMoveShapeContext)context)) {
            moveFeature.moveShape((IMoveShapeContext)context);
            return true;
        }
        return false;
    }

    private Point moveShape(ContainerShape container, ContainerShape child, int x, int y, List<ContainerShape> allChildren) {
        boolean intersects;
        do {
            intersects = false;
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)child);
            if (be instanceof BoundaryEvent) {
                Activity activity = ((BoundaryEvent)be).getAttachedToRef();
                ContainerShape activityShape = null;
                for (ContainerShape s : allChildren) {
                    if (s == child || activity != BusinessObjectUtil.getFirstBaseElement((PictogramElement)s)) continue;
                    activityShape = s;
                    break;
                }
                if (activityShape != null) {
                    Graphiti.getPeLayoutService().getLocationRelativeToDiagram(activityShape);
                    IDimension activitySize = GraphicsUtil.calculateSize(activityShape);
                    IDimension eventSize = GraphicsUtil.calculateSize((AnchorContainer)child);
                    int index = activity.getBoundaryEventRefs().indexOf(be);
                    int count = activity.getBoundaryEventRefs().size();
                    int deltaX = activitySize.getWidth() / 2;
                    if (count > 1) {
                        deltaX = index * activitySize.getWidth() / (count - 1);
                    }
                    this.moveShape(activityShape, child, deltaX - eventSize.getWidth() / 2, activitySize.getHeight() - eventSize.getHeight() / 2);
                    y = 0;
                    break;
                }
            } else if (!this.moveShape(container, child, x, y)) break;
            for (ContainerShape c : allChildren) {
                if (c == child || !GraphicsUtil.intersects((Shape)child, (Shape)c)) continue;
                intersects = true;
                y += 50;
            }
        } while (intersects);
        return Graphiti.getCreateService().createPoint(x, y);
    }

    private boolean resizeContainerShape(ContainerShape container) {
        List<ContainerShape> children = this.getContainerShapeChildren(container);
        ILocation containerLocation = layoutService.getLocationRelativeToDiagram((Shape)container);
        int width = 0;
        int height = 0;
        for (ContainerShape child : children) {
            if (BusinessObjectUtil.getFirstBaseElement((PictogramElement)child) == null) continue;
            IDimension size = GraphicsUtil.calculateSize((AnchorContainer)child);
            ILocation location = layoutService.getLocationRelativeToDiagram((Shape)child);
            int x = location.getX() - containerLocation.getX();
            int y = location.getY() - containerLocation.getY();
            int w = x + size.getWidth();
            int h = y + size.getHeight();
            if (w > width) {
                width = w;
            }
            if (h <= height) continue;
            height = h;
        }
        if (BusinessObjectUtil.getFirstBaseElement((PictogramElement)container) instanceof Lane) {
            if (width < 800) {
                width = 800;
            }
            if (height < 100) {
                height = 100;
            }
        }
        if (width != 0 && height != 0) {
            return this.resizeShape(container, width + 50, height + 50);
        }
        return false;
    }

    private boolean resizeShape(ContainerShape container, int width, int height) {
        ResizeShapeContext context = new ResizeShapeContext((Shape)container);
        int x = container.getGraphicsAlgorithm().getX();
        int y = container.getGraphicsAlgorithm().getY();
        context.setLocation(x, y);
        context.setSize(width, height);
        IResizeShapeFeature resizeFeature = this.editor.getDiagramTypeProvider().getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)context);
        if (resizeFeature.canResizeShape((IResizeShapeContext)context)) {
            resizeFeature.resizeShape((IResizeShapeContext)context);
            return true;
        }
        return false;
    }

    private boolean threadContains(List<ContainerShape[]> thread, ContainerShape shape) {
        Iterator<ContainerShape[]> iterator = thread.iterator();
        while (iterator.hasNext()) {
            ContainerShape[] shapes;
            ContainerShape[] containerShapeArray = shapes = iterator.next();
            int n = shapes.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerShape s = containerShapeArray[n2];
                if (s == shape) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void buildThread(ContainerShape shape, List<ContainerShape> childShapes, List<ContainerShape[]> thread) {
        ArrayList<ContainerShape> bin = new ArrayList<ContainerShape>();
        List<SequenceFlow> flows = this.getOutgoingSequenceFlows(shape);
        for (SequenceFlow flow : flows) {
            FlowNode target = flow.getTargetRef();
            ContainerShape targetShape = this.getContainerShape((BaseElement)target);
            if (!childShapes.contains(targetShape) || this.threadContains(thread, targetShape)) continue;
            bin.add(targetShape);
        }
        if (!bin.isEmpty()) {
            thread.add(bin.toArray(new ContainerShape[bin.size()]));
            for (ContainerShape nextShape : bin) {
                this.buildThread(nextShape, childShapes, thread);
            }
        }
    }

    private List<SequenceFlow> getIncomingSequenceFlows(ContainerShape shape) {
        ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                if (!(be instanceof SequenceFlow)) continue;
                flows.add((SequenceFlow)be);
            }
        }
        return flows;
    }

    private List<SequenceFlow> getOutgoingSequenceFlows(ContainerShape shape) {
        ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getOutgoingConnections()) {
                BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                if (!(be instanceof SequenceFlow)) continue;
                flows.add((SequenceFlow)be);
            }
        }
        return flows;
    }

    private ContainerShape getContainerShape(BaseElement be) {
        Diagram diagram = null;
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram(be, true);
        if (bpmnDiagram != null && (diagram = DIUtils.findDiagram((IDiagramBehavior)this.editor.getDiagramBehavior(), bpmnDiagram)) == null) {
            System.out.println("Diagram is null");
        }
        if (diagram != null) {
            List list = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)be);
            for (PictogramElement pe : list) {
                if (!this.isChildShape(pe) || BusinessObjectUtil.getFirstBaseElement(pe) != be) continue;
                return (ContainerShape)pe;
            }
            if (bpmnDiagram.getPlane().getBpmnElement() == be) {
                return diagram;
            }
        }
        System.out.println("Container is null!");
        return null;
    }

    private List<ContainerShape> getContainerShapeChildren(ContainerShape container) {
        ArrayList<ContainerShape> childShapes = new ArrayList<ContainerShape>();
        for (PictogramElement pe : container.getChildren()) {
            if (!this.isChildShape(pe)) continue;
            childShapes.add((ContainerShape)pe);
        }
        return childShapes;
    }

    private boolean isChildShape(PictogramElement pe) {
        return pe instanceof ContainerShape && !FeatureSupport.isLabelShape((Shape)pe);
    }
}

