/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.INamespaceMap;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.DiagramEditorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.Messages;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;

public class ModelUtil {
    public static HashMap<Object, Hashtable<String, EObject>> ids = new HashMap();
    public static HashMap<String, Integer> defaultIds = new HashMap();

    public static void clearIDs(Resource res, boolean all) {
        ids.remove(ModelUtil.getKey(res));
        if (all) {
            defaultIds.clear();
        }
    }

    private static String getObjectName(EObject obj) {
        String name;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("bpmnElement");
        if (feature != null && obj.eGet(feature) != null) {
            EObject bpmnElement = (EObject)obj.eGet(feature);
            name = String.valueOf(obj.eClass().getName()) + "_" + bpmnElement.eClass().getName();
        } else {
            name = obj.eClass().getName();
        }
        return name;
    }

    private static Object getKey(EObject obj) {
        Resource resource = ModelUtil.getResource(obj);
        if (resource == null) {
            return null;
        }
        Assert.isTrue((obj != null ? 1 : 0) != 0);
        return ModelUtil.getKey(resource);
    }

    private static Object getKey(Resource res) {
        Assert.isTrue((res != null ? 1 : 0) != 0);
        return res.getResourceSet();
    }

    private static String generateDefaultID(EObject obj, String name) {
        Integer value;
        if (name == null) {
            name = ModelUtil.getObjectName(obj);
        }
        if ((value = defaultIds.get(name)) == null) {
            value = 1;
        }
        value = value + 1;
        defaultIds.put(name, (int)value);
        return "_" + name + "_" + value;
    }

    private static String generateID(EObject obj, Resource res) {
        return ModelUtil.generateID(obj, res, null);
    }

    public static String generateID(EObject obj, Resource res, String name) {
        Object key;
        Object object = key = res == null ? ModelUtil.getKey(obj) : ModelUtil.getKey(res);
        if (key != null) {
            Hashtable<String, Object> tab = ids.get(key);
            if (tab == null) {
                tab = new Hashtable();
                ids.put(key, tab);
            }
            String id = name;
            if (name == null) {
                name = ModelUtil.getObjectName(obj);
                id = String.valueOf(name) + "_" + 1;
            }
            int i = 1;
            while (true) {
                if (tab.get(id) == null) {
                    tab.put(id, obj);
                    return id;
                }
                id = String.valueOf(name) + "_" + i;
                ++i;
            }
        }
        return ModelUtil.generateDefaultID(obj, name);
    }

    public static void unsetID(EObject obj, Resource resource) {
        Object value;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null && (value = obj.eGet(feature)) instanceof String) {
            Hashtable<String, EObject> tab;
            String id = (String)value;
            Object key = ModelUtil.getKey(resource);
            if (key != null && (tab = ids.get(key)) != null) {
                tab.remove(id);
            }
        }
    }

    public static void addID(EObject obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null) {
            Object value = obj.eGet(feature);
            if (value != null) {
                ModelUtil.addID(obj, (String)value);
            } else {
                ModelUtil.setID(obj);
            }
        }
    }

    public static void addID(EObject obj, String id) {
        Object key = ModelUtil.getKey(obj);
        String name = ModelUtil.getObjectName(obj);
        if (key == null || id.startsWith("_" + name + "_")) {
            Integer oldValue;
            int newValue = 0;
            try {
                int i = id.lastIndexOf(95) + 1;
                if (i < id.length()) {
                    newValue = Integer.parseInt(id.substring(i));
                }
            }
            catch (Exception exception) {}
            if ((oldValue = defaultIds.get(name)) == null || newValue > oldValue) {
                defaultIds.put(name, newValue);
            }
        } else {
            Hashtable<String, Object> tab = ids.get(key);
            if (tab == null) {
                tab = new Hashtable();
                ids.put(key, tab);
            }
            tab.put(id, obj);
        }
    }

    public static String setID(EObject obj) {
        return ModelUtil.setID(obj, ModelUtil.getResource(obj));
    }

    public static String setID(EObject obj, Resource res) {
        String id = null;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null && obj.eGet(feature) == null) {
            id = ModelUtil.generateID(obj, res);
            obj.eSet(feature, (Object)id);
        }
        return id;
    }

    public static String getID(EObject obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null) {
            return (String)obj.eGet(feature);
        }
        return null;
    }

    public static String generateUndefinedID(String base) {
        String name = "undefined";
        if (base.contains("_")) {
            return "<" + name + "_" + base.replaceFirst(".*_", "") + ">";
        }
        Integer value = defaultIds.get(name);
        if (value == null) {
            value = 1;
        }
        value = value + 1;
        defaultIds.put(name, (int)value);
        return "<" + name + "_" + value + ">";
    }

    public static int getIDNumber(String id) {
        try {
            int i = id.lastIndexOf("_");
            return Integer.parseInt(id.substring(i + 1));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String getName(BaseElement element) {
        if (element != null) {
            EStructuralFeature feature = element.eClass().getEStructuralFeature("name");
            if (feature == null) {
                feature = ModelUtil.getAnyAttribute((EObject)element, "name");
            }
            if (feature != null && element.eGet(feature) instanceof String) {
                return (String)element.eGet(feature);
            }
        }
        return null;
    }

    public static boolean hasName(BaseElement obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("name");
        if (feature == null) {
            feature = ModelUtil.getAnyAttribute((EObject)obj, "name");
        }
        return feature != null;
    }

    public static String toDisplayName(String anyName) {
        anyName = anyName.replaceAll("Impl$", "");
        String displayName = "";
        boolean first = true;
        char[] chars = anyName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isUpperCase(c) && displayName.length() > 0 && i + 1 < chars.length && !Character.isUpperCase(chars[i + 1])) {
                displayName = String.valueOf(displayName) + " ";
            }
            if (first) {
                c = Character.toUpperCase(c);
                first = false;
            }
            if (c == '_') {
                c = ' ';
            }
            displayName = String.valueOf(displayName) + c;
            ++i;
        }
        return displayName.trim();
    }

    public static List<EventDefinition> getEventDefinitions(Event event) {
        EStructuralFeature feature;
        if (event != null && (feature = event.eClass().getEStructuralFeature("eventDefinitions")) != null) {
            return (List)event.eGet(feature);
        }
        return new ArrayList<EventDefinition>();
    }

    public static boolean hasEventDefinition(Event event, Class<?> clazz) {
        for (EventDefinition def : ModelUtil.getEventDefinitions(event)) {
            if (!clazz.isInstance(def)) continue;
            return true;
        }
        return false;
    }

    public static EventDefinition getEventDefinition(Event event, Class<?> clazz) {
        for (EventDefinition def : ModelUtil.getEventDefinitions(event)) {
            if (!clazz.isInstance(def)) continue;
            return def;
        }
        return null;
    }

    public static Bpmn2ModelerResourceSetImpl slightlyHackedResourceSet(ResourceSet resourceSet) {
        if (resourceSet instanceof Bpmn2ModelerResourceSetImpl) {
            return (Bpmn2ModelerResourceSetImpl)resourceSet;
        }
        Map map = resourceSet.getLoadOptions();
        Bpmn2ModelerResourceSetImpl result = (Bpmn2ModelerResourceSetImpl)((Object)map.get("slightly.hacked.resource.set"));
        if (result == null) {
            result = new Bpmn2ModelerResourceSetImpl();
            map.put("slightly.hacked.resource.set", result);
        }
        return result;
    }

    public static Bpmn2ModelerResourceSetImpl slightlyHackedResourceSet(EObject eObj) {
        return ModelUtil.slightlyHackedResourceSet(eObj.eResource().getResourceSet());
    }

    public static Object resolveXSDObject(Object xsdObject) {
        XSDAttributeDeclaration resolvedAttribute;
        if (xsdObject instanceof XSDElementDeclaration) {
            XSDElementDeclaration resolvedElement = ((XSDElementDeclaration)xsdObject).getResolvedElementDeclaration();
            if (resolvedElement != null) {
                xsdObject = resolvedElement;
            }
        } else if (xsdObject instanceof XSDAttributeDeclaration && (resolvedAttribute = ((XSDAttributeDeclaration)xsdObject).getResolvedAttributeDeclaration()) != null) {
            xsdObject = resolvedAttribute;
        }
        return xsdObject;
    }

    public static INamespaceMap<String, String> getNamespaceMap(EObject eObject) {
        if (eObject == null) {
            throw new NullPointerException("eObject cannot be null in getNamespaceMap()");
        }
        INamespaceMap nsMap = null;
        while (nsMap == null && eObject != null) {
            nsMap = AdapterRegistry.INSTANCE.adapt((Object)eObject, INamespaceMap.class);
            if (nsMap != null) continue;
            eObject = eObject.eContainer();
        }
        if (nsMap == null) {
            throw new IllegalStateException("INamespaceMap cannot be attached to an eObject");
        }
        return nsMap;
    }

    public static String getNamespacePrefix(EObject eObject, String namespace) {
        EObject context = eObject;
        while (context != null) {
            List<String> pfxList = ModelUtil.getNamespaceMap(context).getReverse(namespace);
            if (pfxList.size() > 0) {
                return pfxList.get(0);
            }
            context = context.eContainer();
        }
        return null;
    }

    public static Bpmn2DiagramType getDiagramType(String name) {
        Bpmn2DiagramType[] bpmn2DiagramTypeArray = Bpmn2DiagramType.values();
        int n = bpmn2DiagramTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bpmn2DiagramType t = bpmn2DiagramTypeArray[n2];
            if (t.toString().equalsIgnoreCase(name)) {
                return t;
            }
            ++n2;
        }
        return Bpmn2DiagramType.NONE;
    }

    public static DiagramEditor getDiagramEditor(EObject object) {
        return ModelUtil.getDiagramEditor(ModelUtil.getResource(object));
    }

    public static DiagramEditor getDiagramEditor(Resource res) {
        if (res != null) {
            for (Adapter a : res.getResourceSet().eAdapters()) {
                if (!(a instanceof DiagramEditorAdapter)) continue;
                return ((DiagramEditorAdapter)a).getDiagramEditor();
            }
        }
        return null;
    }

    public static Bpmn2DiagramType getDiagramType(EObject object) {
        if (object instanceof Diagram) {
            object = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)((Diagram)object));
        }
        if (object instanceof BPMNDiagram) {
            return ModelUtil.getDiagramType((BPMNDiagram)object);
        }
        DiagramEditor editor = ModelUtil.getDiagramEditor(object);
        return ModelUtil.getDiagramType(editor);
    }

    public static Bpmn2DiagramType getDiagramType(DiagramEditor editor) {
        EObject object;
        Diagram diagram;
        if (editor != null && (diagram = editor.getDiagramTypeProvider().getDiagram()) != null && (object = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram)) instanceof BPMNDiagram) {
            return ModelUtil.getDiagramType((BPMNDiagram)object);
        }
        return Bpmn2DiagramType.NONE;
    }

    public static Bpmn2DiagramType getDiagramType(BPMNDiagram diagram) {
        BPMNPlane plane;
        if (diagram != null && ModelUtil.getResource((EObject)diagram) != null && (plane = diagram.getPlane()) != null) {
            BaseElement be = plane.getBpmnElement();
            if (be == null) {
                be = ModelUtil.getDefaultBPMNPlaneReference((EObject)diagram);
            }
            if (be instanceof Choreography) {
                return Bpmn2DiagramType.CHOREOGRAPHY;
            }
            if (be instanceof Collaboration) {
                return Bpmn2DiagramType.COLLABORATION;
            }
            return Bpmn2DiagramType.PROCESS;
        }
        return Bpmn2DiagramType.NONE;
    }

    public static BaseElement getDefaultBPMNPlaneReference(EObject object) {
        Definitions definitions = ModelUtil.getDefinitions(object);
        if (definitions != null) {
            for (RootElement re : definitions.getRootElements()) {
                if (!(re instanceof Process) && !(re instanceof SubProcess) && !(re instanceof AdHocSubProcess) && !(re instanceof Transaction) && !(re instanceof Collaboration) && !(re instanceof Choreography) && !(re instanceof SubChoreography)) continue;
                return re;
            }
        }
        return null;
    }

    public static String getDiagramTypeName(BPMNDiagram object) {
        Bpmn2DiagramType type = ModelUtil.getDiagramType(object);
        if (type == Bpmn2DiagramType.CHOREOGRAPHY) {
            return Messages.ModelUtil_Choreograpy_Diagram;
        }
        if (type == Bpmn2DiagramType.COLLABORATION) {
            return Messages.ModelUtil_Collaboration_Diagram;
        }
        if (type == Bpmn2DiagramType.PROCESS) {
            return Messages.ModelUtil_Process_Diagram;
        }
        return Messages.ModelUtil_Unknown_Diagram_Type;
    }

    public static List<EStructuralFeature> getAnyAttributes(EObject object) {
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
        EStructuralFeature anyAttribute = object.eClass().getEStructuralFeature("anyAttribute");
        if (anyAttribute != null && object.eGet(anyAttribute) instanceof BasicFeatureMap) {
            BasicFeatureMap map = (BasicFeatureMap)object.eGet(anyAttribute);
            for (FeatureMap.Entry entry : map) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                list.add(feature);
            }
        }
        return list;
    }

    public static EStructuralFeature getAnyAttribute(EObject object, String name) {
        EStructuralFeature anyAttribute = object.eClass().getEStructuralFeature("anyAttribute");
        if (anyAttribute != null && object.eGet(anyAttribute) instanceof BasicFeatureMap) {
            BasicFeatureMap map = (BasicFeatureMap)object.eGet(anyAttribute);
            for (FeatureMap.Entry entry : map) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                if (!feature.getName().equals(name)) continue;
                return feature;
            }
        }
        return null;
    }

    public static EStructuralFeature addAnyAttribute(EObject childObject, String name, String type, Object value) {
        EPackage pkg = childObject.eClass().getEPackage();
        String nsURI = pkg.getNsURI();
        return ModelUtil.addAnyAttribute(childObject, nsURI, name, type, value);
    }

    public static EStructuralFeature addAnyAttribute(EObject childObject, String namespace, String name, String type, Object value) {
        EDataType eDataType;
        EStructuralFeature attr = null;
        EClass eclass = null;
        if (childObject instanceof EClass) {
            eclass = (EClass)childObject;
            childObject = ExtendedPropertiesAdapter.getDummyObject(eclass);
        } else {
            eclass = childObject.eClass();
        }
        EStructuralFeature anyAttribute = eclass.getEStructuralFeature(4);
        List anyMap = (List)childObject.eGet(anyAttribute);
        if (anyMap == null) {
            return null;
        }
        for (FeatureMap.Entry fe : anyMap) {
            EAttributeImpl a;
            if (!(fe.getEStructuralFeature() instanceof EAttributeImpl) || !namespace.equals((a = (EAttributeImpl)fe.getEStructuralFeature()).getExtendedMetaData().getNamespace()) || !name.equals(a.getName())) continue;
            attr = a;
            break;
        }
        if (type == null) {
            type = "E" + value.getClass().getSimpleName();
        }
        if ((eDataType = (EDataType)ModelUtil.getEClassifierFromString(null, type)) != null) {
            if (attr == null) {
                attr = ExtendedMetaData.INSTANCE.demandFeature(namespace, name, false);
                attr.setEType((EClassifier)eDataType);
                anyMap.add(FeatureMapUtil.createEntry((EStructuralFeature)attr, (Object)value));
            } else {
                EClassifier dt = attr.getEType();
                if (dt == null || !eDataType.getInstanceClass().isAssignableFrom(dt.getInstanceClass())) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.ModelUtil_Illegal_Value, (Object[])new Object[]{childObject.eClass().getName(), attr.getName(), attr.getEType().getName(), value.toString()}));
                }
                anyMap.add(FeatureMapUtil.createEntry((EStructuralFeature)attr, (Object)value));
            }
        } else if (attr == null) {
            attr = ExtendedMetaData.INSTANCE.demandFeature(namespace, name, false);
            anyMap.add(FeatureMapUtil.createEntry((EStructuralFeature)attr, (Object)value));
        } else {
            anyMap.add(FeatureMapUtil.createEntry(attr, (Object)value));
        }
        return attr;
    }

    public static boolean isBpmnPackage(EPackage pkg) {
        return pkg == Bpmn2Package.eINSTANCE || pkg == BpmnDiPackage.eINSTANCE || pkg == DcPackage.eINSTANCE || pkg == DiPackage.eINSTANCE;
    }

    public static EAttribute createDynamicAttribute(EPackage pkg, EObject object, String name, String type) {
        if (ModelUtil.isBpmnPackage(pkg)) {
            String namespace = TargetRuntime.getDefaultRuntime().getRuntimeExtension().getTargetNamespace(Bpmn2DiagramType.NONE);
            EStructuralFeature feature = ModelUtil.addAnyAttribute(object, namespace, name, type, null);
            if (feature instanceof EAttribute) {
                return (EAttribute)feature;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.ModelUtil_Illegal_EPackage_For_Attribute, (Object)pkg.getName()));
        }
        EClass eClass = object instanceof EClass ? (EClass)object : object.eClass();
        EAttribute attr = null;
        EClass docRoot = (EClass)pkg.getEClassifier("DocumentRoot");
        if (docRoot == null) {
            ExtendedMetaData.INSTANCE.demandPackage(pkg.getNsURI());
            docRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(pkg);
        }
        if (docRoot != null) {
            for (EStructuralFeature f : docRoot.getEStructuralFeatures()) {
                if (!f.getName().equals(name)) continue;
                if (f instanceof EAttribute) {
                    attr = (EAttribute)f;
                    break;
                }
                return null;
            }
        }
        if (type == null) {
            type = "EString";
        }
        EClassifier eClassifier = null;
        if (!(type == null || (eClassifier = ModelUtil.getEClassifierFromString(pkg, type)) != null && eClassifier instanceof EDataType)) {
            String message = NLS.bind((String)Messages.ModelUtil_Unknown_Attribute_Data_Type, (Object[])new Object[]{name, eClass.getName(), type});
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ModelUtil_Internal_Error, (String)message);
            throw new IllegalArgumentException(message);
        }
        if (attr == null) {
            attr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
            attr.setName(name);
            attr.setEType(eClassifier);
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)attr, 2);
            docRoot.getEStructuralFeatures().add((Object)attr);
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)attr, pkg.getNsURI());
            ExtendedMetaData.INSTANCE.setDocumentRoot(docRoot);
        } else if (eClassifier != null) {
            attr.setEType(eClassifier);
        }
        attr.setUnsettable(true);
        return attr;
    }

    public static EReference createDynamicReference(EPackage pkg, EObject object, String name, String type) {
        if (ModelUtil.isBpmnPackage(pkg)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ModelUtil_Illegal_EPackage_For_Reference, (Object)pkg.getName()));
        }
        EClass eClass = object instanceof EClass ? (EClass)object : object.eClass();
        EReference ref = null;
        EClass docRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(pkg);
        if (docRoot == null) {
            EClassifier e;
            ExtendedMetaData.INSTANCE.demandPackage(pkg.getNsURI());
            docRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(pkg);
            if (docRoot == null && (e = pkg.getEClassifier("DocumentRoot")) instanceof EClass) {
                docRoot = (EClass)e;
            }
        }
        if (docRoot != null) {
            for (EStructuralFeature f : docRoot.getEStructuralFeatures()) {
                if (!f.getName().equals(name)) continue;
                if (f instanceof EReference) {
                    ref = (EReference)f;
                    break;
                }
                return null;
            }
        }
        EClassifier eClassifier = null;
        if (!(type == null || (eClassifier = ModelUtil.getEClassifierFromString(pkg, type)) != null && eClassifier instanceof EClass)) {
            String message = NLS.bind((String)Messages.ModelUtil_Unknown_Reference_Object_Type, (Object[])new Object[]{name, eClass.getName(), type});
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ModelUtil_Internal_Error, (String)message);
            throw new IllegalArgumentException(message);
        }
        if (ref == null) {
            ref = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
            ref.setName(name);
            ref.setEType(eClassifier);
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)ref, 2);
            docRoot.getEStructuralFeatures().add((Object)ref);
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)ref, pkg.getNsURI());
            ExtendedMetaData.INSTANCE.setDocumentRoot(docRoot);
        } else if (eClassifier != null) {
            ref.setEType(eClassifier);
        }
        return ref;
    }

    public static boolean removeDynamicFeature(EPackage pkg, EObject object, String name) {
        if (ModelUtil.isBpmnPackage(pkg)) {
            throw new IllegalArgumentException("Can not remove dynamic feature from " + pkg.getName());
        }
        EStructuralFeature anyAttribute = object.eClass().getEStructuralFeature("anyAttribute");
        if (anyAttribute != null && object.eGet(anyAttribute) instanceof BasicFeatureMap) {
            BasicFeatureMap map = (BasicFeatureMap)object.eGet(anyAttribute);
            for (FeatureMap.Entry entry : map) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                if (!feature.getName().equals(name)) continue;
                map.remove((Object)entry);
                return true;
            }
        }
        return false;
    }

    public static EClassifier getEClassifierFromString(EPackage pkg, String type) {
        EClassifier eClassifier = null;
        if (type == null) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        if (pkg != null && (eClassifier = pkg.getEClassifier(type)) != null) {
            return eClassifier;
        }
        eClassifier = EcorePackage.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = Bpmn2Package.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = BpmnDiPackage.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        return null;
    }

    public static EObject createStringWrapper(String value) {
        DynamicEObjectImpl de = new DynamicEObjectImpl(){

            public boolean eIsProxy() {
                return false;
            }

            public boolean equals(Object object) {
                if (object instanceof DynamicEObjectImpl) {
                    DynamicEObjectImpl that = (DynamicEObjectImpl)object;
                    if (this.eProxyURI() == null) {
                        return that.eProxyURI() == null;
                    }
                    String thisString = this.eProxyURI().toString();
                    String thatString = that.eProxyURI() == null ? null : that.eProxyURI().toString();
                    return thisString.equals(thatString);
                }
                if (object instanceof String) {
                    String thisString = this.eProxyURI().toString();
                    return thisString.equals(object);
                }
                return super.equals(object);
            }
        };
        de.eSetClass(EcorePackage.eINSTANCE.getEObject());
        de.eSetProxyURI(URI.createURI((String)value));
        return de;
    }

    public static String getStringWrapperValue(Object wrapper) {
        if (wrapper instanceof DynamicEObjectImpl) {
            DynamicEObjectImpl de = (DynamicEObjectImpl)wrapper;
            URI uri = de.eProxyURI();
            return uri.toString();
        }
        if (wrapper instanceof EObject) {
            return EcoreUtil.getURI((EObject)((EObject)wrapper)).toString();
        }
        return null;
    }

    public static boolean setStringWrapperValue(Object wrapper, String value) {
        if (ModelUtil.isStringWrapper(wrapper)) {
            DynamicEObjectImpl de = (DynamicEObjectImpl)wrapper;
            de.eSetProxyURI(URI.createURI((String)value));
            return true;
        }
        return false;
    }

    public static boolean isStringWrapper(Object wrapper) {
        return wrapper instanceof DynamicEObjectImpl;
    }

    public static boolean isElementSelected(IDiagramContainer editor, PictogramElement element) {
        PictogramElement[] pictogramElementArray = editor.getSelectedPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement search = pictogramElementArray[n2];
            if (search.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Resource getResource(EObject object) {
        Resource resource = null;
        if (object != null) {
            InsertionAdapter insertionAdapter;
            ResourceSet rs;
            resource = object.eResource();
            if (resource != null && (rs = resource.getResourceSet()) != null) {
                for (Resource r : rs.getResources()) {
                    if (!(r instanceof Bpmn2Resource)) continue;
                    return r;
                }
            }
            if (resource == null && (insertionAdapter = AdapterUtil.adapt((Object)object, InsertionAdapter.class)) != null) {
                resource = insertionAdapter.getResource();
            }
        }
        return resource;
    }

    public static Resource getResource(DiagramEditor editor) {
        if (editor != null) {
            return ModelUtil.getResource((EObject)editor.getDiagramTypeProvider().getDiagram());
        }
        return null;
    }

    public static EObject getContainer(EObject object) {
        InsertionAdapter insertionAdapter;
        EObject container = null;
        if (object != null && (container = object.eContainer()) == null && (insertionAdapter = AdapterUtil.adapt((Object)object, InsertionAdapter.class)) != null) {
            container = insertionAdapter.getObject();
        }
        return container;
    }

    public static Definitions getDefinitions(EObject object) {
        Resource resource = ModelUtil.getResource(object);
        return ModelUtil.getDefinitions(resource);
    }

    public static Definitions getDefinitions(Resource resource) {
        Object defs;
        if (resource != null && !resource.getContents().isEmpty() && !((EObject)resource.getContents().get(0)).eContents().isEmpty() && (defs = ((EObject)resource.getContents().get(0)).eContents().get(0)) instanceof Definitions) {
            return (Definitions)defs;
        }
        return null;
    }

    public static DocumentRoot getDocumentRoot(EObject object) {
        EList contents;
        Resource resource = ModelUtil.getResource(object);
        if (resource != null && !(contents = resource.getContents()).isEmpty() && contents.get(0) instanceof DocumentRoot) {
            return (DocumentRoot)contents.get(0);
        }
        return null;
    }

    public static List<EObject> getAllReachableObjects(EObject object, EStructuralFeature feature) {
        EClass eClass;
        Resource resource;
        ArrayList<EObject> list = null;
        if (object != null && feature.getEType() instanceof EClass && (resource = ModelUtil.getResource(object)) != null && (eClass = (EClass)feature.getEType()) != EcorePackage.eINSTANCE.getEObject()) {
            list = new ArrayList<EObject>();
            TreeIterator contents = resource.getAllContents();
            while (contents.hasNext()) {
                Object item = contents.next();
                if (!eClass.isInstance(item)) continue;
                list.add((EObject)item);
            }
        }
        return list;
    }

    public static List<EObject> getAllReachableObjects(EObject object, EClass eClass) {
        ArrayList<EObject> list = null;
        Resource resource = ModelUtil.getResource(object);
        if (resource != null) {
            list = new ArrayList<EObject>();
            if (eClass != EcorePackage.eINSTANCE.getEObject()) {
                TreeIterator contents = resource.getAllContents();
                while (contents.hasNext()) {
                    Object item = contents.next();
                    if (!eClass.isInstance(item)) continue;
                    list.add((EObject)item);
                }
            }
        }
        return list;
    }

    public static <T> List<T> getAllRootElements(Definitions definitions, Class<T> class1) {
        ArrayList<RootElement> list = new ArrayList<RootElement>();
        if (definitions != null) {
            for (RootElement re : definitions.getRootElements()) {
                if (!class1.isInstance(re)) continue;
                list.add(re);
            }
        }
        return list;
    }

    public static <T> List<T> getAllObjectsOfType(Resource resource, Class<T> class1) {
        ArrayList<Object> l = new ArrayList<Object>();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            Object t = iter.next();
            if (!class1.isInstance(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static boolean compare(Object v1, Object v2) {
        if (v1 == null ? v2 != null : v2 == null && v1 != null) {
            return false;
        }
        return v1.equals(v2);
    }

    public static EObject findNearestAncestor(EObject object, Class[] types) {
        EObject ancestor = null;
        if (object != null) {
            ancestor = ModelUtil.getContainer(object);
            while (ancestor != null) {
                Class<?> type = ancestor.getClass();
                Class[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class t = classArray[n2];
                    if (t.isAssignableFrom(type)) {
                        return ancestor;
                    }
                    ++n2;
                }
                ancestor = ModelUtil.getContainer(ancestor);
            }
        }
        return ancestor;
    }

    public static List<EObject> collectAncestorObjects(EObject object, String featureName, Class[] ancestorTypes) {
        return ModelUtil.collectAncestorObjects(object, featureName, ancestorTypes, null);
    }

    public static List<EObject> collectAncestorObjects(EObject object, String featureName, Class[] ancestorTypes, Class[] objectTypes) {
        ArrayList<EObject> values = new ArrayList<EObject>();
        EObject ancestor = ModelUtil.findNearestAncestor(object, ancestorTypes);
        while (ancestor != null) {
            EStructuralFeature feature = ancestor.eClass().getEStructuralFeature(featureName);
            if (feature != null && ancestor.eGet(feature) instanceof List) {
                List objects = (List)ancestor.eGet(feature);
                if (objectTypes == null) {
                    values.addAll(objects);
                } else {
                    for (EObject item : objects) {
                        Class[] classArray = objectTypes;
                        int n = objectTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class t = classArray[n2];
                            if (t.isAssignableFrom(item.getClass())) {
                                values.add(item);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ancestor = ModelUtil.findNearestAncestor(ancestor, ancestorTypes);
        }
        return values;
    }

    public static <T> List<T> getAllExtensionAttributeValues(EObject object, Class<T> clazz) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (object != null) {
            EStructuralFeature evf = object.eClass().getEStructuralFeature("extensionValues");
            EList list = (EList)object.eGet(evf);
            for (ExtensionAttributeValue eav : list) {
                FeatureMap fm = eav.getValue();
                for (FeatureMap.Entry e : fm) {
                    if (!clazz.isInstance(e.getValue())) continue;
                    results.add(e.getValue());
                }
            }
        }
        return results;
    }

    public static List<ExtensionAttributeValue> getExtensionAttributeValues(EObject be) {
        BPMNDiagram diagram;
        BaseElement bpmnElement;
        if (be instanceof Participant) {
            Collaboration collab;
            final Participant participant = (Participant)be;
            if (participant.getProcessRef() == null && participant.eContainer() instanceof Collaboration && (collab = (Collaboration)participant.eContainer()).eContainer() instanceof Definitions) {
                final Definitions definitions = ModelUtil.getDefinitions((EObject)collab);
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)definitions.eResource());
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Process process = Bpmn2ModelerFactory.create(Process.class);
                        participant.setProcessRef(process);
                        definitions.getRootElements().add(process);
                        ModelUtil.setID((EObject)process);
                    }
                });
            }
            return participant.getProcessRef().getExtensionValues();
        }
        if (be instanceof BPMNDiagram && (bpmnElement = (diagram = (BPMNDiagram)be).getPlane().getBpmnElement()) instanceof Process) {
            return bpmnElement.getExtensionValues();
        }
        if (be instanceof BaseElement) {
            return ((BaseElement)be).getExtensionValues();
        }
        return new ArrayList<ExtensionAttributeValue>();
    }

    public static void addExtensionAttributeValue(EObject object, EStructuralFeature feature, Object value) {
        ModelUtil.addExtensionAttributeValue(object, feature, value, false);
    }

    public static void addExtensionAttributeValue(EObject object, EStructuralFeature feature, Object value, boolean delay) {
        EStructuralFeature evf = object.eClass().getEStructuralFeature("extensionValues");
        EList list = (EList)object.eGet(evf);
        if (list.size() == 0) {
            ExtensionAttributeValue newItem = Bpmn2ModelerFactory.create(ExtensionAttributeValue.class);
            ModelUtil.setID((EObject)newItem);
            FeatureMap map = newItem.getValue();
            map.add(feature, value);
            if (delay) {
                InsertionAdapter.add(object, evf, (EObject)newItem, feature, value);
            } else {
                list.add((Object)newItem);
            }
        } else {
            ExtensionAttributeValue oldItem = (ExtensionAttributeValue)list.get(0);
            if (delay) {
                InsertionAdapter.add(object, evf, (EObject)oldItem, feature, value);
            } else {
                FeatureMap map = oldItem.getValue();
                map.add(feature, value);
            }
        }
    }

    public static String getLabel(Object object) {
        EObject eObject;
        ExtendedPropertiesAdapter adapter;
        String label = "";
        label = object instanceof EObject ? ((adapter = ExtendedPropertiesAdapter.adapt(eObject = (EObject)object)) != null ? adapter.getObjectDescriptor().getLabel(eObject) : ModelUtil.toDisplayName(eObject.eClass().getName())) : object.toString();
        label = label.replaceAll(" Ref$", "");
        return label;
    }

    public static void setLabel(EObject object, EStructuralFeature feature, String label) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null) {
            adapter.getFeatureDescriptor(feature).setLabel(label);
        }
    }

    public static String getLabel(EObject object, EStructuralFeature feature) {
        String label = "";
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        label = adapter != null ? adapter.getFeatureDescriptor(feature).getLabel(object) : ModelUtil.toDisplayName(feature.getName());
        label = label.replaceAll(" Ref$", "");
        return label;
    }

    public static String getDisplayName(Object object) {
        if (object instanceof EObject) {
            String text;
            EObject eObject = (EObject)object;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eObject);
            if (adapter != null && (text = adapter.getObjectDescriptor().getDisplayName(eObject)) != null && !text.isEmpty()) {
                return text;
            }
            return ModelUtil.getLongDisplayName(eObject);
        }
        return object == null ? null : object.toString();
    }

    public static String getDisplayName(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return ModelUtil.getDisplayName(object);
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).getDisplayName(object);
        }
        return ModelUtil.getLongDisplayName(object, feature);
    }

    public static boolean setMultiLine(EObject object, EStructuralFeature feature, boolean multiLine) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null) {
            adapter.getFeatureDescriptor(feature).setMultiLine(multiLine);
            return true;
        }
        return false;
    }

    public static boolean isMultiLine(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return false;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).isMultiLine(object);
        }
        return false;
    }

    public static Hashtable<String, Object> getChoiceOfValues(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return null;
        }
        if (feature.getEType() instanceof EEnum) {
            EEnum en = (EEnum)feature.getEType();
            Hashtable<String, Object> choices = new Hashtable<String, Object>();
            for (EEnumLiteral el : en.getELiterals()) {
                choices.put(el.getLiteral(), el.getInstance());
            }
            return choices;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).getChoiceOfValues(object);
        }
        return null;
    }

    public static boolean setValue(TransactionalEditingDomain domain, final EObject object, final EStructuralFeature feature, Object value) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        try {
            InsertionAdapter.executeIfNeeded(object);
            if (value instanceof EObject) {
                InsertionAdapter.executeIfNeeded((EObject)value);
            }
            if (value instanceof String && ((String)value).isEmpty() && !(feature.getDefaultValue() instanceof String)) {
                value = null;
            }
            if (adapter != null) {
                if (!adapter.getFeatureDescriptor(feature).equals(value)) {
                    adapter.getFeatureDescriptor(feature).setValue(value);
                }
            } else if (domain != null) {
                final Object v = value;
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        if (object.eGet(feature) instanceof List) {
                            ((List)object.eGet(feature)).add(v);
                        } else {
                            object.eSet(feature, v);
                        }
                    }
                });
            } else if (object.eGet(feature) instanceof List) {
                ((List)object.eGet(feature)).add(value);
            } else {
                object.eSet(feature, value);
            }
        }
        catch (Exception e) {
            ErrorUtils.showErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    public static Object getValue(EObject object, EStructuralFeature feature) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        Object value = adapter == null ? object.eGet(feature) : adapter.getFeatureDescriptor(feature).getValue();
        return value;
    }

    public static boolean compare(EObject object1, EObject object2, boolean similar) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object1, null);
        if (adapter != null) {
            adapter.getObjectDescriptor();
            return ObjectDescriptor.compare(object1, object2, similar);
        }
        return object1.equals(object2);
    }

    public static boolean canEdit(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.edit")) instanceof Boolean) {
                return (Boolean)result;
            }
            if (feature instanceof EReference) {
                if (((EReference)feature).isContainment()) {
                    return true;
                }
                if (Bpmn2Package.eINSTANCE.getRootElement().isSuperTypeOf((EClass)feature.getEType())) {
                    return true;
                }
                return feature.isMany();
            }
            return true;
        }
        return false;
    }

    public static boolean canCreateNew(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.create.new")) instanceof Boolean) {
                return (Boolean)result;
            }
            if (feature instanceof EReference) {
                if (((EReference)feature).isContainment()) {
                    return true;
                }
                return Bpmn2Package.eINSTANCE.getRootElement().isSuperTypeOf((EClass)feature.getEType());
            }
            return true;
        }
        return false;
    }

    public static boolean canEditInline(EObject object, EStructuralFeature feature) {
        Object result;
        ExtendedPropertiesAdapter adapter;
        if (feature != null && feature.getEType() instanceof EClass && (adapter = ExtendedPropertiesAdapter.adapt(object, feature)) != null && (result = adapter.getProperty(feature, "ui.can.edit.inline")) instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public static boolean canSetNull(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.set.null")) instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        }
        return false;
    }

    public static boolean isMultiChoice(EObject object, EStructuralFeature feature) {
        Object result;
        if (feature == null) {
            return false;
        }
        if (feature.getEType() instanceof EEnum) {
            return true;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object, feature);
        if (adapter != null && (result = adapter.getProperty(feature, "ui.is.multi.choice")) instanceof Boolean) {
            return (Boolean)result;
        }
        return ModelUtil.getChoiceOfValues(object, feature) != null;
    }

    public static String getLongDisplayName(EObject object) {
        Object qName;
        EStructuralFeature feature;
        String objName = null;
        if (object instanceof BPMNDiagram) {
            Bpmn2DiagramType type = ModelUtil.getDiagramType((BPMNDiagram)object);
            if (type == Bpmn2DiagramType.CHOREOGRAPHY) {
                objName = Messages.ModelUtil_Choreography_Diagram;
            } else if (type == Bpmn2DiagramType.COLLABORATION) {
                objName = Messages.ModelUtil_Collaboration_Diagram;
            } else if (type == Bpmn2DiagramType.PROCESS) {
                objName = Messages.ModelUtil_Process_Diagram;
            }
        }
        if (objName == null) {
            objName = ModelUtil.toDisplayName(object.eClass().getName());
        }
        if ((feature = object.eClass().getEStructuralFeature("name")) != null) {
            String name = (String)object.eGet(feature);
            name = name == null || name.isEmpty() ? NLS.bind((String)Messages.ModelUtil_Unnamed_Object, (Object)objName) : String.valueOf(objName) + " \"" + name + "\"";
            return name;
        }
        feature = object.eClass().getEStructuralFeature("id");
        if (feature != null) {
            String id = (String)object.eGet(feature);
            id = id == null || id.isEmpty() ? String.valueOf(Messages.ModelUtil_Unknown_Object) + objName : String.valueOf(objName) + " \"" + id + "\"";
            return id;
        }
        feature = object.eClass().getEStructuralFeature("qName");
        if (feature != null && (qName = object.eGet(feature)) != null) {
            return qName.toString();
        }
        return objName;
    }

    public static String getLongDisplayName(EObject object, EStructuralFeature feature) {
        Object value = object.eGet(feature);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static boolean isEmpty(Object result) {
        if (result == null) {
            return true;
        }
        if (result instanceof String) {
            return ((String)result).isEmpty();
        }
        return false;
    }

    public static void disposeChildWidgets(Composite parent) {
        Control[] kids;
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k instanceof Composite) {
                ModelUtil.disposeChildWidgets((Composite)k);
            }
            k.dispose();
            ++n2;
        }
        kids = parent.getChildren();
    }

    public static void recursivelayout(Composite parent) {
        Control[] kids;
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k.isDisposed()) {
                Activator.logError((Exception)new SWTException("Widget is disposed."));
            }
            if (k instanceof Composite) {
                ModelUtil.recursivelayout((Composite)k);
                ((Composite)k).layout(true);
            }
            ++n2;
        }
        parent.layout(true);
    }

    public static DiagramEditor getEditor(EObject object) {
        Resource resource = InsertionAdapter.getResource(object);
        if (resource != null) {
            return ModelUtil.getEditor(resource.getResourceSet());
        }
        return null;
    }

    public static DiagramEditor getEditor(Resource resource) {
        if (resource != null) {
            return ModelUtil.getEditor(resource.getResourceSet());
        }
        return null;
    }

    public static DiagramEditor getEditor(ResourceSet resourceSet) {
        for (Object next : resourceSet.eAdapters()) {
            if (!(next instanceof DiagramEditorAdapter)) continue;
            return ((DiagramEditorAdapter)next).getDiagramEditor();
        }
        return null;
    }

    public static EPackage getEPackage(EStructuralFeature feature) {
        EStructuralFeature o = feature;
        while (o.eContainer() != null) {
            if (!((o = o.eContainer()) instanceof EPackage)) continue;
            return (EPackage)o;
        }
        return null;
    }

    public static String getExpressionBody(FormalExpression expression) {
        String body = null;
        if (expression.getMixed() != null && !expression.getMixed().isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean isNull = true;
            for (FeatureMap.Entry cur : expression.getMixed()) {
                switch (cur.getEStructuralFeature().getFeatureID()) {
                    case 3: 
                    case 6: {
                        if (cur.getValue() == null) break;
                        isNull = false;
                        result.append(cur.getValue());
                        break;
                    }
                }
            }
            if (!isNull) {
                body = result.toString();
            }
        }
        return body;
    }

    public static List<Tuple<EObject, EObject>> findDuplicateIds(Resource resource) {
        ArrayList<Tuple<EObject, EObject>> list = new ArrayList<Tuple<EObject, EObject>>();
        Definitions definitions = ModelUtil.getDefinitions(resource);
        TreeIterator iter1 = definitions.eAllContents();
        HashSet<EObject> map = new HashSet<EObject>();
        while (iter1.hasNext()) {
            EObject o1 = (EObject)iter1.next();
            EAttribute id1Feature = o1.eClass().getEIDAttribute();
            if (id1Feature == null || map.contains(o1)) continue;
            TreeIterator iter2 = definitions.eAllContents();
            map.add(o1);
            String id1 = (String)o1.eGet((EStructuralFeature)id1Feature);
            while (iter2.hasNext()) {
                EObject o2 = (EObject)iter2.next();
                EAttribute id2Feature = o2.eClass().getEIDAttribute();
                if (id2Feature == null || o1 == o2 || map.contains(o2)) continue;
                String id2 = (String)o2.eGet((EStructuralFeature)id2Feature);
                if (id1 == null || id1.isEmpty() || id2 == null || id2.isEmpty() || !id1.equals(id2)) continue;
                list.add(new Tuple<EObject, EObject>(o1, o2));
            }
        }
        return list;
    }

    public static boolean isParticipantBand(Participant participant) {
        Resource resource = ModelUtil.getResource((EObject)participant);
        for (ChoreographyActivity ca : ModelUtil.getAllObjectsOfType(resource, ChoreographyActivity.class)) {
            if (!ca.getParticipantRefs().contains(participant)) continue;
            return true;
        }
        return false;
    }

    public static enum Bpmn2DiagramType {
        NONE("None"),
        PROCESS("Process"),
        CHOREOGRAPHY("Choreography"),
        COLLABORATION("Collaboration"),
        CONVERSATION("Conversation");

        String value;

        private Bpmn2DiagramType(String value) {
            this.value = value;
        }

        public static Bpmn2DiagramType fromString(String value) {
            if (value != null) {
                Bpmn2DiagramType[] bpmn2DiagramTypeArray = Bpmn2DiagramType.values();
                int n = bpmn2DiagramTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bpmn2DiagramType type = bpmn2DiagramTypeArray[n2];
                    if (value.equalsIgnoreCase(type.value)) {
                        return type;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

