/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CategoryValue;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.CorrelationPropertyRetrievalExpression;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.ImplicitThrowEvent;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.SiblingLaneComparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.MmFactory;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class FeatureSupport {
    public static final String IS_HORIZONTAL_PROPERTY = "isHorizontal";
    public static final String TOOLTIP_PROPERTY = "tooltip";

    public static boolean isValidFlowElementTarget(ITargetContext context) {
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant(context);
        boolean intoFlowElementContainer = FeatureSupport.isTargetFlowElementsContainer(context);
        boolean intoGroup = FeatureSupport.isTargetGroup(context);
        return (intoDiagram || intoLane || intoParticipant || intoFlowElementContainer) && !intoGroup;
    }

    public static boolean isValidArtifactTarget(ITargetContext context) {
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant(context);
        boolean intoSubProcess = FeatureSupport.isTargetSubProcess(context);
        boolean intoSubChoreography = FeatureSupport.isTargetSubChoreography(context);
        boolean intoGroup = FeatureSupport.isTargetGroup(context);
        return (intoDiagram || intoLane || intoParticipant || intoSubProcess || intoSubChoreography) && !intoGroup;
    }

    public static boolean isChoreographyParticipantBand(PictogramElement element) {
        EObject container = element.eContainer();
        if (container instanceof PictogramElement) {
            PictogramElement containerElem = (PictogramElement)container;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(containerElem);
            if (bo instanceof ChoreographyActivity) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDataTarget(ITargetContext context) {
        EObject containerBO = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        boolean intoDiagram = containerBO instanceof BPMNDiagram;
        boolean intoSubProcess = containerBO instanceof FlowElementsContainer;
        if (intoSubProcess || intoDiagram) {
            return true;
        }
        if (FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context)) {
            return true;
        }
        return FeatureSupport.isTargetParticipant(context);
    }

    public static boolean isTargetSubProcess(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), SubProcess.class);
    }

    public static boolean isTargetSubChoreography(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), SubChoreography.class);
    }

    public static boolean isTargetLane(ITargetContext context) {
        return FeatureSupport.isLane((PictogramElement)context.getTargetContainer());
    }

    public static boolean isLane(PictogramElement element) {
        return BusinessObjectUtil.containsElementOfType(element, Lane.class);
    }

    public static Lane getTargetLane(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, Lane.class);
    }

    public static boolean isTargetGroup(ITargetContext context) {
        Group group = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), Group.class);
        return group != null;
    }

    public static boolean isTargetParticipant(ITargetContext context) {
        return FeatureSupport.isParticipant((PictogramElement)context.getTargetContainer()) && !FeatureSupport.isChoreographyParticipantBand((PictogramElement)context.getTargetContainer());
    }

    public static boolean isParticipant(PictogramElement element) {
        return BusinessObjectUtil.containsElementOfType(element, Participant.class);
    }

    public static Participant getTargetParticipant(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, Participant.class);
    }

    public static SubProcess getTargetSubProcess(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, SubProcess.class);
    }

    public static boolean isTargetFlowElementsContainer(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), FlowElementsContainer.class);
    }

    public static FlowElementsContainer getTargetFlowElementsContainer(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, FlowElementsContainer.class);
    }

    public static boolean isLaneOnTop(Lane lane) {
        return lane.getChildLaneSet() == null || lane.getChildLaneSet().getLanes().isEmpty();
    }

    public static boolean isTargetLaneOnTop(ITargetContext context) {
        Lane lane = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), Lane.class);
        return lane.getChildLaneSet() == null || lane.getChildLaneSet().getLanes().isEmpty();
    }

    public static boolean isHorizontal(ContainerShape container) {
        EObject parent = container.eContainer();
        if (parent instanceof PictogramElement && BusinessObjectUtil.getFirstElementOfType((PictogramElement)parent, ChoreographyTask.class) != null) {
            return false;
        }
        String v = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, IS_HORIZONTAL_PROPERTY);
        if (v == null) {
            return Bpmn2Preferences.getInstance((EObject)container).isHorizontalDefault();
        }
        return Boolean.parseBoolean(v);
    }

    public static void setHorizontal(ContainerShape container, boolean isHorizontal) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)container, IS_HORIZONTAL_PROPERTY, Boolean.toString(isHorizontal));
        BPMNShape bs = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
        if (bs != null) {
            bs.setIsHorizontal(isHorizontal);
        }
    }

    public static boolean isHorizontal(IContext context) {
        Object v = context.getProperty((Object)IS_HORIZONTAL_PROPERTY);
        if (v == null) {
            return true;
        }
        return (Boolean)v;
    }

    public static void setHorizontal(IContext context, boolean isHorizontal) {
        context.putProperty((Object)IS_HORIZONTAL_PROPERTY, (Object)isHorizontal);
    }

    public static List<PictogramElement> getContainerChildren(ContainerShape container) {
        ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
        for (PictogramElement pe : container.getChildren()) {
            String value = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "activity-decorator");
            if (value != null && "true".equals(value)) continue;
            list.add(pe);
        }
        return list;
    }

    public static List<PictogramElement> getContainerDecorators(ContainerShape container) {
        ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
        for (PictogramElement pe : container.getChildren()) {
            String value = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "activity-decorator");
            if (value == null || !"true".equals(value)) continue;
            list.add(pe);
        }
        return list;
    }

    public static void setContainerChildrenVisible(ContainerShape container, boolean visible) {
        for (PictogramElement pe : FeatureSupport.getContainerChildren(container)) {
            pe.setVisible(visible);
            if (!(pe instanceof AnchorContainer)) continue;
            AnchorContainer ac = (AnchorContainer)pe;
            for (Anchor a : ac.getAnchors()) {
                for (Connection c : a.getOutgoingConnections()) {
                    c.setVisible(visible);
                    for (ConnectionDecorator decorator : c.getConnectionDecorators()) {
                        decorator.setVisible(visible);
                    }
                }
            }
        }
    }

    @Deprecated
    public static ModelHandler getModelHanderInstance(Diagram diagram) throws IOException {
        return ModelHandlerLocator.getModelHandler(diagram.eResource());
    }

    public static void redraw(ContainerShape container) {
        ContainerShape root = FeatureSupport.getRootContainer(container);
        FeatureSupport.resizeRecursively(root);
        FeatureSupport.postResizeFixLenghts(root);
        FeatureSupport.updateDI(root);
    }

    private static void updateDI(ContainerShape root) {
        Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)root);
        BusinessObjectUtil.getFirstElementOfType((PictogramElement)root, BaseElement.class).eClass().getInstanceClass();
        DIUtils.updateDIShape((PictogramElement)root);
    }

    public static ContainerShape getRootContainer(ContainerShape container) {
        ContainerShape parent = container.getContainer();
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)parent, BaseElement.class);
        if (bo != null && (bo instanceof Lane || bo instanceof Participant)) {
            return FeatureSupport.getRootContainer(parent);
        }
        return container;
    }

    private static Dimension resize(ContainerShape container) {
        BaseElement elem = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BaseElement.class);
        IGaService service = Graphiti.getGaService();
        int height = 0;
        int width = container.getGraphicsAlgorithm().getWidth() - 30;
        boolean horz = FeatureSupport.isHorizontal(container);
        if (horz) {
            height = 0;
            width = container.getGraphicsAlgorithm().getWidth() - 30;
        } else {
            width = 0;
            height = container.getGraphicsAlgorithm().getHeight() - 30;
        }
        EList children = container.getChildren();
        ECollections.sort((EList)children, (Comparator)new SiblingLaneComparator());
        for (Shape s : children) {
            BaseElement bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)s, BaseElement.class);
            if (bo == null || !(bo instanceof Lane) && !(bo instanceof Participant) || bo.equals(elem)) continue;
            GraphicsAlgorithm ga = s.getGraphicsAlgorithm();
            if (horz) {
                service.setLocation(ga, 30, height);
                height += ga.getHeight() - 1;
                if (ga.getWidth() >= width) {
                    width = ga.getWidth();
                    continue;
                }
                service.setSize(ga, width, ga.getHeight());
                continue;
            }
            service.setLocation(ga, width, 30);
            width += ga.getWidth() - 1;
            if (ga.getHeight() >= height) {
                height = ga.getHeight();
                continue;
            }
            service.setSize(ga, ga.getWidth(), height);
        }
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        if (horz) {
            if (height == 0) {
                return new Dimension(ga.getWidth(), ga.getHeight());
            }
            int newWidth = width + 30;
            int newHeight = height + 1;
            service.setSize(ga, newWidth, newHeight);
            for (Shape s : children) {
                GraphicsAlgorithm childGa = s.getGraphicsAlgorithm();
                if (childGa instanceof AbstractText) {
                    AbstractText text = (AbstractText)childGa;
                    text.setAngle(Integer.valueOf(-90));
                    service.setLocationAndSize((GraphicsAlgorithm)text, 5, 0, 15, newHeight);
                    continue;
                }
                if (!(childGa instanceof Polyline)) continue;
                Polyline line = (Polyline)childGa;
                Point p0 = (Point)line.getPoints().get(0);
                Point p1 = (Point)line.getPoints().get(1);
                p0.setX(30);
                p0.setY(0);
                p1.setX(30);
                p1.setY(newHeight);
            }
            return new Dimension(newWidth, newHeight);
        }
        if (width == 0) {
            return new Dimension(ga.getWidth(), ga.getHeight());
        }
        int newWidth = width + 1;
        int newHeight = height + 30;
        service.setSize(ga, newWidth, newHeight);
        for (Shape s : children) {
            GraphicsAlgorithm childGa = s.getGraphicsAlgorithm();
            if (childGa instanceof AbstractText) {
                AbstractText text = (AbstractText)childGa;
                text.setAngle(Integer.valueOf(0));
                service.setLocationAndSize((GraphicsAlgorithm)text, 0, 5, newWidth, 15);
                continue;
            }
            if (!(childGa instanceof Polyline)) continue;
            Polyline line = (Polyline)childGa;
            Point p0 = (Point)line.getPoints().get(0);
            Point p1 = (Point)line.getPoints().get(1);
            p0.setX(0);
            p0.setY(30);
            p1.setX(newWidth);
            p1.setY(30);
        }
        return new Dimension(newWidth, newHeight);
    }

    private static Dimension resizeRecursively(ContainerShape root) {
        BaseElement elem = BusinessObjectUtil.getFirstElementOfType((PictogramElement)root, BaseElement.class);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        IGaService service = Graphiti.getGaService();
        int foundContainers = 0;
        boolean horz = FeatureSupport.isHorizontal(root);
        for (Shape s : root.getChildren()) {
            BaseElement bo;
            if (!FeatureSupport.checkForResize(elem, s, bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)s, BaseElement.class))) continue;
            ++foundContainers;
            Dimension d = FeatureSupport.resizeRecursively((ContainerShape)s);
            if (d == null) continue;
            dimensions.add(d);
        }
        if (dimensions.isEmpty()) {
            GraphicsAlgorithm ga = root.getGraphicsAlgorithm();
            for (Shape s : root.getChildren()) {
                GraphicsAlgorithm childGa = s.getGraphicsAlgorithm();
                if (childGa instanceof AbstractText) {
                    AbstractText text = (AbstractText)childGa;
                    if (horz) {
                        text.setAngle(Integer.valueOf(-90));
                        service.setLocationAndSize((GraphicsAlgorithm)text, 5, 0, 15, ga.getHeight());
                        continue;
                    }
                    text.setAngle(Integer.valueOf(0));
                    service.setLocationAndSize((GraphicsAlgorithm)text, 0, 5, ga.getWidth(), 15);
                    continue;
                }
                if (!(childGa instanceof Polyline)) continue;
                Polyline line = (Polyline)childGa;
                Point p0 = (Point)line.getPoints().get(0);
                Point p1 = (Point)line.getPoints().get(1);
                if (horz) {
                    p0.setX(30);
                    p0.setY(0);
                    p1.setX(30);
                    p1.setY(ga.getHeight());
                    continue;
                }
                p0.setX(0);
                p0.setY(30);
                p1.setX(ga.getWidth());
                p1.setY(30);
            }
            return new Dimension(ga.getWidth(), ga.getHeight());
        }
        if (foundContainers > 0) {
            return FeatureSupport.resize(root);
        }
        return FeatureSupport.getMaxDimension(horz, dimensions);
    }

    private static boolean checkForResize(BaseElement currentBo, Shape s, Object bo) {
        if (!(s instanceof ContainerShape)) {
            return false;
        }
        if (bo == null) {
            return false;
        }
        if (!(bo instanceof Lane) && !(bo instanceof Participant)) {
            return false;
        }
        return !bo.equals(currentBo);
    }

    private static Dimension getMaxDimension(boolean horz, List<Dimension> dimensions) {
        if (dimensions.isEmpty()) {
            return null;
        }
        int height = 0;
        int width = 0;
        if (horz) {
            for (Dimension d : dimensions) {
                height += d.height;
                if (d.width <= width) continue;
                width = d.width;
            }
        } else {
            for (Dimension d : dimensions) {
                width += d.width;
                if (d.height <= height) continue;
                height = d.height;
            }
        }
        return new Dimension(width, height);
    }

    private static void postResizeFixLenghts(ContainerShape root) {
        IGaService service = Graphiti.getGaService();
        BaseElement elem = BusinessObjectUtil.getFirstElementOfType((PictogramElement)root, BaseElement.class);
        GraphicsAlgorithm ga = root.getGraphicsAlgorithm();
        int width = ga.getWidth() - 30;
        int height = ga.getHeight() - 30;
        boolean horz = FeatureSupport.isHorizontal(root);
        for (Shape s : root.getChildren()) {
            BaseElement o;
            if (!FeatureSupport.checkForResize(elem, s, o = BusinessObjectUtil.getFirstElementOfType((PictogramElement)s, BaseElement.class))) continue;
            GraphicsAlgorithm childGa = s.getGraphicsAlgorithm();
            if (horz) {
                service.setSize(childGa, width, childGa.getHeight());
            } else {
                service.setSize(childGa, childGa.getWidth(), height);
            }
            DIUtils.updateDIShape((PictogramElement)s);
            FeatureSupport.postResizeFixLenghts((ContainerShape)s);
        }
        DIUtils.updateDIShape((PictogramElement)root);
    }

    public static String getShapeValue(IPictogramElementContext context) {
        String value = null;
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pe;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                AbstractText text = (AbstractText)shape.getGraphicsAlgorithm();
                value = text.getValue();
            }
        }
        return value;
    }

    public static String getBusinessValue(IPictogramElementContext context) {
        BaseElement o = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
        if (o instanceof FlowElement) {
            FlowElement e = (FlowElement)o;
            return e.getName();
        }
        if (o instanceof TextAnnotation) {
            TextAnnotation a = (TextAnnotation)o;
            return a.getText();
        }
        if (o instanceof Participant) {
            Participant p = (Participant)o;
            return p.getName();
        }
        if (o instanceof Lane) {
            Lane l = (Lane)o;
            return l.getName();
        }
        if (o instanceof Group) {
            Group g = (Group)o;
            if (g.getCategoryValueRef() != null) {
                return ModelUtil.getDisplayName(g.getCategoryValueRef());
            }
            return "";
        }
        return null;
    }

    public static Participant getTargetParticipant(ITargetContext context, ModelHandler handler) {
        if (context.getTargetContainer() instanceof Diagram) {
            return handler.getInternalParticipant();
        }
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), BaseElement.class);
        if (bo instanceof Participant) {
            return (Participant)bo;
        }
        return handler.getParticipant(bo);
    }

    public static Shape getShape(ContainerShape container, String property, String expectedValue) {
        IPeService peService = Graphiti.getPeService();
        for (Shape shape : peService.getAllContainedShapes(container)) {
            String value = peService.getPropertyValue((PropertyContainer)shape, property);
            if (value == null || !value.equals(expectedValue)) continue;
            return shape;
        }
        return null;
    }

    public static <T extends EObject> T getChildElementOfType(PictogramElement container, String property, String expectedValue, Class<T> clazz) {
        IPeService peService = Graphiti.getPeService();
        for (PictogramElement pe : peService.getAllContainedPictogramElements(container)) {
            String value = peService.getPropertyValue((PropertyContainer)pe, property);
            if (value == null || !value.equals(expectedValue) || !clazz.isInstance(pe)) continue;
            return (T)pe;
        }
        return null;
    }

    public static List<PictogramElement> getChildsOfBusinessObjectType(ContainerShape root, Class businessObjectClazz) {
        ArrayList<PictogramElement> result = new ArrayList<PictogramElement>();
        for (Shape currentShape : root.getChildren()) {
            if (!BusinessObjectUtil.containsChildElementOfType((PictogramElement)currentShape, businessObjectClazz)) continue;
            result.add((PictogramElement)currentShape);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static Shape getFirstLaneInContainer(ContainerShape root) {
        block2: {
            block3: {
                laneShapes = FeatureSupport.getChildsOfBusinessObjectType(root, Lane.class);
                if (laneShapes.isEmpty()) break block2;
                iterator = laneShapes.iterator();
                result = iterator.next();
                ga = result.getGraphicsAlgorithm();
                if (!FeatureSupport.isHorizontal(root)) ** GOTO lbl16
                while (iterator.hasNext()) {
                    currentShape = iterator.next();
                    if (currentShape.getGraphicsAlgorithm().getY() >= ga.getY()) continue;
                    result = currentShape;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentShape = iterator.next();
                    if (currentShape.getGraphicsAlgorithm().getX() >= ga.getX()) continue;
                    result = currentShape;
lbl16:
                    // 3 sources

                    ** while (iterator.hasNext())
                }
            }
            return (Shape)result;
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    public static Shape getLastLaneInContainer(ContainerShape root) {
        block2: {
            block3: {
                laneShapes = FeatureSupport.getChildsOfBusinessObjectType(root, Lane.class);
                if (laneShapes.isEmpty()) break block2;
                iterator = laneShapes.iterator();
                result = iterator.next();
                ga = result.getGraphicsAlgorithm();
                if (!FeatureSupport.isHorizontal(root)) ** GOTO lbl16
                while (iterator.hasNext()) {
                    currentShape = iterator.next();
                    if (currentShape.getGraphicsAlgorithm().getY() <= ga.getY()) continue;
                    result = currentShape;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentShape = iterator.next();
                    if (currentShape.getGraphicsAlgorithm().getX() <= ga.getX()) continue;
                    result = currentShape;
lbl16:
                    // 3 sources

                    ** while (iterator.hasNext())
                }
            }
            return (Shape)result;
        }
        return root;
    }

    public static ContainerShape getLaneBefore(ContainerShape container) {
        if (!BusinessObjectUtil.containsElementOfType((PictogramElement)container, Lane.class)) {
            return null;
        }
        ContainerShape parentContainerShape = container.getContainer();
        if (parentContainerShape == null) {
            return null;
        }
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        int x = ga.getX();
        int y = ga.getY();
        boolean isHorizontal = FeatureSupport.isHorizontal(container);
        ContainerShape result = null;
        for (PictogramElement picElem : FeatureSupport.getChildsOfBusinessObjectType(parentContainerShape, Lane.class)) {
            GraphicsAlgorithm resultGA;
            if (!(picElem instanceof ContainerShape) || picElem.equals(container)) continue;
            ContainerShape currentContainerShape = (ContainerShape)picElem;
            GraphicsAlgorithm currentGA = currentContainerShape.getGraphicsAlgorithm();
            if (isHorizontal) {
                if (currentGA.getY() >= y) continue;
                if (result != null) {
                    resultGA = result.getGraphicsAlgorithm();
                    if (resultGA.getY() >= currentGA.getY()) continue;
                    result = currentContainerShape;
                    continue;
                }
                result = currentContainerShape;
                continue;
            }
            if (currentGA.getX() >= x) continue;
            if (result != null) {
                resultGA = result.getGraphicsAlgorithm();
                if (resultGA.getX() >= currentGA.getX()) continue;
                result = currentContainerShape;
                continue;
            }
            result = currentContainerShape;
        }
        return result;
    }

    public static ContainerShape getLaneAfter(ContainerShape container) {
        if (!BusinessObjectUtil.containsElementOfType((PictogramElement)container, Lane.class)) {
            return null;
        }
        ContainerShape parentContainerShape = container.getContainer();
        if (parentContainerShape == null) {
            return null;
        }
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        int x = ga.getX();
        int y = ga.getY();
        boolean isHorizontal = FeatureSupport.isHorizontal(container);
        ContainerShape result = null;
        for (PictogramElement picElem : FeatureSupport.getChildsOfBusinessObjectType(parentContainerShape, Lane.class)) {
            GraphicsAlgorithm resultGA;
            if (!(picElem instanceof ContainerShape) || picElem.equals(container)) continue;
            ContainerShape currentContainerShape = (ContainerShape)picElem;
            GraphicsAlgorithm currentGA = currentContainerShape.getGraphicsAlgorithm();
            if (isHorizontal) {
                if (currentGA.getY() <= y) continue;
                if (result != null) {
                    resultGA = result.getGraphicsAlgorithm();
                    if (resultGA.getY() <= currentGA.getY()) continue;
                    result = currentContainerShape;
                    continue;
                }
                result = currentContainerShape;
                continue;
            }
            if (currentGA.getX() <= x) continue;
            if (result != null) {
                resultGA = result.getGraphicsAlgorithm();
                if (resultGA.getX() <= currentGA.getX()) continue;
                result = currentContainerShape;
                continue;
            }
            result = currentContainerShape;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBpmnDiagram(BaseElement baseElement) {
        CallableElement ce;
        Process process = null;
        if (baseElement instanceof Participant) {
            process = ((Participant)baseElement).getProcessRef();
        } else if (baseElement instanceof CallActivity && (ce = ((CallActivity)baseElement).getCalledElementRef()) instanceof Process) {
            process = (Process)ce;
        }
        if (process != null) {
            baseElement = process;
        }
        try {
            BPMNDiagram d;
            Definitions definitions = ModelUtil.getDefinitions((EObject)baseElement);
            Iterator iterator = definitions.getDiagrams().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((d = (BPMNDiagram)iterator.next()).getPlane().getBpmnElement() != baseElement);
            return true;
        }
        catch (Exception exception) {}
        return false;
    }

    public static List<ContainerShape> findGroupedShapes(ContainerShape groupShape) {
        Diagram diagram = null;
        EObject parent = groupShape.eContainer();
        while (parent != null) {
            if (parent instanceof Diagram) {
                diagram = (Diagram)parent;
                break;
            }
            parent = parent.eContainer();
        }
        ArrayList<ContainerShape> list = new ArrayList<ContainerShape>();
        if (diagram != null && FeatureSupport.isGroupShape((Shape)groupShape)) {
            TreeIterator iter = diagram.eAllContents();
            while (iter.hasNext()) {
                EObject child = (EObject)iter.next();
                if (!(child instanceof ContainerShape) || child == groupShape || list.contains(child)) continue;
                ContainerShape shape = (ContainerShape)child;
                if (FeatureSupport.isGroupShape((Shape)shape)) {
                    if (!GraphicsUtil.contains((Shape)groupShape, (Shape)shape) || list.contains(shape)) continue;
                    list.add(shape);
                    continue;
                }
                if (!GraphicsUtil.contains((Shape)groupShape, (Shape)shape)) continue;
                if (!list.contains(shape)) {
                    list.add(shape);
                }
                while (!(shape.getContainer() instanceof Diagram)) {
                    shape = shape.getContainer();
                }
                if (list.contains(shape)) continue;
                list.add(shape);
            }
        }
        return list;
    }

    public static boolean isGroupShape(Shape shape) {
        return BusinessObjectUtil.getFirstBaseElement((PictogramElement)shape) instanceof Group;
    }

    public static boolean isLabelShape(Shape shape) {
        if (shape == null) {
            return false;
        }
        return Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "label") != null;
    }

    public static List<EObject> findMessageReferences(Diagram diagram, Message message) {
        EObject o;
        ArrayList<EObject> result = new ArrayList<EObject>();
        Definitions definitions = ModelUtil.getDefinitions((EObject)message);
        TreeIterator iter = definitions.eAllContents();
        while (iter.hasNext()) {
            o = (EObject)iter.next();
            if (o instanceof MessageFlow && ((MessageFlow)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof MessageEventDefinition && ((MessageEventDefinition)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof Operation && (((Operation)o).getInMessageRef() == message || ((Operation)o).getOutMessageRef() == message)) {
                result.add(o);
            }
            if (o instanceof ReceiveTask && ((ReceiveTask)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof SendTask && ((SendTask)o).getMessageRef() == message) {
                result.add(o);
            }
            if (!(o instanceof CorrelationPropertyRetrievalExpression) || ((CorrelationPropertyRetrievalExpression)o).getMessageRef() != message) continue;
            result.add(o);
        }
        if (diagram != null) {
            iter = diagram.eResource().getAllContents();
            while (iter.hasNext()) {
                o = (EObject)iter.next();
                if (!(o instanceof ContainerShape) || FeatureSupport.isLabelShape((Shape)((ContainerShape)o)) || BusinessObjectUtil.getFirstBaseElement((PictogramElement)((ContainerShape)o)) != message) continue;
                result.add(o);
            }
        }
        return result;
    }

    public static List<EClass> getAllowedEventDefinitions(Event event) {
        Activity eventOwner = null;
        if (event instanceof BoundaryEvent) {
            eventOwner = ((BoundaryEvent)event).getAttachedToRef();
        } else {
            EObject parent = event.eContainer();
            while (parent != null) {
                if (parent instanceof FlowElementsContainer) {
                    eventOwner = (BaseElement)parent;
                    break;
                }
                parent = parent.eContainer();
            }
        }
        ArrayList<EClass> allowedItems = new ArrayList<EClass>();
        if (event instanceof BoundaryEvent) {
            if (eventOwner instanceof Transaction) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCancelEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof IntermediateCatchEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof StartEvent) {
            if (eventOwner instanceof SubProcess) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
                allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
                allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof EndEvent) {
            if (eventOwner instanceof Transaction) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCancelEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTerminateEventDefinition());
        } else if (event instanceof ImplicitThrowEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
        } else if (event instanceof IntermediateThrowEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
        }
        return allowedItems;
    }

    public static boolean updateConnection(IFeatureProvider fp, Connection connection) {
        boolean layoutChanged = false;
        LayoutContext layoutContext = new LayoutContext((PictogramElement)connection);
        ILayoutFeature layoutFeature = fp.getLayoutFeature((ILayoutContext)layoutContext);
        if (layoutFeature != null) {
            layoutFeature.layout((ILayoutContext)layoutContext);
            layoutChanged = layoutFeature.hasDoneChanges();
        }
        boolean updateChanged = false;
        UpdateContext updateContext = new UpdateContext((PictogramElement)connection);
        IUpdateFeature updateFeature = fp.getUpdateFeature((IUpdateContext)updateContext);
        if (updateFeature != null && updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
            updateFeature.update((IUpdateContext)updateContext);
            updateChanged = updateFeature.hasDoneChanges();
        }
        return layoutChanged || updateChanged;
    }

    public static boolean updateConnection(IFeatureProvider fp, Connection connection, boolean force) {
        AbstractConnectionRouter.setForceRouting(connection, force);
        return FeatureSupport.updateConnection(fp, connection);
    }

    public static void updateConnections(IFeatureProvider fp, AnchorContainer ac, List<Connection> alreadyUpdated) {
        Connection c;
        int ci;
        Anchor a;
        int ai = 0;
        while (ai < ac.getAnchors().size()) {
            a = (Anchor)ac.getAnchors().get(ai);
            ci = 0;
            while (ci < a.getIncomingConnections().size()) {
                c = (Connection)a.getIncomingConnections().get(ci);
                if (c instanceof FreeFormConnection && !alreadyUpdated.contains(c)) {
                    FeatureSupport.updateConnection(fp, c, true);
                    alreadyUpdated.add(c);
                }
                ++ci;
            }
            ++ai;
        }
        ai = 0;
        while (ai < ac.getAnchors().size()) {
            a = (Anchor)ac.getAnchors().get(ai);
            ci = 0;
            while (ci < a.getOutgoingConnections().size()) {
                c = (Connection)a.getOutgoingConnections().get(ci);
                if (c instanceof FreeFormConnection && !alreadyUpdated.contains(c)) {
                    FeatureSupport.updateConnection(fp, c, true);
                    alreadyUpdated.add(c);
                }
                ++ci;
            }
            ++ai;
        }
    }

    public static void updateConnections(IFeatureProvider fp, AnchorContainer ac) {
        ArrayList<Connection> alreadyUpdated = new ArrayList<Connection>();
        if (ac instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)ac).getChildren()) {
                if (!(child instanceof ContainerShape)) continue;
                FeatureSupport.updateConnections(fp, (AnchorContainer)child, alreadyUpdated);
            }
        }
        FeatureSupport.updateConnections(fp, ac, alreadyUpdated);
    }

    public static void updateCategoryValues(IFeatureProvider fp, List<ContainerShape> shapes) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (ContainerShape cs : shapes) {
            FeatureSupport.updateCategoryValues(fp, (PictogramElement)cs);
            for (Anchor a : cs.getAnchors()) {
                for (Connection c : a.getIncomingConnections()) {
                    if (connections.contains(c)) continue;
                    connections.add(c);
                }
                for (Connection c : a.getOutgoingConnections()) {
                    if (connections.contains(c)) continue;
                    connections.add(c);
                }
            }
        }
        for (Connection c : connections) {
            FeatureSupport.updateCategoryValues(fp, (PictogramElement)c);
        }
    }

    public static void updateCategoryValues(IFeatureProvider fp, PictogramElement pe) {
        Resource resource = ModelUtil.getResource((EObject)pe);
        if (Bpmn2Preferences.getInstance(resource).getPropagateGroupCategories()) {
            Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
            FlowElement flowElement = BusinessObjectUtil.getFirstElementOfType(pe, FlowElement.class);
            if (flowElement == null) {
                return;
            }
            flowElement.getCategoryValueRef().clear();
            if (pe instanceof ContainerShape) {
                for (Group group : ModelUtil.getAllObjectsOfType(resource, Group.class)) {
                    CategoryValue cv = group.getCategoryValueRef();
                    if (cv == null) continue;
                    block1: for (PictogramElement groupShape : Graphiti.getLinkService().getPictogramElements(diagram, (EObject)group)) {
                        if (!(groupShape instanceof ContainerShape)) continue;
                        for (ContainerShape flowElementShape : FeatureSupport.findGroupedShapes((ContainerShape)groupShape)) {
                            FlowElement fe = BusinessObjectUtil.getFirstElementOfType((PictogramElement)flowElementShape, FlowElement.class);
                            if (fe != flowElement) continue;
                            fe.getCategoryValueRef().add(cv);
                            continue block1;
                        }
                    }
                }
            } else if (pe instanceof Connection && flowElement instanceof SequenceFlow) {
                SequenceFlow sf = (SequenceFlow)flowElement;
                FlowNode source = sf.getSourceRef();
                FlowNode target = sf.getTargetRef();
                sf.getCategoryValueRef().clear();
                sf.getCategoryValueRef().addAll(source.getCategoryValueRef());
                sf.getCategoryValueRef().addAll(target.getCategoryValueRef());
            }
        }
    }

    public static void setToolTip(GraphicsAlgorithm ga, String text) {
        if (ga != null) {
            Property prop = MmFactory.eINSTANCE.createProperty();
            prop.setKey(TOOLTIP_PROPERTY);
            prop.setValue(text);
            ga.getProperties().add((Object)prop);
        }
    }

    public static String getToolTip(GraphicsAlgorithm ga) {
        if (ga != null) {
            for (Property prop : ga.getProperties()) {
                if (!TOOLTIP_PROPERTY.equals(prop.getKey())) continue;
                return prop.getValue();
            }
        }
        return null;
    }
}

