/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.AbstractPropertyChangeListenerProvider;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.IBpmn2RuntimeExtension;
import org.eclipse.bpmn2.modeler.core.features.activity.task.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2TabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.FeatureContainerDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class TargetRuntime
extends AbstractPropertyChangeListenerProvider {
    public static final String RUNTIME_EXTENSION_ID = "org.eclipse.bpmn2.modeler.runtime";
    public static final String DEFAULT_RUNTIME_ID = "org.eclipse.bpmn2.modeler.runtime.none";
    public static final String BPMN2_MARKER_ID = "org.eclipse.bpmn2.modeler.core.problemMarker";
    protected static TargetRuntime[] targetRuntimes;
    protected static TargetRuntime currentRuntime;
    protected String name;
    protected String[] versions;
    protected String id;
    protected String description;
    private IBpmn2RuntimeExtension runtimeExtension;
    protected ModelDescriptor modelDescriptor;
    protected ArrayList<Bpmn2TabDescriptor> tabDescriptors;
    protected ArrayList<CustomTaskDescriptor> customTasks;
    protected ArrayList<ModelExtensionDescriptor> modelExtensions;
    protected ArrayList<ModelEnablementDescriptor> modelEnablements;
    protected ModelEnablementDescriptor defaultModelEnablements;
    protected ArrayList<PropertyExtensionDescriptor> propertyExtensions;
    protected ArrayList<FeatureContainerDescriptor> featureContainers;
    protected ArrayList<ToolPaletteDescriptor> toolPalettes;
    protected HashMap<Class, ShapeStyle> shapeStyles;
    protected Bpmn2Resource bpmnResource;
    protected String problemMarkerId;

    public TargetRuntime(String id, String name, String versions, String description) {
        this.id = id;
        this.name = name;
        if (versions != null) {
            this.versions = versions.split("[, ]");
        }
        this.description = description;
    }

    public static TargetRuntime getRuntime(String id) {
        if (TargetRuntime.getAllRuntimes() == null) {
            return null;
        }
        TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
        int n = targetRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetRuntime rt = targetRuntimeArray[n2];
            if (rt.id.equals(id)) {
                return rt;
            }
            ++n2;
        }
        return null;
    }

    public static TargetRuntime getCurrentRuntime() {
        return currentRuntime;
    }

    public static void setCurrentRuntime(TargetRuntime rt) {
        currentRuntime = rt;
    }

    public static TargetRuntime getDefaultRuntime() {
        return TargetRuntime.getRuntime(DEFAULT_RUNTIME_ID);
    }

    public static String getFirstNonDefaultId() {
        String runtimeId = null;
        int nonDefaultRuntimeCount = 0;
        if (TargetRuntime.getAllRuntimes() == null) {
            return DEFAULT_RUNTIME_ID;
        }
        TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
        int n = targetRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetRuntime rt = targetRuntimeArray[n2];
            if (!rt.getId().equals(DEFAULT_RUNTIME_ID)) {
                ++nonDefaultRuntimeCount;
                runtimeId = rt.getId();
            }
            ++n2;
        }
        if (nonDefaultRuntimeCount == 1 && runtimeId != null) {
            return runtimeId;
        }
        return DEFAULT_RUNTIME_ID;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.bpmn2.content-type.xml", this.modelDescriptor.getResourceFactory());
    }

    public static TargetRuntime[] getAllRuntimes() {
        if (targetRuntimes == null) {
            ArrayList<TargetRuntime> rtList = new ArrayList<TargetRuntime>();
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(RUNTIME_EXTENSION_ID);
            try {
                IConfigurationElement c;
                IConfigurationElement[] iConfigurationElementArray;
                TargetRuntime rt3;
                String[] a;
                ModelEnablementDescriptor me;
                String ref;
                String profile;
                String type;
                Bpmn2TabDescriptor td;
                String name;
                String id;
                IConfigurationElement e;
                Object[] objectArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    e = objectArray[n2];
                    if (e.getName().equals("runtime")) {
                        IConfigurationElement[] markers;
                        id = e.getAttribute("id");
                        name = e.getAttribute("name");
                        String versions = e.getAttribute("versions");
                        String description = e.getAttribute("description");
                        TargetRuntime rt2 = new TargetRuntime(id, name, versions, description);
                        rt2.setRuntimeExtension((IBpmn2RuntimeExtension)e.createExecutableExtension("class"));
                        rtList.add(rt2);
                        IContributor contributor = e.getDeclaringExtension().getContributor();
                        IConfigurationElement[] iConfigurationElementArray2 = markers = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources.markers");
                        int n3 = markers.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement m = iConfigurationElementArray2[n4];
                            if (m.getDeclaringExtension().getContributor() == contributor) {
                                rt2.setProblemMarkerId(m.getDeclaringExtension().getUniqueIdentifier());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                targetRuntimes = rtList.toArray(new TargetRuntime[rtList.size()]);
                objectArray = config;
                n = config.length;
                n2 = 0;
                while (n2 < n) {
                    e = objectArray[n2];
                    if (!e.getName().equals("runtime")) {
                        currentRuntime = TargetRuntime.getRuntime(e);
                        if (e.getName().equals("model")) {
                            ModelDescriptor md = new ModelDescriptor();
                            if (e.getAttribute("uri") != null) {
                                String uri = e.getAttribute("uri");
                                md.setEPackage(EPackage.Registry.INSTANCE.getEPackage(uri));
                                md.setEFactory(md.getEPackage().getEFactoryInstance());
                            }
                            if (e.getAttribute("resourceFactory") != null) {
                                md.setResourceFactory((ResourceFactoryImpl)e.createExecutableExtension("resourceFactory"));
                            }
                            currentRuntime.setModelDescriptor(md);
                        }
                    }
                    ++n2;
                }
                objectArray = config;
                n = config.length;
                n2 = 0;
                while (n2 < n) {
                    e = objectArray[n2];
                    if (!e.getName().equals("runtime") && (currentRuntime = TargetRuntime.getRuntime(e)).getId().equals(DEFAULT_RUNTIME_ID)) {
                        if (e.getName().equals("propertyTab")) {
                            td = new Bpmn2TabDescriptor(e);
                            new Bpmn2SectionDescriptor(td, e);
                            currentRuntime.getTabs().add(td);
                        }
                        if (e.getName().equals("modelEnablement")) {
                            type = e.getAttribute("type");
                            profile = e.getAttribute("profile");
                            ref = e.getAttribute("ref");
                            me = new ModelEnablementDescriptor(currentRuntime);
                            currentRuntime.addModelEnablements(me);
                            me.setDiagramType(ModelUtil.Bpmn2DiagramType.fromString(type));
                            me.setProfile(profile);
                            if (ref != null) {
                                a = ref.split(":");
                                rt3 = TargetRuntime.getRuntime(a[0]);
                                type = a[1];
                                profile = a[2];
                                me.initializeFromTargetRuntime(rt3, ModelUtil.Bpmn2DiagramType.fromString(type), profile);
                            }
                            iConfigurationElementArray = e.getChildren();
                            int markers = iConfigurationElementArray.length;
                            int rt3 = 0;
                            while (rt3 < markers) {
                                c = iConfigurationElementArray[rt3];
                                String object = c.getAttribute("object");
                                String feature = c.getAttribute("feature");
                                if (c.getName().equals("enable")) {
                                    me.setEnabled(object, feature, true);
                                } else if (c.getName().equals("disable")) {
                                    me.setEnabled(object, feature, false);
                                }
                                ++rt3;
                            }
                        }
                    }
                    ++n2;
                }
                objectArray = config;
                n = config.length;
                n2 = 0;
                while (n2 < n) {
                    e = objectArray[n2];
                    if (!e.getName().equals("runtime")) {
                        currentRuntime = TargetRuntime.getRuntime(e);
                        if (e.getName().equals("propertyTab")) {
                            if (!currentRuntime.getId().equals(DEFAULT_RUNTIME_ID)) {
                                td = new Bpmn2TabDescriptor(e);
                                new Bpmn2SectionDescriptor(td, e);
                                currentRuntime.getTabs().add(td);
                            }
                        } else if (e.getName().equals("customTask")) {
                            id = e.getAttribute("id");
                            name = e.getAttribute("name");
                            CustomTaskDescriptor ct = new CustomTaskDescriptor(id, name);
                            ct.type = e.getAttribute("type");
                            ct.description = e.getAttribute("description");
                            ct.category = e.getAttribute("category");
                            ct.icon = e.getAttribute("icon");
                            String tabs = e.getAttribute("propertyTabs");
                            if (tabs != null) {
                                ct.propertyTabs = tabs.split(" ");
                            }
                            ct.featureContainer = (ICustomElementFeatureContainer)e.createExecutableExtension("featureContainer");
                            ct.featureContainer.setCustomTaskDescriptor(ct);
                            ct.featureContainer.setId(id);
                            ct.setPermanent(true);
                            TargetRuntime.getModelExtensionProperties(ct, e);
                            currentRuntime.addCustomTask(ct);
                        } else if (e.getName().equals("propertyExtension")) {
                            e.getAttribute("id");
                            PropertyExtensionDescriptor pe = new PropertyExtensionDescriptor(currentRuntime, e);
                            pe.type = e.getAttribute("type");
                            pe.adapterClassName = e.getAttribute("class");
                            currentRuntime.addPropertyExtension(pe);
                        } else if (e.getName().equals("featureContainer")) {
                            e.getAttribute("id");
                            FeatureContainerDescriptor fc = new FeatureContainerDescriptor(currentRuntime);
                            fc.type = e.getAttribute("type");
                            fc.containerClassName = e.getAttribute("class");
                            currentRuntime.addFeatureContainer(fc);
                        } else if (e.getName().equals("modelExtension")) {
                            id = e.getAttribute("id");
                            name = e.getAttribute("name");
                            ModelExtensionDescriptor me2 = new ModelExtensionDescriptor(id, name);
                            me2.type = e.getAttribute("type");
                            me2.description = e.getAttribute("description");
                            TargetRuntime.getModelExtensionProperties(me2, e);
                            currentRuntime.addModelExtension(me2);
                        } else if (e.getName().equals("modelEnablement")) {
                            if (!currentRuntime.getId().equals(DEFAULT_RUNTIME_ID)) {
                                type = e.getAttribute("type");
                                profile = e.getAttribute("profile");
                                ref = e.getAttribute("ref");
                                me = new ModelEnablementDescriptor(currentRuntime);
                                currentRuntime.addModelEnablements(me);
                                me.setDiagramType(ModelUtil.Bpmn2DiagramType.fromString(type));
                                me.setProfile(profile);
                                if (ref != null) {
                                    a = ref.split(":");
                                    rt3 = TargetRuntime.getRuntime(a[0]);
                                    type = a[1];
                                    profile = a[2];
                                    me.initializeFromTargetRuntime(rt3, ModelUtil.Bpmn2DiagramType.fromString(type), profile);
                                }
                                iConfigurationElementArray = e.getChildren();
                                int markers = iConfigurationElementArray.length;
                                int rt4 = 0;
                                while (rt4 < markers) {
                                    c = iConfigurationElementArray[rt4];
                                    String object = c.getAttribute("object");
                                    String feature = c.getAttribute("feature");
                                    if (c.getName().equals("enable")) {
                                        me.setEnabled(object, feature, true);
                                    } else if (c.getName().equals("disable")) {
                                        me.setEnabled(object, feature, false);
                                    }
                                    ++rt4;
                                }
                            }
                        } else if (e.getName().equals("style")) {
                            String object = e.getAttribute("object");
                            String foreground = e.getAttribute("foreground");
                            String background = e.getAttribute("background");
                            String textColor = e.getAttribute("textColor");
                            String font = e.getAttribute("font");
                            EClass eclass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(object);
                            ShapeStyle ss = new ShapeStyle(foreground, background, textColor, font);
                            currentRuntime.getShapeStyles().put(eclass.getInstanceClass(), ss);
                        } else if (e.getName().equals("toolPalette")) {
                            ToolPaletteDescriptor toolPalette = null;
                            String id2 = e.getAttribute("id");
                            for (ToolPaletteDescriptor tp : currentRuntime.getToolPalettes()) {
                                if (!tp.id.equals(id2)) continue;
                                toolPalette = tp;
                                break;
                            }
                            if (toolPalette == null) {
                                toolPalette = new ToolPaletteDescriptor();
                                currentRuntime.addToolPalette(toolPalette);
                            }
                            toolPalette.create(e);
                        }
                    }
                    ++n2;
                }
                objectArray = targetRuntimes;
                n = targetRuntimes.length;
                n2 = 0;
                while (n2 < n) {
                    IConfigurationElement rt5 = objectArray[n2];
                    if (rt5.modelDescriptor == null) {
                        rt5.modelDescriptor = TargetRuntime.getDefaultRuntime().getModelDescriptor();
                    }
                    for (ToolPaletteDescriptor tp : rt5.getToolPalettes()) {
                        tp.sortCategories();
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                Activator.logError(ex);
            }
            currentRuntime = TargetRuntime.getDefaultRuntime();
            CustomTaskImageProvider.registerAvailableImages();
        }
        return targetRuntimes;
    }

    private static Object getModelExtensionProperties(ModelExtensionDescriptor ct, IConfigurationElement e) {
        String elem = e.getName();
        if ("value".equals(elem)) {
            String id = e.getAttribute("id");
            ModelExtensionDescriptor.Value val = new ModelExtensionDescriptor.Value(id);
            IConfigurationElement[] iConfigurationElementArray = e.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                Object propValue = TargetRuntime.getModelExtensionProperties(null, c);
                val.getValues().add(propValue);
                ++n2;
            }
            return val;
        }
        if ("property".equals(elem)) {
            Object o;
            String name = e.getAttribute("name");
            String value = e.getAttribute("value");
            String ref = e.getAttribute("ref");
            String type = e.getAttribute("type");
            String description = e.getAttribute("description");
            ModelExtensionDescriptor.Property prop = new ModelExtensionDescriptor.Property(name, description);
            prop.type = type;
            if (value != null) {
                prop.getValues().add(value);
            } else if (ref != null) {
                prop.ref = ref;
            } else if (e.getChildren().length > 0 && (o = TargetRuntime.getModelExtensionProperties(null, e.getChildren()[0])) instanceof ModelExtensionDescriptor.Value) {
                prop.getValues().addAll(((ModelExtensionDescriptor.Value)o).getValues());
            }
            return prop;
        }
        IConfigurationElement[] iConfigurationElementArray = e.getChildren();
        int n = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n) {
            IConfigurationElement c = iConfigurationElementArray[n3];
            Object o = TargetRuntime.getModelExtensionProperties(null, c);
            if (o instanceof ModelExtensionDescriptor.Property && ct != null) {
                ct.getProperties().add((ModelExtensionDescriptor.Property)o);
            }
            ++n3;
        }
        return null;
    }

    private static TargetRuntime getRuntime(IConfigurationElement e) {
        String runtimeId = e.getAttribute("runtimeId");
        TargetRuntime rt = TargetRuntime.getRuntime(runtimeId);
        if (rt == null) {
            return currentRuntime;
        }
        return rt;
    }

    public ModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    public void setModelDescriptor(ModelDescriptor md) {
        md.setRuntime(this);
        this.modelDescriptor = md;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList<CustomTaskDescriptor> getCustomTasks() {
        if (this.customTasks == null) {
            this.customTasks = new ArrayList();
        }
        return this.customTasks;
    }

    public CustomTaskDescriptor getCustomTask(String id) {
        for (CustomTaskDescriptor ctd : this.customTasks) {
            if (!ctd.getId().equalsIgnoreCase(id)) continue;
            return ctd;
        }
        return null;
    }

    public boolean customTaskExists(String id) {
        for (CustomTaskDescriptor ctd : this.customTasks) {
            if (!ctd.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    public void addCustomTask(CustomTaskDescriptor ct) {
        ct.setRuntime(this);
        this.getCustomTasks().add(ct);
    }

    public ArrayList<ModelExtensionDescriptor> getModelExtensions() {
        if (this.modelExtensions == null) {
            this.modelExtensions = new ArrayList();
        }
        return this.modelExtensions;
    }

    public void addModelExtension(ModelExtensionDescriptor me) {
        me.setRuntime(this);
        this.getModelExtensions().add(me);
    }

    public ArrayList<PropertyExtensionDescriptor> getPropertyExtensions() {
        if (this.propertyExtensions == null) {
            this.propertyExtensions = new ArrayList();
        }
        return this.propertyExtensions;
    }

    public void addPropertyExtension(PropertyExtensionDescriptor me) {
        me.setRuntime(this);
        this.getPropertyExtensions().add(me);
    }

    public PropertyExtensionDescriptor getPropertyExtension(Class clazz) {
        for (PropertyExtensionDescriptor ped : this.getPropertyExtensions()) {
            String className = clazz.getName();
            if (className.equals(ped.type)) {
                return ped;
            }
            className = className.replaceFirst("\\.impl\\.", ".");
            if (!(className = className.replaceFirst("Impl$", "")).equals(ped.type)) continue;
            return ped;
        }
        return null;
    }

    public ArrayList<FeatureContainerDescriptor> getFeatureContainers() {
        if (this.featureContainers == null) {
            this.featureContainers = new ArrayList();
        }
        return this.featureContainers;
    }

    public void addFeatureContainer(FeatureContainerDescriptor me) {
        me.setRuntime(this);
        this.getFeatureContainers().add(me);
    }

    public FeatureContainerDescriptor getFeatureContainer(EClass clazz) {
        for (FeatureContainerDescriptor fcd : this.getFeatureContainers()) {
            String className = clazz.getInstanceClassName();
            if (className.equals(fcd.type)) {
                return fcd;
            }
            className = className.replaceFirst("\\.impl\\.", ".");
            if (!(className = className.replaceFirst("Impl$", "")).equals(fcd.type)) continue;
            return fcd;
        }
        return null;
    }

    public ArrayList<ModelEnablementDescriptor> getModelEnablements() {
        if (this.modelEnablements == null) {
            this.modelEnablements = new ArrayList();
        }
        return this.modelEnablements;
    }

    public ModelEnablementDescriptor getModelEnablements(EObject object) {
        ArrayList<ModelEnablementDescriptor> meds;
        TargetRuntime rt = this;
        DiagramEditor diagramEditor = ModelUtil.getEditor(object);
        if (diagramEditor != null) {
            rt = (TargetRuntime)diagramEditor.getAdapter(TargetRuntime.class);
        }
        if ((meds = rt.getModelEnablements()).size() > 0) {
            return meds.get(0);
        }
        return null;
    }

    public ArrayList<ModelEnablementDescriptor> getModelEnablements(ModelUtil.Bpmn2DiagramType diagramType) {
        ArrayList<ModelEnablementDescriptor> list = new ArrayList<ModelEnablementDescriptor>();
        for (ModelEnablementDescriptor me : this.getModelEnablements()) {
            if (diagramType == ModelUtil.Bpmn2DiagramType.NONE && me.getDiagramType() == null) {
                list.add(me);
                continue;
            }
            if (diagramType != me.getDiagramType()) continue;
            list.add(me);
        }
        return list;
    }

    public ModelEnablementDescriptor getModelEnablements(ModelUtil.Bpmn2DiagramType diagramType, String profile) {
        if (profile != null && profile.isEmpty()) {
            profile = null;
        }
        for (ModelEnablementDescriptor me : this.getModelEnablements()) {
            if (diagramType == ModelUtil.Bpmn2DiagramType.NONE && me.getDiagramType() == null && (profile == null || profile.equalsIgnoreCase(me.getProfile()))) {
                return me;
            }
            if (diagramType != me.getDiagramType() || profile != null && !profile.equalsIgnoreCase(me.getProfile())) continue;
            return me;
        }
        if (this != TargetRuntime.getDefaultRuntime()) {
            return TargetRuntime.getDefaultRuntime().getModelEnablements(diagramType, profile);
        }
        if (this.defaultModelEnablements == null) {
            this.defaultModelEnablements = new ModelEnablementDescriptor(TargetRuntime.getDefaultRuntime());
        }
        return this.defaultModelEnablements;
    }

    public void addModelEnablements(ModelEnablementDescriptor me) {
        me.setRuntime(this);
        this.getModelEnablements().add(me);
    }

    public ArrayList<ToolPaletteDescriptor> getToolPalettes() {
        if (this.toolPalettes == null) {
            this.toolPalettes = new ArrayList();
        }
        return this.toolPalettes;
    }

    public ToolPaletteDescriptor getToolPalette(EObject object) {
        DiagramEditor diagramEditor = ModelUtil.getEditor(object);
        return (ToolPaletteDescriptor)diagramEditor.getAdapter(ToolPaletteDescriptor.class);
    }

    public ToolPaletteDescriptor getToolPalette(ModelUtil.Bpmn2DiagramType diagramType, String profile) {
        ToolPaletteDescriptor defaultToolPalette = null;
        for (ToolPaletteDescriptor tp : this.getToolPalettes()) {
            String s = diagramType.name();
            if (diagramType == ModelUtil.Bpmn2DiagramType.NONE && tp.getType() == null) {
                if (profile == null) {
                    return tp;
                }
                for (String p : tp.getProfiles()) {
                    if (!profile.equalsIgnoreCase(p)) continue;
                    return tp;
                }
            }
            if (s.equalsIgnoreCase(tp.getType())) {
                if (profile == null) {
                    return tp;
                }
                for (String p : tp.getProfiles()) {
                    if (!profile.equalsIgnoreCase(p)) continue;
                    return tp;
                }
            }
            if (tp.getType() != null && !tp.getType().isEmpty()) continue;
            defaultToolPalette = tp;
        }
        if (defaultToolPalette != null) {
            return defaultToolPalette;
        }
        if (this != TargetRuntime.getDefaultRuntime()) {
            return TargetRuntime.getDefaultRuntime().getToolPalette(diagramType, profile);
        }
        return null;
    }

    public void addToolPalette(ToolPaletteDescriptor tp) {
        tp.setRuntime(this);
        this.getToolPalettes().add(tp);
    }

    public Map<Class, ShapeStyle> getShapeStyles() {
        if (this.shapeStyles == null) {
            this.shapeStyles = new HashMap();
        }
        return this.shapeStyles;
    }

    public ShapeStyle getShapeStyle(Class c) {
        ShapeStyle ss = this.getShapeStyles().get(c);
        if (ss == null) {
            ss = new ShapeStyle(ss);
        }
        return ss;
    }

    private void addAfterTab(ArrayList<Bpmn2TabDescriptor> list, Bpmn2TabDescriptor tab) {
        TargetRuntime.getAllRuntimes();
        String afterTab = tab.getAfterTab();
        if (afterTab != null && !afterTab.isEmpty() && !afterTab.equals("top")) {
            tab.getId();
            TargetRuntime[] targetRuntimeArray = targetRuntimes;
            int n = targetRuntimes.length;
            int n2 = 0;
            while (n2 < n) {
                TargetRuntime rt = targetRuntimeArray[n2];
                for (Bpmn2TabDescriptor td : rt.getTabs()) {
                    if (tab == td || !td.getId().equals(afterTab) && !td.isReplacementForTab(afterTab)) continue;
                    this.addAfterTab(list, td);
                    if (rt != this && rt != TargetRuntime.getDefaultRuntime() || list.contains((Object)td)) continue;
                    list.add(td);
                }
                ++n2;
            }
        }
    }

    private ArrayList<Bpmn2TabDescriptor> getTabs() {
        if (this.tabDescriptors == null) {
            this.tabDescriptors = new ArrayList();
        }
        return this.tabDescriptors;
    }

    public static Bpmn2TabDescriptor findTabDescriptor(String id) {
        TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
        int n = targetRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetRuntime rt = targetRuntimeArray[n2];
            Bpmn2TabDescriptor tab = rt.getTabDescriptor(id);
            if (tab != null) {
                return tab;
            }
            ++n2;
        }
        return null;
    }

    public Bpmn2TabDescriptor getTabDescriptor(String id) {
        for (Bpmn2TabDescriptor tab : this.getTabs()) {
            if (!tab.getId().equals(id)) continue;
            return tab;
        }
        return null;
    }

    public ArrayList<Bpmn2TabDescriptor> getTabDescriptors() {
        ArrayList<Bpmn2TabDescriptor> list = new ArrayList<Bpmn2TabDescriptor>();
        for (Bpmn2TabDescriptor tab : this.getTabs()) {
            this.addAfterTab(list, tab);
            if (list.contains((Object)tab)) continue;
            list.add(tab);
        }
        return list;
    }

    public IBpmn2RuntimeExtension getRuntimeExtension() {
        return this.runtimeExtension;
    }

    public void setRuntimeExtension(IBpmn2RuntimeExtension runtimeExtension) {
        this.runtimeExtension = runtimeExtension;
    }

    public void setResource(Bpmn2Resource bpmnResource) {
        this.bpmnResource = bpmnResource;
        TreeIterator iter = bpmnResource.getAllContents();
        block0: while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            String className = object.eClass().getName();
            for (ModelExtensionDescriptor med : this.getModelExtensions()) {
                if (!className.equals(med.getType())) continue;
                med.adaptObject(object);
                break;
            }
            for (CustomTaskDescriptor ctd : this.getCustomTasks()) {
                if (!className.equals(ctd.getType()) || ctd.getFeatureContainer().getId(object) == null) continue;
                ctd.adaptObject(object);
                continue block0;
            }
        }
    }

    public Bpmn2Resource getResource() {
        return this.bpmnResource;
    }

    protected void setProblemMarkerId(String id) {
        this.problemMarkerId = id;
    }

    public String getProblemMarkerId() {
        if (this.problemMarkerId == null) {
            return BPMN2_MARKER_ID;
        }
        return this.problemMarkerId;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof TargetRuntime) {
            if (this.id != null && this.id.equals(((TargetRuntime)arg0).getId())) {
                return true;
            }
        } else if (arg0 instanceof String) {
            return ((String)arg0).equals(this.id);
        }
        return super.equals(arg0);
    }
}

