/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.osgi.util.NLS;

public class ModelExtensionDescriptor
extends BaseRuntimeDescriptor {
    protected String id;
    protected String name;
    protected String type;
    protected String description;
    protected List<Property> properties = new ArrayList<Property>();
    protected Resource containingResource;
    protected EObject modelObject;

    public ModelExtensionDescriptor(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public EObject createObject(EObject container) {
        if (container != null) {
            this.containingResource = container.eResource();
        }
        this.modelObject = this.createObject(this.getType());
        this.populateObject(this.modelObject, true);
        return this.modelObject;
    }

    private EObject createObject(String className) {
        EClass eClass = (EClass)this.getEPackage().getEClassifier(className);
        if (eClass == null) {
            eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(className);
        }
        if (eClass != null) {
            return this.createObject(eClass);
        }
        return null;
    }

    private EObject createObject(EClass eClass) {
        EObject eObject = null;
        EPackage pkg = eClass.getEPackage();
        eObject = pkg == Bpmn2Package.eINSTANCE ? Bpmn2ModelerFactory.create(this.containingResource, eClass) : pkg.getEFactoryInstance().create(eClass);
        String id = ModelUtil.setID(eObject, this.containingResource);
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature("name");
        if (feature != null) {
            if (id != null) {
                eObject.eSet(feature, (Object)ModelUtil.toDisplayName(id));
            } else {
                eObject.eSet(feature, (Object)NLS.bind((String)Messages.ModelExtensionDescriptor_Create, (Object)ModelUtil.toDisplayName(eObject.eClass().getName())));
            }
        }
        return eObject;
    }

    private EStructuralFeature getFeature(Class type, String name) {
        EStructuralFeature feature = this.getFeature(this.getEPackage(), type, name);
        if (feature == null) {
            feature = this.getFeature((EPackage)Bpmn2Package.eINSTANCE, type, name);
        }
        return feature;
    }

    private EStructuralFeature getFeature(EPackage pkg, Class type, String name) {
        TreeIterator it = pkg.eAllContents();
        while (it.hasNext()) {
            EStructuralFeature fName;
            EObject o = (EObject)it.next();
            if (!type.isInstance(o) || (fName = o.eClass().getEStructuralFeature("name")) == null || o.eGet(fName) == null || !o.eGet(fName).equals(name)) continue;
            return (EStructuralFeature)o;
        }
        return null;
    }

    public void populateObjectFromValues(EObject object, List<Object> values, boolean all) {
        for (Object value : values) {
            if (!(value instanceof Property)) continue;
            this.populateObject(object, (Property)value, all);
        }
    }

    public EObject populateObject(EObject object, Resource resource, boolean all) {
        this.containingResource = resource;
        this.modelObject = object;
        this.populateObject(this.modelObject, all);
        return this.modelObject;
    }

    public void populateObject(EObject object, boolean all) {
        this.modelObject = object;
        this.populateObject(object, this.getProperties(), all);
        this.adaptObject(object);
    }

    public void populateObject(EObject object, List<Property> properties, boolean all) {
        for (Property prop : properties) {
            this.populateObject(object, prop, all);
        }
    }

    private void setValue(EObject object, EStructuralFeature feature, Object value, boolean force, Property property) {
        this.setValueFromString(object, feature, value, force);
    }

    private Object getValue(EObject object, EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            return ((EList)object.eGet(feature)).get(index < 0 ? 0 : index);
        }
        return object.eGet(feature);
    }

    public EStructuralFeature getFeature(EClass eclass, Property property) {
        Object firstValue;
        Object feature = eclass.getEStructuralFeature(property.name);
        Object object = firstValue = property.getValues().isEmpty() ? null : property.getValues().get(0);
        if (feature == null) {
            EPackage pkg = this.getEPackage();
            feature = property.ref != null || firstValue instanceof Property ? ModelUtil.createDynamicReference(pkg, (EObject)eclass, property.name, property.type) : ModelUtil.createDynamicAttribute(pkg, (EObject)eclass, property.name, property.type);
        }
        return feature;
    }

    public EStructuralFeature populateObject(EObject object, Property property, boolean all) {
        Object firstValue;
        EObject childObject = null;
        EStructuralFeature childFeature = null;
        Object feature = object.eClass().getEStructuralFeature(property.name);
        Object object2 = firstValue = property.getValues().isEmpty() ? null : property.getValues().get(0);
        if (feature == null) {
            EPackage pkg = this.getEPackage();
            feature = property.ref != null || firstValue instanceof Property ? ModelUtil.createDynamicReference(pkg, object, property.name, property.type) : ModelUtil.createDynamicAttribute(pkg, object, property.name, property.type);
        }
        if (feature instanceof EAttribute) {
            if (all && feature.getEType().getInstanceClass() == FeatureMap.Entry.class) {
                for (Object value : property.getValues()) {
                    if (!(value instanceof Property)) continue;
                    Property p = (Property)value;
                    childFeature = this.getFeature(p.name);
                    if (childFeature instanceof EAttribute) {
                        childObject = this.createObject((EObject)((EReference)childFeature));
                        this.setValue(childObject, childFeature, firstValue, true, property);
                        continue;
                    }
                    if (!(childFeature instanceof EReference)) continue;
                    childObject = this.createObject(((EReference)childFeature).getEReferenceType());
                    EStructuralFeatureImpl.SimpleFeatureMapEntry entry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)childFeature, (Object)childObject);
                    this.setValue(object, (EStructuralFeature)feature, entry, true, property);
                    this.populateObjectFromValues(childObject, p.getValues(), true);
                }
            } else {
                this.setValue(object, (EStructuralFeature)feature, firstValue, all, property);
            }
        } else if (feature instanceof EReference && all) {
            EReference ref = (EReference)feature;
            if (property.ref != null) {
                String[] segments;
                childObject = this.modelObject;
                String[] stringArray = segments = property.ref.split("/");
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    int index = s.indexOf(35);
                    if (index > 0) {
                        index = Integer.parseInt(s.substring(index + 1));
                        s = s.split("#")[0];
                    }
                    childFeature = childObject.eClass().getEStructuralFeature(s);
                    childObject = (EObject)this.getValue(childObject, childFeature, index);
                    ++n2;
                }
                this.setValue(object, (EStructuralFeature)feature, childObject, true, property);
            } else if (firstValue instanceof Property) {
                EClass reftype;
                Object object3 = reftype = property.type == null || property.type.length() == 0 ? null : ModelUtil.getEClassifierFromString(this.getEPackage(), property.type);
                if (reftype == null || !(reftype instanceof EClass)) {
                    reftype = ref.getEReferenceType();
                }
                childObject = this.createObject(reftype);
                this.setValue(object, (EStructuralFeature)feature, childObject, true, property);
                this.populateObjectFromValues(childObject, property.getValues(), all);
            }
        }
        return feature;
    }

    public Object getPropertyValue(String name) {
        for (Property prop : this.getProperties()) {
            if (!prop.name.equals(name) || prop.getValues().isEmpty()) continue;
            return prop.getValues().get(0);
        }
        return null;
    }

    public List<Property> getProperties(String path) {
        ArrayList<Property> result = new ArrayList<Property>();
        ArrayList<Property> props = new ArrayList<Property>();
        props.addAll(this.getProperties());
        String[] names = path.split("/");
        this.getProperties(props, names, 0, result);
        return result;
    }

    private void getProperties(List<Property> props, String[] names, int index, List<Property> result) {
        String name = names[index];
        for (Property p : props) {
            if (!p.name.equals(name)) continue;
            if (index == names.length - 1) {
                result.add(p);
                continue;
            }
            ArrayList<Property> childProps = new ArrayList<Property>();
            for (Object v : p.values) {
                if (!(v instanceof Property)) continue;
                childProps.add((Property)v);
            }
            this.getProperties(childProps, names, index + 1, result);
        }
    }

    public Property getProperty(String name) {
        for (Property prop : this.getProperties()) {
            if (!prop.name.equals(name)) continue;
            return prop;
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public static ModelExtensionAdapter getModelExtensionAdapter(EObject object) {
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ModelExtensionAdapter)) continue;
            return (ModelExtensionAdapter)a;
        }
        return null;
    }

    public void adaptObject(EObject object) {
        ExtendedPropertiesAdapter adapter;
        this.addModelExtensionAdapter(object);
        if (this.description != null && !this.description.isEmpty() && (adapter = ExtendedPropertiesAdapter.adapt(object)) != null) {
            adapter.setProperty("custom.description", this.description);
        }
    }

    private void addModelExtensionAdapter(EObject object) {
        if (!object.eAdapters().contains((Object)this)) {
            object.eAdapters().add((Object)new ModelExtensionAdapter(this));
        }
    }

    public class ModelExtensionAdapter
    extends AdapterImpl {
        ModelExtensionDescriptor descriptor;

        public ModelExtensionAdapter(ModelExtensionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Property getProperty(String name) {
            return this.descriptor.getProperty(name);
        }

        public List<Property> getProperties(String path) {
            return this.descriptor.getProperties(path);
        }

        public ModelExtensionDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class Property {
        public String name;
        public String description;
        public List<Object> values;
        public String ref;
        public String type;

        public Property() {
            this.name = "unknown";
        }

        public Property(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public List<Object> getValues() {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            return this.values;
        }

        public String getFirstStringValue() {
            if (!this.getValues().isEmpty()) {
                for (Object propValue : this.getValues()) {
                    String s;
                    if (propValue instanceof String) {
                        return (String)propValue;
                    }
                    if (!(propValue instanceof Property) || (s = ((Property)propValue).getFirstStringValue()) == null) continue;
                    return s;
                }
            }
            return null;
        }
    }

    public static class Value {
        static int ID = 0;
        String id;
        public List<Object> values;

        public Value() {
            this.setDefaultId();
        }

        public Value(String id) {
            if (id == null || id.isEmpty()) {
                this.setDefaultId();
            } else {
                this.id = id;
            }
        }

        public List<Object> getValues() {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            return this.values;
        }

        private void setDefaultId() {
            this.id = "V-" + ID++;
        }
    }
}

