/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultPropertySection;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2TabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.IBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.runtime.PropertySectionFilter;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;

public class Bpmn2SectionDescriptor
extends AbstractSectionDescriptor {
    protected String id;
    protected String tab;
    protected AbstractPropertySection sectionClass;
    protected List<Class> appliesToClasses;
    protected String enablesFor;
    protected String filterClassName;
    protected PropertySectionFilter filter;

    public Bpmn2SectionDescriptor(Bpmn2TabDescriptor td, IConfigurationElement e) {
        block14: {
            this.appliesToClasses = new ArrayList<Class>();
            this.tab = td.getId();
            this.id = String.valueOf(this.tab) + ".section";
            try {
                String[] types;
                String className = e.getAttribute("class");
                if ("default".equals(className)) {
                    this.sectionClass = new DefaultPropertySection();
                    if (e.getAttribute("features") != null) {
                        String[] properties = e.getAttribute("features").split(" ");
                        ((DefaultPropertySection)this.sectionClass).setProperties(properties);
                    }
                } else {
                    this.sectionClass = (AbstractPropertySection)e.createExecutableExtension("class");
                }
                this.filterClassName = e.getAttribute("filter");
                if (this.filterClassName == null || this.filterClassName.isEmpty()) {
                    this.filterClassName = "org.eclipse.bpmn2.modeler.core.runtime.PropertySectionFilter";
                }
                this.filter = (PropertySectionFilter)((Object)Class.forName(this.filterClassName).getConstructor(null).newInstance(null));
                this.enablesFor = e.getAttribute("enablesFor");
                String type = e.getAttribute("type");
                if (type == null || type.isEmpty()) break block14;
                String[] stringArray = types = type.split(" ");
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(t);
                    }
                    catch (Exception exception) {
                        clazz = null;
                    }
                    if (clazz == null) {
                        TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
                        int n3 = targetRuntimeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TargetRuntime rt = targetRuntimeArray[n4];
                            try {
                                clazz = rt.getRuntimeExtension().getClass().getClassLoader().loadClass(t);
                                break;
                            }
                            catch (Exception exception) {
                                ++n4;
                            }
                        }
                    }
                    this.addAppliesToClass(clazz);
                    if (this.sectionClass instanceof DefaultPropertySection) {
                        ((DefaultPropertySection)this.sectionClass).addAppliesToClass(clazz);
                    }
                    ++n2;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        td.getSectionDescriptors().add(this);
    }

    public Bpmn2SectionDescriptor(Bpmn2TabDescriptor td, Bpmn2SectionDescriptor that) {
        this.appliesToClasses = new ArrayList<Class>();
        this.tab = td.getId();
        this.id = String.valueOf(this.tab) + ".section" + ((Object)((Object)this)).hashCode();
        this.sectionClass = that.sectionClass;
        this.appliesToClasses.addAll(that.appliesToClasses);
        this.enablesFor = that.enablesFor;
        this.filterClassName = that.filterClassName;
        this.filter = that.filter;
    }

    public String getId() {
        return this.id;
    }

    public ISection getSectionClass() {
        return this.sectionClass;
    }

    public String getTargetTab() {
        return this.tab;
    }

    protected void addAppliesToClass(Class clazz) {
        Assert.isNotNull((Object)clazz);
        this.appliesToClasses.add(clazz);
    }

    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        EObject businessObject = null;
        PictogramElement pe = BusinessObjectUtil.getPictogramElementForSelection(selection);
        if (pe != null) {
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if (!this.filter.select(pe)) {
                return false;
            }
            businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pe);
        } else {
            businessObject = BusinessObjectUtil.getBusinessObjectForSelection(selection);
        }
        DiagramEditor editor = ModelUtil.getDiagramEditor(businessObject);
        if (editor != null) {
            TargetRuntime rt = (TargetRuntime)editor.getAdapter(TargetRuntime.class);
            if (rt != null) {
                int selected = 0;
                int count = 0;
                for (CustomTaskDescriptor tc : rt.getCustomTasks()) {
                    String[] stringArray = tc.getPropertyTabs();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (this.tab.equals(s)) {
                            if (tc.getFeatureContainer().getId(businessObject) != null) {
                                ++selected;
                            }
                            ++count;
                        }
                        ++n2;
                    }
                }
                if (count > 0 && selected == 0) {
                    return false;
                }
            }
            Diagram diagram = editor.getDiagramTypeProvider().getDiagram();
            EObject o = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
            if (o == null || o.eResource() != businessObject.eResource()) {
                return false;
            }
        }
        if (this.sectionClass instanceof IBpmn2PropertySection) {
            if (businessObject == null) {
                return false;
            }
            return ((IBpmn2PropertySection)this.sectionClass).appliesTo(part, selection);
        }
        if (this.appliesToClasses.isEmpty()) {
            return true;
        }
        if (pe != null && pe.getLink() != null) {
            for (EObject eObj : pe.getLink().getBusinessObjects()) {
                if (!this.appliesTo(eObj)) continue;
                return true;
            }
        }
        return businessObject != null && this.appliesTo(businessObject);
    }

    public boolean appliesTo(EObject eObj) {
        for (Class c : this.appliesToClasses) {
            if (!c.isInstance(eObj)) continue;
            return true;
        }
        return false;
    }

    public int getEnablesFor() {
        try {
            return Integer.parseInt(this.enablesFor);
        }
        catch (Exception exception) {
            return super.getEnablesFor();
        }
    }

    public IFilter getFilter() {
        return new IFilter(){

            public boolean select(Object toTest) {
                return false;
            }
        };
    }

    public List getInputTypes() {
        return super.getInputTypes();
    }

    public boolean doReplaceTab(String replacedId, IWorkbenchPart part, ISelection selection) {
        if (this.sectionClass instanceof IBpmn2PropertySection) {
            return ((IBpmn2PropertySection)this.sectionClass).doReplaceTab(replacedId, part, selection);
        }
        return this.appliesTo(part, selection);
    }
}

