/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class BaseRuntimeDescriptor {
    protected TargetRuntime targetRuntime;

    public BaseRuntimeDescriptor() {
    }

    public BaseRuntimeDescriptor(TargetRuntime rt) {
        this.targetRuntime = rt;
    }

    public TargetRuntime getRuntime() {
        return this.targetRuntime;
    }

    public void setRuntime(TargetRuntime targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public EPackage getEPackage() {
        if (this.targetRuntime.getModelDescriptor() != null) {
            return this.targetRuntime.getModelDescriptor().getEPackage();
        }
        return Bpmn2Package.eINSTANCE;
    }

    public EStructuralFeature getFeature(String className, String featureName) {
        return this.getFeature(String.valueOf(className) + "." + featureName);
    }

    public EStructuralFeature getFeature(String name) {
        String[] parts = name.split("\\.");
        EClass eClass = (EClass)this.getEPackage().getEClassifier(parts[0]);
        if (eClass == null) {
            eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(parts[0]);
        }
        if (eClass != null) {
            EStructuralFeature feature = eClass.getEStructuralFeature(parts[1]);
            if (feature != null && ExtendedMetaData.INSTANCE.getFeatureKind(feature) == 0) {
                if (feature instanceof EAttribute) {
                    ExtendedMetaData.INSTANCE.setFeatureKind(feature, 2);
                } else {
                    ExtendedMetaData.INSTANCE.setFeatureKind(feature, 4);
                }
                ExtendedMetaData.INSTANCE.setNamespace(feature, eClass.getEPackage().getNsURI());
                ExtendedMetaData.INSTANCE.setName(feature, feature.getName());
            }
            return feature;
        }
        return null;
    }

    public EClassifier getClassifier(String name) {
        EClass eClass = (EClass)this.getEPackage().getEClassifier(name);
        if (eClass == null) {
            eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(name);
        }
        return eClass;
    }

    public void setValueFromString(EObject object, EStructuralFeature feature, Object value, boolean force) {
        if (value == null) {
            return;
        }
        if (feature.isMany()) {
            ((EList)object.eGet(feature)).add(value);
        } else {
            if (value instanceof String) {
                EDataType eDataType = (EDataType)feature.getEType();
                try {
                    EFactory factory = ModelUtil.getEPackage(feature).getEFactoryInstance();
                    value = factory.createFromString(eDataType, (String)value);
                }
                catch (Exception exception) {
                    EFactory factory = EcorePackage.eINSTANCE.getEFactoryInstance();
                    value = factory.createFromString(eDataType, (String)value);
                }
            }
            if (object.eClass().getEStructuralFeature(feature.getName()) != null) {
                if (!object.eIsSet(feature) || force) {
                    object.eSet(feature, value);
                }
            } else if (object instanceof ExtensionAttributeValue) {
                ModelUtil.addExtensionAttributeValue(object.eContainer(), feature, value);
            } else {
                EStructuralFeature f = ModelUtil.getAnyAttribute(object, feature.getName());
                if (f != null && object.eGet(f) != null) {
                    return;
                }
                if (!object.eIsSet(feature) || force) {
                    object.eSet(feature, value);
                }
            }
        }
    }
}

