/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.merrimac.providers.TableProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ColumnTableProvider
extends TableProvider {
    protected TableViewer tableViewer;
    protected ArrayList<Column> columns = new ArrayList();

    public void add(int index, Column column) {
        this.register(column.getProperty(), column.getLabelProvider(), column.getCellModifier());
        this.columns.add(index, column);
        this.columnProperties = null;
    }

    public void add(Column column) {
        this.add(this.columns.size(), column);
    }

    public void remove(int index) {
        Column column = this.columns.get(index);
        if (column != null) {
            this.remove(column);
        }
    }

    public void remove(Column column) {
        this.unregister(column.getProperty());
        this.columns.remove(column);
        this.columnProperties = null;
    }

    public List getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void createTableLayout(Table table) {
        TableLayout tableLayout = new TableLayout();
        for (Column column : this.columns) {
            TableColumn tc = new TableColumn(table, column.getAlignment());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(column.getInitialWeight()));
            tc.setText(column.getHeaderText());
        }
        table.setLayout((Layout)tableLayout);
    }

    @Override
    public void setColumnProperties(String[] unused) {
    }

    @Override
    public String[] getColumnProperties() {
        if (this.columnProperties == null) {
            this.columnProperties = new String[this.columns.size()];
            int i = 0;
            while (i < this.columns.size()) {
                this.columnProperties[i] = this.getColumnProperty(i);
                ++i;
            }
        }
        return this.columnProperties;
    }

    @Override
    public String getColumnProperty(int index) {
        return this.columns.get(index).getProperty();
    }

    public CellEditor[] createCellEditors(Composite parent) {
        CellEditor[] cellEditors = new CellEditor[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            cellEditors[i] = this.columns.get(i).createCellEditor(parent);
            ++i;
        }
        return cellEditors;
    }

    public void setTableViewer(TableViewer tv) {
        this.tableViewer = tv;
        for (Column column : this.columns) {
            column.setTableViewer(tv);
        }
    }

    public static abstract class Column
    implements IBaseLabelProvider {
        protected TableViewer tableViewer;

        public abstract String getHeaderText();

        public int getAlignment() {
            return 16384;
        }

        public int getInitialWeight() {
            return 10;
        }

        public abstract String getProperty();

        public IBaseLabelProvider getLabelProvider() {
            if (this instanceof ITableLabelProvider) {
                return this;
            }
            return this instanceof ILabelProvider ? (ILabelProvider)this : null;
        }

        public ICellModifier getCellModifier() {
            return this instanceof ICellModifier ? (ICellModifier)this : null;
        }

        public CellEditor createCellEditor(Composite parent) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.getProperty().equals(property);
        }

        public Image getImage(Object element) {
            return null;
        }

        public void setTableViewer(TableViewer tv) {
            this.tableViewer = tv;
        }
    }
}

