/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.providers.ColumnTableProvider;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public class TableColumn
extends ColumnTableProvider.Column
implements ILabelProvider,
ICellModifier {
    protected AbstractListComposite listComposite;
    protected EObject object;
    protected EStructuralFeature feature;
    protected boolean editable = true;
    protected String headerText = null;

    public TableColumn(EObject o, EStructuralFeature f) {
        this(null, o, f);
    }

    public TableColumn(AbstractListComposite abstractListComposite, EObject o, EStructuralFeature f) {
        this.listComposite = abstractListComposite;
        this.object = o;
        this.feature = f;
    }

    public TableColumn(EObject o, String f) {
        this(null, o, f);
    }

    public TableColumn(AbstractListComposite abstractListComposite, EObject o, String f) {
        this.listComposite = abstractListComposite;
        this.object = o;
        this.feature = o.eClass().getEStructuralFeature(f);
    }

    public void setOwner(AbstractListComposite abstractListComposite) {
        this.listComposite = abstractListComposite;
    }

    public void setHeaderText(String text) {
        this.headerText = text;
    }

    @Override
    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        String text = "";
        if (this.feature != null) {
            if (this.feature.eContainer() instanceof EClass) {
                EClass eclass = this.listComposite.getListItemClass();
                text = ModelUtil.getLabel((EObject)eclass, this.feature);
            } else {
                text = ModelUtil.toDisplayName(this.feature.getName());
            }
        }
        return text;
    }

    @Override
    public String getProperty() {
        if (this.feature != null) {
            return this.feature.getName();
        }
        return "";
    }

    @Override
    public int getInitialWeight() {
        return 10;
    }

    public String getText(Object element) {
        if (element instanceof EObject) {
            return ModelUtil.getDisplayName((EObject)element, this.feature);
        }
        return element.toString();
    }

    protected int getColumnIndex() {
        return this.listComposite.getColumnProvider().getColumns().indexOf(this);
    }

    protected Composite getParent() {
        return this.tableViewer.getTable();
    }

    protected void setCellEditor(CellEditor ce) {
        CellEditor[] cellEditors = this.tableViewer.getCellEditors();
        int index = this.getColumnIndex();
        if (index >= 0 && index < cellEditors.length) {
            CellEditor oldCe = cellEditors[index];
            if (oldCe != null && oldCe != ce) {
                oldCe.dispose();
            }
            cellEditors[index] = ce;
        }
    }

    protected CellEditor getCellEditor() {
        CellEditor[] cellEditors = this.tableViewer.getCellEditors();
        int index = this.getColumnIndex();
        if (index >= 0 && index < cellEditors.length) {
            return cellEditors[index];
        }
        return null;
    }

    @Override
    public CellEditor createCellEditor(Composite parent) {
        Object ce = null;
        if (this.editable && this.feature != null) {
            EClassifier ec = this.feature.getEType();
            Class ic = ec.getInstanceClass();
            if (Boolean.TYPE.equals(ic)) {
                ce = new CustomCheckboxCellEditor(parent);
            } else if (ec instanceof EEnum) {
                ce = new CustomComboBoxCellEditor(parent, this.feature);
            } else if (ModelUtil.isMultiChoice(this.feature.eContainer(), this.feature)) {
                ce = new CustomComboBoxCellEditor(parent, this.feature);
            } else if (ec instanceof EDataType) {
                ce = new PropertyDescriptor.EDataTypeCellEditor((EDataType)ec, parent);
                ce.setValidator((ICellEditorValidator)new CustomDataTypeValidator());
            } else if (ic == EObject.class) {
                ce = new StringWrapperCellEditor(parent);
            }
        }
        return ce;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean canModify(Object element, String property) {
        if (this.editable && this.listComposite.getColumnProvider().canModify(this.object, this.feature, (EObject)element)) {
            CellEditor ce = this.getCellEditor();
            return ce != null;
        }
        return false;
    }

    public void modify(Object element, String property, Object value) {
        this.modify((EObject)element, this.feature, value);
    }

    protected void modify(EObject object, EStructuralFeature feature, Object value) {
        boolean result;
        CellEditor ce = this.getCellEditor();
        if (ce instanceof CustomComboBoxCellEditor) {
            value = ((CustomComboBoxCellEditor)ce).getChoice(value);
        }
        if (result = ModelUtil.setValue(this.getEditingDomain(), object, feature, value)) {
            this.tableViewer.refresh((Object)object);
        }
    }

    public Object getValue(Object element, String property) {
        CellEditor ce = this.getCellEditor();
        if (element instanceof EObject) {
            if (ce instanceof CustomCheckboxCellEditor) {
                return ce.getValue();
            }
            if (ce instanceof CustomComboBoxCellEditor) {
                return ce.getValue();
            }
            EObject object = (EObject)element;
            return object.eGet(this.feature);
        }
        return this.getText(element);
    }

    protected DiagramEditor getDiagramEditor() {
        return this.listComposite.getDiagramEditor();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.getDiagramEditor().getEditingDomain();
    }

    public static class CustomCheckboxCellEditor
    extends ComboBoxCellEditor {
        private static String[] items = new String[]{"false", "true"};

        public CustomCheckboxCellEditor(Composite parent) {
            super(parent, items, 8);
        }

        public String[] getItems() {
            return items;
        }

        public void setItems(String[] items) {
            super.setItems(CustomCheckboxCellEditor.items);
        }

        protected Object doGetValue() {
            Integer value = (Integer)super.doGetValue();
            return new Boolean(value != 0);
        }

        protected void doSetValue(Object value) {
            if (value instanceof Boolean) {
                value = new Integer((Boolean)value != false ? 1 : 0);
            } else if (value instanceof String) {
                int i = 0;
                while (i < items.length) {
                    if (value.equals(items[i])) {
                        value = new Integer(i);
                        break;
                    }
                    ++i;
                }
            }
            super.doSetValue(value);
        }
    }

    public class CustomComboBoxCellEditor
    extends ComboBoxCellEditor {
        protected Hashtable<String, Object> choices;

        public CustomComboBoxCellEditor(Composite parent, EStructuralFeature feature) {
            super(parent, new String[]{""}, 8);
            this.choices = null;
        }

        public void activate(ColumnViewerEditorActivationEvent activationEvent) {
            Object element;
            Object source = activationEvent.getSource();
            if (source instanceof ViewerCell && (element = ((ViewerCell)source).getElement()) instanceof EObject) {
                EObject object = (EObject)element;
                Object current = object.eGet(TableColumn.this.feature);
                this.setValue(object, TableColumn.this.feature, current);
            }
        }

        public void setValue(EObject object, EStructuralFeature feature, Object current) {
            ArrayList<String> items = new ArrayList<String>();
            this.choices = ModelUtil.getChoiceOfValues(object, feature);
            if (ModelUtil.canSetNull(object, feature)) {
                items.add("");
            }
            items.addAll(this.choices.keySet());
            Collections.sort(items);
            this.setItems(items.toArray(new String[items.size()]));
            int index = -1;
            int i = 0;
            while (i < items.size()) {
                if (current == this.choices.get(items.get(i))) {
                    index = i;
                    break;
                }
                if (current instanceof String && current.equals(items.get(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.setValue(new Integer(index));
        }

        public Object getChoice(Object value) {
            Assert.isTrue((this.choices != null && value instanceof Integer ? 1 : 0) != 0);
            int index = (Integer)value;
            if (index >= 0) {
                String[] items = ((ComboBoxCellEditor)TableColumn.this.getCellEditor()).getItems();
                value = this.choices.get(items[index]);
            } else {
                value = null;
            }
            return value;
        }
    }

    public class CustomDataTypeValidator
    implements ICellEditorValidator {
        public String isValid(Object value) {
            return null;
        }
    }

    public class StringWrapperCellEditor
    extends TextCellEditor {
        public StringWrapperCellEditor(Composite parent) {
            super(parent);
        }

        protected Object doGetValue() {
            String value = (String)super.doGetValue();
            return ModelUtil.createStringWrapper(value);
        }

        protected void doSetValue(Object value) {
            value = value == null ? "" : ModelUtil.getStringWrapperValue(value);
            super.doSetValue(value);
        }
    }
}

