/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ModelSubclassSelectionDialog;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class DefaultListComposite
extends AbstractListComposite {
    protected EClass listItemClass;

    public DefaultListComposite(AbstractBpmn2PropertySection section, int style) {
        super(section, style);
    }

    public DefaultListComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public DefaultListComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected EObject addListItem(EObject object, EStructuralFeature feature) {
        EList list = (EList)object.eGet(feature);
        EClass listItemClass = this.getListItemClass(object, feature);
        EObject newItem = null;
        if (!(list instanceof EObjectContainmentEList)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DefaultListComposite_Internal_Error_Title, (String)NLS.bind((String)Messages.DefaultListComposite_Error_Internal_Error_Message_No_List, (Object)listItemClass.getName()));
            return null;
        }
        if (listItemClass == null && (listItemClass = this.getListItemClassToAdd(listItemClass)) == null) {
            return null;
        }
        newItem = Bpmn2ModelerFactory.createFeature(object, feature, listItemClass);
        if (newItem == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DefaultListComposite_Internal_Error_Title, (String)NLS.bind((String)Messages.DefaultListComposite_Internal_Error_Message_No_Factory, (Object)listItemClass.getName()));
        } else if (!list.contains((Object)newItem)) {
            list.add((Object)newItem);
        }
        return newItem;
    }

    public EClass getListItemClassToAdd(EClass listItemClass) {
        EClass eclass = null;
        ModelSubclassSelectionDialog dialog = new ModelSubclassSelectionDialog(this.getDiagramEditor(), this.businessObject, this.feature);
        if (dialog.open() == 0) {
            eclass = (EClass)dialog.getResult()[0];
        }
        return eclass;
    }

    @Override
    public AbstractDetailComposite createDetailComposite(Class eClass, Composite parent, int style) {
        AbstractDetailComposite composite = PropertiesCompositeFactory.INSTANCE.createDetailComposite(eClass, parent, 0);
        return composite;
    }

    @Override
    protected EObject editListItem(EObject object, EStructuralFeature feature) {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.DefaultListComposite_Internal_Error_Title, (String)NLS.bind((String)Messages.DefaultListComposite_Internal_Error_Message_No_Editor, (Object)ModelUtil.getDisplayName(object, feature)));
        return null;
    }

    @Override
    protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        int[] map = this.buildIndexMap(object, feature);
        if (list instanceof EObjectContainmentEList && !this.canDelete((EObject)list.get(map[index]))) {
            return null;
        }
        EObject selected = null;
        if (index < map.length - 1) {
            selected = (EObject)list.get(map[index + 1]);
        }
        list.remove(map[index]);
        return selected;
    }

    @Override
    protected Object deleteListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        int[] map = this.buildIndexMap(object, feature);
        EObject removed = (EObject)list.get(map[index]);
        if (list instanceof EObjectContainmentEList && !this.canDelete(removed)) {
            return null;
        }
        EObject selected = null;
        if (index < map.length - 1) {
            selected = (EObject)list.get(map[index + 1]);
        }
        EcoreUtil.delete((EObject)removed, (boolean)true);
        return selected;
    }

    protected Object getListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        int[] map = this.buildIndexMap(object, feature);
        return list.get(map[index]);
    }

    @Override
    protected Object moveListItemUp(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        int[] map = this.buildIndexMap(object, feature);
        if (index > 0) {
            list.move(map[index - 1], map[index]);
            return list.get(map[index - 1]);
        }
        return null;
    }

    @Override
    protected Object moveListItemDown(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        int[] map = this.buildIndexMap(object, feature);
        if (index < map.length - 1) {
            list.move(map[index + 1], map[index]);
            return list.get(map[index + 1]);
        }
        return null;
    }

    @Override
    public void setListItemClass(EClass clazz) {
        this.listItemClass = clazz;
    }

    @Override
    public EClass getListItemClass(EObject object, EStructuralFeature feature) {
        return this.listItemClass;
    }

    protected boolean canDelete(EObject objectToDelete) {
        ArrayList<EObject> allDeleted = new ArrayList<EObject>();
        allDeleted.add(objectToDelete);
        TreeIterator iter = objectToDelete.eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            allDeleted.add(o);
        }
        ArrayList<EObject> references = new ArrayList<EObject>();
        Definitions definitions = ModelUtil.getDefinitions(objectToDelete);
        iter = definitions.eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            block2: for (EReference reference : o.eClass().getEAllReferences()) {
                if (reference.isContainment() || o instanceof DiagramElement) continue;
                if (reference.isMany()) {
                    List refList = (List)o.eGet((EStructuralFeature)reference);
                    for (Object referencedObject : refList) {
                        if (!allDeleted.contains(referencedObject)) continue;
                        references.add(o);
                        continue block2;
                    }
                    continue;
                }
                Object referencedObject = o.eGet((EStructuralFeature)reference);
                if (!allDeleted.contains(referencedObject)) continue;
                references.add(o);
            }
        }
        if (references.size() > 0) {
            ListDialog dlg = new ListDialog(this.getShell());
            ReferencingObjectListProvider provider = new ReferencingObjectListProvider(references);
            dlg.setContentProvider((IStructuredContentProvider)provider);
            dlg.setLabelProvider((ILabelProvider)provider);
            dlg.setInput(references);
            dlg.setMessage(NLS.bind((String)Messages.DefaultListComposite_Cannot_Delete_Message, (Object)ModelUtil.getLabel(objectToDelete)));
            dlg.setAddCancelButton(false);
            dlg.setTitle(Messages.DefaultListComposite_Cannot_Delete_Title);
            dlg.open();
            return false;
        }
        return true;
    }

    protected class ReferencingObjectListProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        List<EObject> references;

        public ReferencingObjectListProvider(List<EObject> references) {
            this.references = references;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String type = ModelUtil.getLabel(element);
            String name = ModelUtil.getDisplayName(element);
            return String.valueOf(type) + ": " + name;
        }

        public Object[] getElements(Object inputElement) {
            return this.references.toArray();
        }
    }
}

