/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.participant;

import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.ParticipantMultiplicity;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class UpdateParticipantMultiplicityFeature
extends AbstractUpdateFeature {
    public static final String MULTIPLICITY_MARKER = "multiplicity.marker";

    public UpdateParticipantMultiplicityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        PictogramElement containerElem;
        EObject container = context.getPictogramElement().eContainer();
        if (container instanceof PictogramElement && BusinessObjectUtil.containsElementOfType(containerElem = (PictogramElement)container, ChoreographyActivity.class)) {
            return false;
        }
        return BusinessObjectUtil.containsElementOfType(context.getPictogramElement(), Participant.class) && context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement containerElem;
        EObject container = context.getPictogramElement().eContainer();
        if (container instanceof PictogramElement && BusinessObjectUtil.containsElementOfType(containerElem = (PictogramElement)container, ChoreographyActivity.class)) {
            return Reason.createFalseReason();
        }
        if (!(context.getPictogramElement() instanceof ContainerShape)) {
            return Reason.createFalseReason();
        }
        IPeService peService = Graphiti.getPeService();
        Participant participant = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), Participant.class);
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        boolean multiplicityProperty = new Boolean(peService.getPropertyValue((PropertyContainer)containerShape, "multiplicity"));
        boolean hasMultiplicity = false;
        ParticipantMultiplicity pm = participant.getParticipantMultiplicity();
        if (pm != null && pm.getMaximum() > 1) {
            hasMultiplicity = true;
        }
        return multiplicityProperty != hasMultiplicity ? Reason.createTrueReason() : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        Participant participant = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), Participant.class);
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        boolean hasMultiplicity = false;
        ParticipantMultiplicity pm = participant.getParticipantMultiplicity();
        if (pm != null && pm.getMaximum() > 1) {
            Shape shape = peService.createShape(containerShape, false);
            peService.setPropertyValue((PropertyContainer)shape, MULTIPLICITY_MARKER, Boolean.toString(true));
            Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)shape);
            GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
            int x = parentGa.getWidth() / 2 - 10;
            int y = parentGa.getHeight() - 20;
            gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x, y, 20, 20);
            int[] nArray = new int[4];
            nArray[3] = 15;
            Polyline line1 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRectangle, nArray);
            line1.setLineWidth(Integer.valueOf(2));
            line1.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            int[] nArray2 = new int[4];
            nArray2[0] = 5;
            nArray2[2] = 5;
            nArray2[3] = 15;
            Polyline line2 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRectangle, nArray2);
            line2.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            line2.setLineWidth(Integer.valueOf(2));
            int[] nArray3 = new int[4];
            nArray3[0] = 10;
            nArray3[2] = 10;
            nArray3[3] = 15;
            Polyline line3 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRectangle, nArray3);
            line3.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            line3.setLineWidth(Integer.valueOf(2));
            hasMultiplicity = true;
        } else {
            Shape shape = FeatureSupport.getShape(containerShape, MULTIPLICITY_MARKER, Boolean.toString(true));
            if (shape != null) {
                peService.deletePictogramElement((PictogramElement)shape);
            }
        }
        peService.setPropertyValue((PropertyContainer)containerShape, "multiplicity", hasMultiplicity ? Boolean.toString(true) : Boolean.toString(false));
        return true;
    }
}

