/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.participant;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutParticipantFeature
extends DefaultLayoutBPMNShapeFeature {
    public LayoutParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
        return bo != null && bo instanceof Participant;
    }

    @Override
    public boolean layout(ILayoutContext context) {
        GraphicsAlgorithm ga;
        Shape shape2;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        IGaService gaService = Graphiti.getGaService();
        boolean horz = FeatureSupport.isHorizontal(containerShape);
        int containerHeight = containerGa.getHeight();
        int containerWidth = containerGa.getWidth();
        for (Shape shape2 : containerShape.getChildren()) {
            Text text;
            ga = shape2.getGraphicsAlgorithm();
            gaService.calculateSize(ga);
            if (ga instanceof Polyline) {
                Polyline line = (Polyline)ga;
                Point p0 = (Point)line.getPoints().get(0);
                Point p1 = (Point)line.getPoints().get(1);
                if (horz) {
                    p0.setX(30);
                    p0.setY(0);
                    p1.setX(30);
                    p1.setY(containerHeight);
                    continue;
                }
                p0.setX(0);
                p0.setY(30);
                p1.setX(containerWidth);
                p1.setY(30);
                continue;
            }
            if (!(ga instanceof Text)) continue;
            if (horz) {
                text = (Text)ga;
                text.setAngle(Integer.valueOf(-90));
                gaService.setLocationAndSize(ga, 5, 0, 15, containerHeight);
                continue;
            }
            text = (Text)ga;
            text.setAngle(Integer.valueOf(0));
            gaService.setLocationAndSize(ga, 0, 5, containerWidth, 15);
        }
        shape2 = FeatureSupport.getShape(containerShape, "multiplicity.marker", Boolean.toString(true));
        if (shape2 != null) {
            ga = shape2.getGraphicsAlgorithm();
            int x = containerGa.getWidth() / 2 - 10;
            int y = containerGa.getHeight() - 20;
            gaService.setLocation(ga, x, y);
        }
        DIUtils.updateDIShape((PictogramElement)containerShape);
        GraphicsUtil.sendToBack((Shape)containerShape);
        return super.layout(context);
    }
}

