/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromDiagramToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromDiagramToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromLaneToDiagramFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromLaneToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromLaneToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromParticipantToDiagramFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromParticipantToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveFromParticipantToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveLaneFeature
extends DefaultMoveBPMNShapeFeature {
    private MoveLaneFeature moveStrategy;

    public MoveLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        if (context.getSourceContainer() == null) {
            return false;
        }
        this.moveStrategy = this.getStrategy(context);
        if (this.moveStrategy == null) {
            return super.canMoveShape(context);
        }
        return this.moveStrategy.canMoveShape(context);
    }

    protected void internalMove(IMoveShapeContext context) {
        super.internalMove(context);
        if (this.moveStrategy != null) {
            this.moveStrategy.internalMove(context);
        }
    }

    private MoveLaneFeature getStrategy(IMoveShapeContext context) {
        if (context.getSourceContainer().equals(this.getDiagram())) {
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromDiagramToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromDiagramToParticipantFeature(this.getFeatureProvider());
            }
        } else if (FeatureSupport.isLane((PictogramElement)context.getSourceContainer())) {
            if (context.getTargetContainer().equals(this.getDiagram())) {
                return new MoveFromLaneToDiagramFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromLaneToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromLaneToParticipantFeature(this.getFeatureProvider());
            }
        } else if (FeatureSupport.isParticipant((PictogramElement)context.getSourceContainer())) {
            if (context.getTargetContainer().equals(this.getDiagram())) {
                return new MoveFromParticipantToDiagramFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromParticipantToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromParticipantToParticipantFeature(this.getFeatureProvider());
            }
        }
        return null;
    }

    protected Lane getMovedLane(IMoveShapeContext context) {
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
    }
}

