/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import java.io.IOException;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveLaneFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromLaneToLaneFeature
extends MoveLaneFeature {
    public MoveFromLaneToLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        if (targetLane.getFlowNodeRefs() != null && targetLane.getFlowNodeRefs().size() > 0) {
            return false;
        }
        Lane movedLane = this.getMovedLane(context);
        return targetLane.getChildLaneSet() == null || !targetLane.getChildLaneSet().getLanes().contains(movedLane);
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        Lane sourceLane = this.getSourceLane(context);
        this.modifyModelStructure(sourceLane, targetLane, movedLane);
        FeatureSupport.redraw(context.getSourceContainer());
        FeatureSupport.redraw(context.getTargetContainer());
    }

    private void modifyModelStructure(Lane sourceLane, Lane targetLane, Lane movedLane) {
        if (targetLane.getChildLaneSet() == null) {
            LaneSet createLaneSet = Bpmn2ModelerFactory.create(LaneSet.class);
            targetLane.setChildLaneSet(createLaneSet);
            ModelUtil.setID((EObject)createLaneSet);
        }
        try {
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            Participant sourceParticipant = handler.getParticipant(sourceLane);
            Participant targetParticipant = handler.getParticipant(targetLane);
            if (!sourceParticipant.equals(targetParticipant)) {
                handler.moveLane(movedLane, sourceParticipant, targetParticipant);
            }
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        targetLane.getChildLaneSet().getLanes().add(movedLane);
        sourceLane.getChildLaneSet().getLanes().remove(movedLane);
        if (sourceLane.getChildLaneSet().getLanes().isEmpty()) {
            sourceLane.setChildLaneSet(null);
        }
    }

    private Lane getTargetLane(ITargetContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
    }

    private Lane getSourceLane(IMoveShapeContext context) {
        ContainerShape sourceContainer = context.getSourceContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer);
    }
}

