/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import java.io.IOException;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveLaneFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromDiagramToParticipantFeature
extends MoveLaneFeature {
    public MoveFromDiagramToParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        Participant p = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (this.getMovedLane(context).getFlowNodeRefs().isEmpty()) {
            return true;
        }
        if (p.getProcessRef() == null) {
            return true;
        }
        return !p.getProcessRef().getLaneSets().isEmpty();
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        this.modifyModelStructure(context);
        FeatureSupport.redraw(context.getTargetContainer());
    }

    private void modifyModelStructure(IMoveShapeContext context) {
        try {
            Participant targetParticipant = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            Lane movedLane = this.getMovedLane(context);
            handler.moveLane(movedLane, targetParticipant);
            Participant internalParticipant = handler.getParticipant(this.getDiagram());
            LaneSet laneSet = null;
            for (LaneSet set : internalParticipant.getProcessRef().getLaneSets()) {
                if (!set.getLanes().contains(movedLane)) continue;
                laneSet = set;
                break;
            }
            if (laneSet != null) {
                Process process;
                laneSet.getLanes().remove(movedLane);
                if (laneSet.getLanes().isEmpty()) {
                    internalParticipant.getProcessRef().getLaneSets().remove(laneSet);
                }
                if ((process = targetParticipant.getProcessRef()).getLaneSets().isEmpty()) {
                    LaneSet claneSet = Bpmn2ModelerFactory.create(LaneSet.class);
                    process.getLaneSets().add(claneSet);
                    ModelUtil.setID((EObject)claneSet);
                }
                ((LaneSet)process.getLaneSets().get(0)).getLanes().add(movedLane);
            }
        }
        catch (IOException e) {
            Activator.logError(e);
        }
    }
}

