/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.lane.Messages;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DirectEditLaneFeature
extends AbstractDirectEditingFeature {
    public DirectEditLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Lane lane = (Lane)this.getBusinessObjectForPictogramElement(pe);
        return lane.getName();
    }

    public void setValue(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Lane lane = (Lane)this.getBusinessObjectForPictogramElement(pe);
        lane.setName(value);
        this.updatePictogramElement((PictogramElement)((Shape)pe).getContainer());
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value.length() < 1) {
            return Messages.DirectEditLaneFeature_Invalid_Empty;
        }
        if (value.contains("\n")) {
            return Messages.DirectEditLaneFeature_Invalid_Linebreak;
        }
        return null;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return bo instanceof Lane && ga instanceof Text;
    }

    public boolean stretchFieldToFitText() {
        return true;
    }
}

