/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.label.Messages;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class UpdateLabelFeature
extends AbstractUpdateFeature {
    public static final String TEXT_ELEMENT = "baseelement.text";

    public UpdateLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        BaseElement element = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
        if (element == null) {
            return false;
        }
        return ModelUtil.hasName(element);
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement container = context.getPictogramElement();
        BaseElement element = BusinessObjectUtil.getFirstElementOfType(container, BaseElement.class);
        Shape textShape = FeatureSupport.getChildElementOfType(container, TEXT_ELEMENT, Boolean.toString(true), Shape.class);
        if (textShape != null) {
            String oldLabel = ModelUtil.getName(element);
            if (oldLabel == null || oldLabel.isEmpty()) {
                oldLabel = "";
            }
            String newLabel = "";
            if (textShape.getGraphicsAlgorithm() instanceof AbstractText) {
                AbstractText text = (AbstractText)textShape.getGraphicsAlgorithm();
                newLabel = text.getValue();
            }
            if (newLabel == null || newLabel.isEmpty()) {
                newLabel = "";
            }
            if (!oldLabel.equals(newLabel)) {
                return Reason.createTrueReason((String)Messages.UpdateLabelFeature_Label);
            }
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        BaseElement element = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
        Shape textShape = FeatureSupport.getChildElementOfType(pe, TEXT_ELEMENT, Boolean.toString(true), Shape.class);
        if (textShape != null) {
            AbstractText text = (AbstractText)textShape.getGraphicsAlgorithm();
            String name = ModelUtil.getName(element);
            if (name == null) {
                name = "";
            }
            text.setValue(name);
            this.layoutPictogramElement(context.getPictogramElement());
        }
        if (pe instanceof ContainerShape) {
            IGaService gaService = Graphiti.getGaService();
            ContainerShape container = (ContainerShape)pe;
            Shape shape = (Shape)container.getChildren().get(0);
            if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) {
                return true;
            }
            GraphicsAlgorithm textGA = container.getGraphicsAlgorithm();
            AbstractText text = (AbstractText)shape.getGraphicsAlgorithm();
            int oldWidth = textGA.getWidth() - 6;
            int x = textGA.getX() + (oldWidth + 6) / 2;
            int y = textGA.getY();
            BaseElement o = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
            String name = ModelUtil.getName(o);
            if (name == null) {
                gaService.setLocationAndSize(textGA, x, y, 0, 0);
                gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, 0, 0);
                container.setVisible(false);
            } else {
                int newWidth = GraphicsUtil.getLabelWidth(text);
                int newHeight = GraphicsUtil.getLabelHeight(text);
                gaService.setLocationAndSize(textGA, x -= (newWidth + 6) / 2, y, newWidth + 6, newHeight + 6);
                gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, newWidth + 5, newHeight + 5);
                container.setVisible(true);
            }
        }
        return true;
    }
}

