/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddLabelFeature
extends AbstractAddShapeFeature {
    public AddLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        IGaService gaService = Graphiti.getGaService();
        IPeService peService = Graphiti.getPeService();
        int width = (Integer)context.getProperty((Object)"width");
        int height = (Integer)context.getProperty((Object)"height");
        int x = context.getX();
        int y = context.getY();
        BaseElement baseElement = (BaseElement)context.getProperty((Object)"businessObject");
        ContainerShape targetContainer = this.getTargetContainer(context);
        PictogramElement labelOwner = (PictogramElement)context.getProperty((Object)"labelOwner");
        ContainerShape textContainerShape = peService.createContainerShape(targetContainer, true);
        gaService.createInvisibleRectangle((PictogramElement)textContainerShape);
        Shape textShape = peService.createShape(textContainerShape, false);
        peService.setPropertyValue((PropertyContainer)textShape, "baseelement.text", Boolean.toString(true));
        String name = ModelUtil.getDisplayName(baseElement);
        MultiText text = gaService.createDefaultMultiText(this.getDiagram(), (GraphicsAlgorithmContainer)textShape, name);
        StyleUtil.applyStyle((GraphicsAlgorithm)text, baseElement);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        this.link((PictogramElement)textShape, baseElement);
        if (baseElement instanceof BoundaryEvent && !this.isImport(context)) {
            x = context.getTargetContainer().getGraphicsAlgorithm().getX() + context.getX() - width / 2;
            y = context.getTargetContainer().getGraphicsAlgorithm().getY() + context.getY() - height / 2;
        }
        GraphicsUtil.alignWithShape((AbstractText)text, textContainerShape, width, height, x, y, 0, 0);
        if (labelOwner != null) {
            this.link(labelOwner, new Object[]{textContainerShape});
            this.link((PictogramElement)textContainerShape, new Object[]{baseElement, labelOwner});
        } else {
            this.link((PictogramElement)textContainerShape, baseElement);
        }
        Graphiti.getPeService().setPropertyValue((PropertyContainer)textContainerShape, "label", "true");
        this.updatePictogramElement((PictogramElement)textContainerShape);
        this.layoutPictogramElement((PictogramElement)textContainerShape);
        return textContainerShape;
    }

    private boolean isImport(IAddContext context) {
        return context.getProperty((Object)DIImport.IMPORT_PROPERTY) == null ? false : (Boolean)context.getProperty((Object)DIImport.IMPORT_PROPERTY);
    }

    ContainerShape getTargetContainer(IAddContext context) {
        boolean isBoundary = context.getProperty((Object)"businessObject") instanceof BoundaryEvent;
        if (isBoundary && !this.isImport(context) && context.getTargetContainer() != null) {
            return context.getTargetContainer().getContainer();
        }
        return context.getTargetContainer();
    }
}

