/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event.definitions;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.DecorationAlgorithm;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateEventDefinitionFeature
extends AbstractUpdateFeature {
    public AbstractUpdateEventDefinitionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void draw(Event event, ContainerShape container) {
        if (FeatureSupport.isLabelShape((Shape)container)) {
            return;
        }
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(event);
        int size = eventDefinitions.size();
        GraphicsUtil.deleteEventShape(container);
        if (size == 1) {
            Shape addedShape = this.getDecorationAlgorithm(event).draw(container);
            this.link((PictogramElement)addedShape, eventDefinitions.get(0));
        } else if (size > 1) {
            Shape multipleShape = Graphiti.getPeService().createShape(container, false);
            this.drawForEvent(event, multipleShape);
            this.link((PictogramElement)multipleShape, eventDefinitions.toArray(new EventDefinition[size]));
        }
    }

    public abstract DecorationAlgorithm getDecorationAlgorithm(Event var1);

    private void drawForEvent(Event event, Shape shape) {
        if (event instanceof CatchEvent && ((CatchEvent)event).isParallelMultiple()) {
            this.drawParallelMultiple(event, shape);
        } else {
            this.drawMultiple(event, shape);
        }
    }

    private void drawMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon pentagon = GraphicsUtil.createEventPentagon(shape);
        if (event instanceof ThrowEvent) {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_FOREGROUND);
        } else {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        }
        StyleUtil.applyStyle((GraphicsAlgorithm)pentagon, be);
    }

    private void drawParallelMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon cross = GraphicsUtil.createEventParallelMultiple(shape);
        StyleUtil.setFillStyle((GraphicsAlgorithm)cross, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        StyleUtil.applyStyle((GraphicsAlgorithm)cross, be);
    }
}

