/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event;

import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractUpdateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateEventFeature
extends AbstractUpdateMarkerFeature<Event> {
    public AbstractUpdateEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected boolean isPropertyChanged(Event element, String propertyValue) {
        return !AbstractUpdateEventFeature.getEventDefinitionsValue(element).equals(propertyValue);
    }

    @Override
    protected void doUpdate(Event event, ContainerShape container) {
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(event);
        int size = eventDefinitions.size();
        if (size != 0) {
            EventDefinition eventDefinition = eventDefinitions.get(0);
            Shape eventDefinitionShape = null;
            for (PictogramElement pe : container.getChildren()) {
                EList objects;
                if (pe.getLink() == null || (objects = pe.getLink().getBusinessObjects()).size() <= 0 || !(objects.get(0) instanceof EventDefinition)) continue;
                eventDefinition = (EventDefinition)objects.get(0);
                eventDefinitionShape = pe;
                break;
            }
            if (eventDefinitionShape == null) {
                eventDefinitionShape = Graphiti.getPeService().createShape(container, true);
                Graphiti.getCreateService().createRectangle((GraphicsAlgorithmContainer)eventDefinitionShape);
                this.link((PictogramElement)eventDefinitionShape, eventDefinition);
            }
            UpdateContext context = new UpdateContext(eventDefinitionShape);
            IUpdateFeature upateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (upateFeature != null) {
                context = new UpdateContext((PictogramElement)container);
                upateFeature.update((IUpdateContext)context);
            }
        } else {
            GraphicsUtil.deleteEventShape(container);
        }
    }

    @Override
    protected String convertPropertyToString(Event element) {
        return AbstractUpdateEventFeature.getEventDefinitionsValue(element);
    }

    public static String getEventDefinitionsValue(Event element) {
        String result = "";
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(element);
        for (EventDefinition ed : eventDefinitions) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + ed.getId();
        }
        if (element instanceof CatchEvent && ((CatchEvent)element).isParallelMultiple()) {
            result = String.valueOf(result) + "+";
        }
        return result;
    }
}

