/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.data;

import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class MoveDataFeature
extends DefaultMoveBPMNShapeFeature {
    public MoveDataFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
        if (bo instanceof ItemAwareElement && bo instanceof FlowElement && FeatureSupport.isValidDataTarget((ITargetContext)context)) {
            return true;
        }
        return super.canMoveShape(context);
    }

    @Override
    protected void postMoveShape(IMoveShapeContext context) {
        ContainerShape targetContainer;
        Shape shape = context.getShape();
        FlowElement dataElement = (FlowElement)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape);
        ContainerShape sourceContainer = context.getSourceContainer();
        if (sourceContainer != (targetContainer = context.getTargetContainer())) {
            EObject targetObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
            if (targetObject instanceof BPMNDiagram) {
                targetObject = ((BPMNDiagram)targetObject).getPlane().getBpmnElement();
            }
            if (targetObject instanceof Lane) {
                while (targetObject != null) {
                    if ((targetObject = targetObject.eContainer()) instanceof FlowElementsContainer) break;
                }
            }
            if (targetObject instanceof Collaboration && !(targetObject instanceof Choreography)) {
                Collaboration collaboration = (Collaboration)targetObject;
                for (Participant p : collaboration.getParticipants()) {
                    if (p.getProcessRef() == null) continue;
                    targetObject = p.getProcessRef();
                    break;
                }
            }
            if (targetObject instanceof Participant) {
                targetObject = ((Participant)targetObject).getProcessRef();
            }
            if (targetObject instanceof FlowElementsContainer) {
                ((FlowElementsContainer)targetObject).getFlowElements().add(dataElement);
            }
        }
        super.postMoveShape(context);
    }
}

