/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.modeler.core.features.choreography.Messages;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateChoreographyNameFeature
extends AbstractUpdateFeature {
    private static final IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyNameFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return BusinessObjectUtil.containsElementOfType(context.getPictogramElement(), ChoreographyActivity.class);
    }

    public IReason updateNeeded(IUpdateContext context) {
        ChoreographyActivity activity = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), ChoreographyActivity.class);
        if (activity.getName().equals(this.getBodyText(context).getValue())) {
            return Reason.createFalseReason();
        }
        return Reason.createTrueReason((String)Messages.UpdateChoreographyNameFeature_Name);
    }

    public boolean update(IUpdateContext context) {
        ChoreographyActivity task = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), ChoreographyActivity.class);
        this.getBodyText(context).setValue(task.getName());
        return true;
    }

    private AbstractText getBodyText(IUpdateContext context) {
        for (Shape shape : peService.getAllContainedShapes((ContainerShape)context.getPictogramElement())) {
            String property = peService.getPropertyValue((PropertyContainer)shape, "choreography.name");
            if (property == null || !Boolean.parseBoolean(property)) continue;
            return (AbstractText)shape.getGraphicsAlgorithm();
        }
        return null;
    }
}

